/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.security.cert.PolicyQualifierInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CertificatePolicies
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.32");
    private final List policies;
    private final Map policyQualifierInfos;
    static /* synthetic */ Class class$gnu$java$security$x509$ext$CertificatePolicies;

    public List getPolicies() {
        return this.policies;
    }

    public List getPolicyQualifierInfos(OID oID) {
        return (List)this.policyQualifierInfos.get(oID);
    }

    public byte[] getEncoded() {
        if (this.encoded == null) {
            ArrayList arrayList = new ArrayList(this.policies.size());
            Iterator iterator = this.policies.iterator();
            while (iterator.hasNext()) {
                OID oID = (OID)iterator.next();
                List list2 = this.getPolicyQualifierInfos(oID);
                int n = 0;
                if (list2 == null) {
                    n = 1;
                }
                ArrayList arrayList2 = new ArrayList(2 - n);
                arrayList2.add(new DERValue(6, oID));
                if (list2 != null) {
                    ArrayList arrayList3 = new ArrayList(list2.size());
                    Iterator iterator2 = list2.iterator();
                    while (iterator.hasNext()) {
                        PolicyQualifierInfo policyQualifierInfo = (PolicyQualifierInfo)iterator2.next();
                        try {
                            arrayList3.add(DERReader.read(policyQualifierInfo.getEncoded()));
                        }
                        catch (IOException iOException) {}
                    }
                    arrayList2.add(new DERValue(48, arrayList3));
                }
                arrayList.add(new DERValue(48, arrayList2));
            }
            this.encoded = new DERValue(48, arrayList).getEncoded();
        }
        return (byte[])this.encoded.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$gnu$java$security$x509$ext$CertificatePolicies;
        if (clazz == null) {
            clazz = class$gnu$java$security$x509$ext$CertificatePolicies = CertificatePolicies.class("[Lgnu.java.security.x509.ext.CertificatePolicies;", false);
        }
        return stringBuffer.append(clazz.getName()).append(" [ policies=").append(this.policies).append(" policyQualifierInfos=").append(this.policyQualifierInfos).append(" ]").toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public CertificatePolicies(byte[] byArray) throws IOException {
        super(byArray);
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed CertificatePolicies");
        }
        int n = 0;
        LinkedList linkedList = new LinkedList();
        HashMap hashMap = new HashMap();
        while (n < dERValue.getLength()) {
            DERValue dERValue2 = dERReader.read();
            if (!dERValue2.isConstructed()) {
                throw new IOException("malformed PolicyInformation");
            }
            DERValue dERValue3 = dERReader.read();
            if (dERValue3.getTag() != 6) {
                throw new IOException("malformed CertPolicyId");
            }
            OID oID = (OID)dERValue3.getValue();
            linkedList.add(oID);
            if (dERValue3.getEncodedLength() < dERValue2.getLength()) {
                DERValue dERValue4 = dERReader.read();
                int n2 = 0;
                LinkedList linkedList2 = new LinkedList();
                while (n2 < dERValue4.getLength()) {
                    dERValue3 = dERReader.read();
                    linkedList2.add(new PolicyQualifierInfo(dERValue3.getEncoded()));
                    dERReader.skip(dERValue3.getLength());
                    n2 += dERValue3.getEncodedLength();
                }
                hashMap.put(oID, linkedList2);
            }
            n += dERValue2.getEncodedLength();
        }
        this.policies = Collections.unmodifiableList(linkedList);
        this.policyQualifierInfos = Collections.unmodifiableMap(hashMap);
    }

    public CertificatePolicies(List list2, Map map) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof OID) continue;
            throw new IllegalArgumentException("policies must be OIDs");
        }
        iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!(entry.getKey() instanceof OID) || !list2.contains(entry.getKey())) {
                throw new IllegalArgumentException("policyQualifierInfos keys must be OIDs");
            }
            if (!(entry.getValue() instanceof List)) {
                throw new IllegalArgumentException("policyQualifierInfos values must be Lists of PolicyQualifierInfos");
            }
            Iterator iterator2 = ((List)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                if (iterator2.next() instanceof PolicyQualifierInfo) continue;
                throw new IllegalArgumentException("policyQualifierInfos values must be Lists of PolicyQualifierInfos");
            }
        }
        this.policies = Collections.unmodifiableList(new ArrayList(list2));
        this.policyQualifierInfos = Collections.unmodifiableMap(new HashMap(map));
    }
}

