/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.BitSet;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;

public class NXTRecord
extends Record {
    private Name next;
    private BitSet bitmap;

    Record getObject() {
        return new NXTRecord();
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.next = new Name(dNSInput);
        this.bitmap = new BitSet();
        int n = dNSInput.remaining();
        int n2 = 0;
        while (n2 < n) {
            int n3 = dNSInput.readU8();
            int n4 = 0;
            while (n4 < 8) {
                if ((n3 & 1 << 7 - n4) != 0) {
                    this.bitmap.set(n2 * 8 + n4);
                }
                ++n4;
            }
            ++n2;
        }
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        Tokenizer.Token token;
        this.next = tokenizer.getName(name);
        this.bitmap = new BitSet();
        while ((token = tokenizer.get()).isString()) {
            int n = Type.value(token.value, true);
            if (n <= 0 || n > 128) {
                throw tokenizer.exception("Invalid type: " + token.value);
            }
            this.bitmap.set(n);
        }
        tokenizer.unget();
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.next);
        int n = this.bitmap.length();
        int n2 = 0;
        while (n2 < n) {
            if (this.bitmap.get(n2)) {
                stringBuffer.append(" ");
                stringBuffer.append(Type.string(n2));
            }
            n2 = (short)(n2 + 1);
        }
        return stringBuffer.toString();
    }

    public Name getNext() {
        return this.next;
    }

    public BitSet getBitmap() {
        return this.bitmap;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        this.next.toWire(dNSOutput, null, bl);
        int n = this.bitmap.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = 0;
            if (this.bitmap.get(n2)) {
                n4 = 1 << 7 - n2 % 8;
            }
            n3 |= n4;
            if (n2 % 8 == 7 || n2 == n - 1) {
                dNSOutput.writeU8(n3);
                n3 = 0;
            }
            ++n2;
        }
    }

    NXTRecord() {
    }

    public NXTRecord(Name name, int n, long l, Name name2, BitSet bitSet) {
        super(name, 30, n, l);
        this.next = NXTRecord.checkName("next", name2);
        this.bitmap = bitSet;
    }
}

