PK
     kh[g<      package.xmlUT	 EiEiux       <package>
  <name>GTK</name>
  <namespace>GTK</namespace>
  <prereq>Cairo</prereq>
  <module>gst-gtk</module>

  <filein>GtkDecl.st</filein>
  <filein>Structs.st</filein>
  <filein>MoreStructs.st</filein>
  <filein>Enums.st</filein>
  <filein>Funcs.st</filein>
  <filein>MoreFuncs.st</filein>
  <filein>GtkImpl.st</filein>
  <file>example_arrow.st</file>
  <file>example_aspectframe.st</file>
  <file>example_buttonbox.st</file>
  <file>example_entry.st</file>
  <file>example_eventbox.st</file>
  <file>example_hello.st</file>
  <file>example_tictactoe.st</file>
  <file>example_tree.st</file>
  <built-file>Structs.st</built-file>
  <built-file>Enums.st</built-file>
  <built-file>Funcs.st</built-file>
</package>PK
     B7
Xk
  k
  
  GtkDecl.stUT	 aQEiux       "======================================================================
|
|   Smalltalk Gtk+ bindings (loading script).
|
 ======================================================================"

"======================================================================
|
| Copyright 2001, 2003, 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"



Object subclass: Pango [
    
    <category: 'Gtk'>
    <comment: nil>
]



Object subclass: Gdk [
    
    <category: 'Gtk'>
    <comment: nil>
]



Object subclass: Gtk [
    
    <category: 'Gtk'>
    <comment: nil>
]



Object subclass: Atk [
    
    <category: 'Gtk'>
    <comment: nil>
]



Object subclass: GLib [
    
    <category: 'Gtk'>
    <comment: nil>

    GLib class [
	| gtkTypes |
	
    ]

    GLib class >> registerAllTypes [
	<category: 'registering GObject types'>
	gtkTypes isNil ifTrue: [gtkTypes := OrderedCollection new].
	gtkTypes do: [:each | self register: each forType: each getType]
    ]

    GLib class >> registerType: aClass [
	<category: 'registering GObject types'>
	gtkTypes isNil ifTrue: [gtkTypes := OrderedCollection new].
	gtkTypes addLast: aClass
    ]

    GLib class >> update: anObject [
	<category: 'registering GObject types'>
	anObject == #returnFromSnapshot ifTrue: [self registerAllTypes]
    ]
]



Object subclass: GQuark [
    
    <category: 'Gtk'>
    <comment: nil>
]



CObject subclass: GList [
    
    <shape: #word>
    <category: 'Gtk'>
    <comment: nil>
]



CObject subclass: GSList [
    
    <shape: #word>
    <category: 'Gtk'>
    <comment: nil>
]



CObject subclass: GdkEvent [
    
    <shape: #word>
    <category: 'Gtk'>
    <comment: nil>
]



Eval [
    ObjectMemory addDependent: GLib
]

PK
     B;
V  V    MoreStructs.stUT	 aQEiux       "======================================================================
|
|   Smalltalk Gtk+ bindings (declarations of some CStructs needing fields)
|
 ======================================================================"

"======================================================================
|
| Copyright 2004, 2008, 2009 Free Software Foundation, Inc.
| Written by Robert Collins.
|
| This file is part of the GNU Smalltalk class library.
| It contains manual struct definitions the automatic logic fails to create
|
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"



CStruct subclass: GTypeClass [
    
    <category: 'GTK'>
    <comment: nil>
    <declaration: #(#(#'g_type' #uLong ) )>
]



"FIXME: passing #cObjectPtr should be smarter or something"



CStruct subclass: GtkTreeModelPointer [
    
    <category: 'GTK'>
    <comment: nil>
    <declaration: #(#(#model #(#ptr #GtkTreeModel ) ) )>
]



CStruct subclass: GtkRequisition [
    
    <category: 'GTK'>
    <comment: nil>
    <declaration: #(#(#width #int ) #(#height #int ) )>
]



CStruct subclass: GList [
    
    <category: 'GTK'>
    <comment: nil>
    <declaration: #(#(#data #(#ptr #CObject ) ) #(#next #(#ptr #{GList} ) )
		    #(#prev #(#ptr #{GList} ) ) )>

    free [
        <category: 'C call-outs'>
        <cCall: 'g_list_free' returning: #void args: #(#self )>
    ]
]



CStruct subclass: GSList [
    
    <category: 'GTK'>
    <comment: nil>
    <declaration: #(#(#data #(#ptr #CObject ) ) #(#next #(#ptr #{GSList} ) ) )>

    free [
        <category: 'C call-outs'>
        <cCall: 'g_slist_free' returning: #void args: #(#self )>
    ]
]



CStruct subclass: GdkColor [

    <category: 'GDK'>
    <comment: nil>
    <declaration: #(#(#pixel #uint) #(#red #ushort) #(#green #ushort) #(#blue #ushort))>

]


"FIXME more events needed"



CStruct subclass: GdkEventButton [
    
    <category: 'GTK'>
    <comment: nil>
    <declaration: #(#(#type #uint ) #(#window #(#ptr #CObject ) ) #(#sendEvent #byte ) #(#time #uint ) #(#x #double ) #(#y #double ) #(#axes #(#ptr #double ) ) #(#state #uint ) #(#button #uint ) #(#device #(#ptr #CObject ) ) #(#xRoot #double ) #(#yRoot #double ) )>
]



CStruct subclass: GdkEventMotion [
    
    <category: 'GTK'>
    <comment: nil>
    <declaration: #(#(#type #uint ) #(#window #(#ptr #CObject ) ) #(#sendEvent #byte ) #(#time #uint ) #(#x #double ) #(#y #double ) #(#axes #(#ptr #double ) ) #(#state #uint ) #(#isHint #short ) #(#device #(#ptr #CObject ) ) #(#xRoot #double ) #(#yRoot #double ) )>
]



CStruct subclass: GdkEventConfigure [
    
    <category: 'GTK'>
    <comment: nil>
    <declaration: #(#(#type #uint ) #(#window #(#ptr #CObject ) ) #(#sendEvent #byte ) #(#x #int ) #(#y #int ) #(#width #int ) #(#height #int ) )>
]


CStruct subclass: GdkEventKey [

    <category: 'GTK'>
    <comment: nil>
    <declaration: #(#(#type #uint ) #(#window #(#ptr #CObject ) ) #(#sendEvent #byte ) #(#time #uint ) #(#state #uint ) #(#keyval #uint ) #(#length #int ) #(#string #string ) #(#hardwareKeycode #short ) #(#group #byte ) #(#isModifier #byte ) )>
]
PK
     BI      MoreFuncs.stUT	 aQEiux       GMainContext extend [
    iterate [
        <category: 'C call-outs'>
        <asyncCCall: 'gstGtkMainContextIterate' args: #(#self )>

    ]
]


Gtk class extend [

    main: aSemaphore [
	<category: 'C call-outs'>
	<cCall: 'gstGtkMain' returning: #{GMainLoop} args: #(#smalltalk )>
	
    ]

    gstGtkInit [
	"For backwards compatibility."
    ]

    gtkInitialized [
	<category: 'C call-outs'>
	<cCall: 'gtkInitialized' returning: #boolean args: #()>
    ]

]



GLib class extend [

    register: anObject forType: gType [
	<category: 'C call-outs'>
	<cCall: 'gstGtkRegisterForType' returning: #void
	args: #(#smalltalk #unknown )>
	
    ]

    oopType [
	<category: 'C call-outs'>
	<cCall: 'gstTypeOOP' returning: #long
	args: #()>
    ]
]



GObject extend [

    connectSignalAfter: name to: handler selector: sel userData: userData [
       <category: 'C call-outs'>
       <cCall: 'gstGtkConnectSignalAfter' returning: #int
       args: #(#selfSmalltalk #string #smalltalk #smalltalk #smalltalk )>
       
    ]

    connectSignalAfter: name to: handler selector: sel [
       <category: 'C call-outs'>
       <cCall: 'gstGtkConnectSignalAfterNoUserData' returning: #int
       args: #(#selfSmalltalk #string #smalltalk #smalltalk )>
       
    ]

    connectSignal: name to: handler selector: sel userData: userData [
       <category: 'C call-outs'>
       <cCall: 'gstGtkConnectSignal' returning: #int
       args: #(#selfSmalltalk #string #smalltalk #smalltalk #smalltalk )>
       
    ]

    connectSignal: name to: handler selector: sel [
       <category: 'C call-outs'>
       <cCall: 'gstGtkConnectSignalNoUserData' returning: #int
       args: #(#selfSmalltalk #string #smalltalk #smalltalk )>
       
    ]

    disconnectSignal: anInteger [
       <category: 'C call-outs'>
       <cCall: 'g_signal_handler_disconnect' returning: #void
       args: #(#self #int )>
    ]

    narrow [
       <category: 'C call-outs'>
       <cCall: 'gstGtkNarrowGObjectOOP' returning: #smalltalk
	args: #(#self #selfSmalltalk )>
	
    ]

    free [
	<category: 'C call-outs'>
	<cCall: 'gstGtkFreeGObjectOOP' returning: #void args: #(#self )>
	
    ]

    propertiesAt: name [
	<category: 'C call-outs'>
	<cCall: 'gstGtkGetProperty' returning: #smalltalk args: #(#self #string )>
	
    ]

    propertiesAt: name put: anObject [
	<category: 'C call-outs'>
	<cCall: 'gstGtkSetProperty' returning: #void
	args: #(#self #string #smalltalk )>
	
    ]

]



GtkAccelGroup extend [
    connect: accelKey accelModes: accelMods accelFlags: accelFlags receiver: receiver selector: selector userData: userData [
	<category: 'C call-outs'>
	<cCall: 'gstGtkAccelGroupConnect' returning: #void
	args: #( #selfSmalltalk #int #int #int #smalltalk #smalltalk #smalltalk)>
    ]

    connect: accelKey accelModes: accelMods accelFlags: accelFlags receiver: receiver selector: selector [
	<category: 'C call-outs'>
	<cCall: 'gstGtkAccelGroupConnectNoUserData' returning: #void
	args: #( #selfSmalltalk #int #int #int #smalltalk #smalltalk )>
    ]
]


"These have a weird name in C."

GtkObject extend [
    signalEmit: signal args: argsArray [
	<category: 'C call-outs'>
	<cCall: 'gtk_signal_emit' returning: #void
	args: #(#self #int #variadic)>
	
    ]

    signalEmitByName: signal args: argsArray [
	<category: 'C call-outs'>
	<cCall: 'gtk_signal_emit_by_name' returning: #void
	args: #(#self #string #variadic)>
	
    ]

    signalNEmissions: signal [
	<category: 'C call-outs'>
	<cCall: 'gtk_signal_n_emissions' returning: #int
	args: #(#self #int)>
	
    ]

    signalNEmissionsByName: signal [
	<category: 'C call-outs'>
	<cCall: 'gtk_signal_n_emissions_by_name' returning: #int
	args: #(#self #string)>
	
    ]

    signalEmitStop: signal [
	<category: 'C call-outs'>
	<cCall: 'gtk_signal_emit_stop' returning: #void
	args: #(#self #int)>
	
    ]

    signalEmitStopByName: signal [
	<category: 'C call-outs'>
	<cCall: 'gtk_signal_emit_stop_by_name' returning: #void
	args: #(#self #string)>
	
    ]

]

GTK.GdkDrawable extend [

    cairoCreate [
        <category: 'C call-outs'>
        <cCall: 'gdk_cairo_create' returning: #cObject args: #( #self )>
    ]
]


GtkWidget extend [

    getAllocation [
	<category: 'C call-outs'>
	<cCall: 'gstGtkWidgetGetAllocation' returning: #{GtkAllocation}
	args: #(#self )>
	
    ]

    getWindow [
	<category: 'C call-outs'>
	<cCall: 'gstGtkGetWindow' returning: #{GdkWindow} args: #(#self )>
	
    ]

    getState [
	<category: 'C call-outs'>
	<cCall: 'gstGtkGetState' returning: #int args: #(#self )>
	
    ]

    getFlags [
	<category: 'C call-outs'>
	<cCall: 'gstGtkGetFlags' returning: #int args: #(#self )>
	
    ]

    setFlags: flags [
	<category: 'C call-outs'>
	<cCall: 'gstGtkSetFlags' returning: #void args: #(#self #int )>
	
    ]

    unsetFlags: flags [
	<category: 'C call-outs'>
	<cCall: 'gstGtkUnsetFlags' returning: #void args: #(#self #int )>
	
    ]

]



GtkContainer extend [

    child: widget propertiesAt: name [
	<category: 'C call-outs'>
	<cCall: 'gstGtkGetChildProperty' returning: #smalltalk
	args: #(#self #cObject #string )>
	
    ]

    child: widget propertiesAt: name put: anObject [
	<category: 'C call-outs'>
	<cCall: 'gstGtkSetChildProperty' returning: #void
	args: #(#self #cObject #string #smalltalk )>
	
    ]

]



GValue class extend [

    typeFromName: aName [
	<category: 'C call-outs'>
	<cCall: 'g_type_from_name' returning: #int args: #(#string )>
	
    ]

]



GtkTreeModel extend [

    getOop: iter column: aColumn [
	<category: 'C call-outs'>
	<cCall: 'gstGtkTreeModelGetOOP' returning: #smalltalk
	args: #(#self #cObject #int )>
	
    ]

]



GtkTreeStore extend [

    setOop: iter column: aColumn value: aValue [
	<category: 'C call-outs'>
	<cCall: 'gstGtkTreeStoreSetOOP' returning: #void
	args: #(#self #cObject #int #smalltalk )>
	
    ]

]



GtkListStore extend [

    setOop: iter column: aColumn value: aValue [
	<category: 'C call-outs'>
	<cCall: 'gstGtkListStoreSetOOP' returning: #void
	args: #(#self #cObject #int #smalltalk )>
	
    ]

]



GtkDialog extend [

    getVBox [
	<category: 'C call-outs'>
	<cCall: 'gstGtkDialogGetVBox' returning: #{GtkWidget} args: #(#self )>
	
    ]

    getActionArea [
	<category: 'C call-outs'>
	<cCall: 'gstGtkDialogGetActionArea' returning: #{GtkWidget}
	args: #(#self )>
	
    ]

]



GtkScrolledWindow extend [

    getHscrollbarVisible [
	<category: 'C call-outs'>
	<cCall: 'gstGtkGetHscrollbarVisible' returning: #boolean args: #(#self )>
	
    ]

    getVscrollbarVisible [
	<category: 'C call-outs'>
	<cCall: 'gstGtkGetVscrollbarVisible' returning: #boolean args: #(#self )>
	
    ]

]



GtkAdjustment extend [

    getLower [
	<category: 'C call-outs'>
	<cCall: 'gstGtkAdjustmentGetLower' returning: #int args: #(#self )>
	
    ]

    getUpper [
	<category: 'C call-outs'>
	<cCall: 'gstGtkAdjustmentGetUpper' returning: #int args: #(#self )>
	
    ]

    getPageSize [
	<category: 'C call-outs'>
	<cCall: 'gstGtkAdjustmentGetPageSize' returning: #int args: #(#self )>
	
    ]

]



"FIXME: funcs.awk is broken for these."

GdkPixbufLoader extend [

    write: buf count: count error: error [

	<category: 'C call-outs'>
	<cCall: 'gdk_pixbuf_loader_write' returning: #boolean
	args: #(#self #byteArray #int #cObject )>
	
    ]

]


GtkFileChooserDialog extend [
    getFilename [
	<category: 'C call-outs'>
        <cCall: 'gtk_file_chooser_get_filename' returning: #string args: #( #self )>
    ]

    getCurrentFolder [
	<category: 'C call-outs'>
        <cCall: 'gtk_file_chooser_get_current_folder' returning: #string args: #( #self )>
    ]
]


GtkContainer extend [

    getFocusChild [
	<category: 'C call-outs'>
        <cCall: 'gtk_container_get_focus_child' returning: #{GtkWidget}
        args: #( #self )>
    ]
]

GTK.GtkNotebook extend [

    pageNum: aGtkWidget [
        <category: 'C call-outs'>
        <cCall: 'gtk_notebook_page_num' returning: #int args: #( #self #cObject )>
    ]
]


Eval [
    GtkTreeStore superclass: GtkTreeModel.
    GtkListStore superclass: GtkTreeModel
]

PK
     BsaW  W  
  GtkImpl.stUT	 aQEiux       GtkTextBuffer extend [

    insertAtEnd: aString [
        <category: 'accessing'>

        self insert: self getEndIter text: aString
    ]
]


GtkAlignment class extend [
    new [
	<category: 'instance creation'>
        ^self new: 0 yalign: 0 xscale: 1 yscale: 1
    ]
]


GObject class extend [
    new [
	<category: 'instance creation'>
        ^self new: self getType varargs: #(nil)
    ]
]


GList extend [
    do: aOneArgBlock [
	<category: 'iterating'>
	| iter |
	iter := self.
	[ iter isNull not ] whileTrue: [
	    aOneArgBlock value: iter data value.
	    iter := iter next value ]
    ]
]


GdkDrawable extend [

    withContextDo: aBlock [
	"Execute aBlock passing a valid Cairo context for the
	 window.  The context is invalidated after aBlock returns."

	<category: 'accessing'>
	| context |
	[ aBlock value: (context := Cairo.CairoContext context: self cairoCreate) ]
	    ensure: [ context isNil ifFalse: [ context release ] ]
    ]

]

GtkWidget extend [

    getSizeRequest [
	"Answer the size the widget has requisitioned."

	<category: 'accessing'>
	| requisition |
	requisition := GTK.GtkRequisition new.
	self sizeRequest: requisition.
	^requisition asPoint
    ]

]



GtkMessageDialog class extend [

    new: parent flags: flags type: type buttons: buttons message: message [
	<category: 'instance creation'>
	^self 
	    new: parent
	    flags: flags
	    type: type
	    buttons: buttons
	    messageFormat: '%s'
	    varargs: {message}
    ]

    new: parent flags: flags type: type buttons: buttons message: message tip: tip [
	<category: 'instance creation'>
	^self 
	    newWithMarkup: parent
	    flags: flags
	    type: type
	    buttons: buttons
	    messageFormat: '<big><b>%s</b></big>

%s'
	    varargs: {message. tip}
    ]

    newWithMarkup: parent flags: flags type: type buttons: buttons message: message [
	<category: 'instance creation'>
	^self 
	    newWithMarkup: parent
	    flags: flags
	    type: type
	    buttons: buttons
	    messageFormat: (message copyReplaceAll: '%' with: '%%')
	    varargs: #()
    ]
]



GtkRequisition class extend [

    fromPoint: point [
	<category: 'instance creation'>
	| ba |
	ba := (CShortType arrayType: 2) new.
	ba at: 0 put: point x.
	ba at: 1 put: point y.
	^(ba castTo: self type)
	    addToBeFinalized;
	    yourself
    ]

]



GtkRequisition extend [

    x [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^ba at: 0
    ]

    y [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^ba at: 1
    ]

    asPoint [
	<category: 'conversion'>
	^
	{self width value.
	self height value}
    ]

]



GdkRectangle class extend [

    fromRectangle: rect [
	<category: 'instance creation'>
	| ba |
	ba := (CShortType arrayType: 4) new.
	ba at: 0 put: rect left.
	ba at: 1 put: rect top.
	ba at: 2 put: rect width.
	ba at: 3 put: rect height.
	^(ba castTo: self type)
	    addToBeFinalized;
	    yourself
    ]

]



GdkRectangle extend [

    left [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^ba at: 0
    ]

    top [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^ba at: 1
    ]

    right [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^(ba at: 0) + (ba at: 2)
    ]

    bottom [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^(ba at: 1) + (ba at: 3)
    ]

    width [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^ba at: 2
    ]

    height [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^ba at: 3
    ]

    origin [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^(ba at: 0) @ (ba at: 1)
    ]

    extent [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^(ba at: 2) @ (ba at: 3)
    ]

    corner [
	<category: 'accessing'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^((ba at: 0) + (ba at: 2)) @ ((ba at: 1) + (ba at: 3))
    ]

    asRectangle [
	<category: 'conversion'>
	| ba |
	ba := self castTo: (CShortType arrayType: 4).
	^(ba at: 0) @ (ba at: 1) extent: (ba at: 2) @ (ba at: 3)
    ]

]



GtkTreeIter class extend [

    Prototype := nil.

    gcNew [
	^self type gcNew
    ]

    new [
	<category: 'instance creation'>
        Prototype isNil ifTrue: [ Prototype := self type gcNew ].
	^Prototype copy
	    addToBeFinalized;
	    yourself
    ]

]



GtkTextIter class extend [

    Prototype := nil.

    gcNew [
	^self type gcNew
    ]

    new [
	<category: 'instance creation'>
        Prototype isNil ifTrue: [ Prototype := self type gcNew ].
	^Prototype copy
	    addToBeFinalized;
	    yourself
    ]

]



GtkTreeModel extend [

    getIter: path [
	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTreeIter new.
	^(self getIter: iter path: path) ifTrue: [iter] ifFalse: [nil]
    ]

    getIterFirst [
	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTreeIter new.
	self getIterFirst: iter.
	^iter
    ]

    iterChildren: parent [
	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTreeIter new.
	self iterChildren: iter parent: parent.
	^iter
    ]

    iterNthChild: parent n: n [
	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTreeIter new.
	self 
	    iterNthChild: iter
	    parent: parent
	    n: n.
	^iter
    ]

    iterParent: child [
	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTreeIter new.
	self iterParent: iter child: child.
	^iter
    ]

]



GtkTreeSelection extend [

    getSelected [
	<category: 'accessing'>
	| has iter |
	iter := GTK.GtkTreeIter new.
	has := self getSelected: nil iter: iter.
	^has ifTrue: [iter] ifFalse: [nil]
    ]

]



GtkListStore extend [

    insert: anInteger [
	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTreeIter new.
	self insert: iter position: anInteger.
	^iter
    ]

    insertBefore: sibling [
	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTreeIter new.
	self insertBefore: iter sibling: sibling.
	^iter
    ]

    insertAfter: sibling [
	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTreeIter new.
	self insertAfter: iter sibling: sibling.
	^iter
    ]

    prepend [
	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTreeIter new.
	self prepend: iter.
	^iter
    ]

    append [
	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTreeIter new.
	self append: iter.
	^iter
    ]

]



GtkTextBuffer extend [

    setText: aString [
	"Set my contents"

	<category: 'accessing'>
	self setText: aString len: aString size
    ]

    insertAtCursor: aString [
	"Insert aString at the curser."

	<category: 'accessing'>
	self insertAtCursor: aString len: aString size
    ]

    getBounds [
	"Answer my entire contents."

	<category: 'accessing'>
	| start end |
	start := GTK.GtkTextIter new.
	end := GTK.GtkTextIter new.
	self getBounds: start end: end.
	^
	{start.
	end}
    ]

    getIterAtMark: mark [
	"Answer an iterator for mark"

	<category: 'accessing'>
	| iter |
	iter := GTK.GtkTextIter new.
	self getIterAtMark: iter mark: mark.
	^iter
    ]

    getSelectionBounds [
	"Answer my selection bounds"

	<category: 'accessing'>
	| start end |
	start := GTK.GtkTextIter new.
	end := GTK.GtkTextIter new.
	self getSelectionBounds: start end: end.
	^
	{start.
	end}
    ]

    getIterAtLine: line [
	"Answer an iterator at the beginning of line."

	<category: 'accessing'>
	| result |
	result := GTK.GtkTextIter new.
	self getIterAtLine: result lineNumber: line.
	^result
    ]

    getIterAtLineOffset: lineNumber charOffset: charOffset [
	"Answer an iterator at offset in me."

	<category: 'accessing'>
	| result |
	result := GTK.GtkTextIter new.
	self 
	    getIterAtLineOffset: result
	    lineNumber: lineNumber
	    charOffset: charOffset.
	^result
    ]

    getStartIter [
	"Answer a start iterator."

	<category: 'accessing'>
	| result |
	result := GTK.GtkTextIter new.
	self getStartIter: result.
	^result
    ]

    getEndIter [
	"Answer an end iterator"

	<category: 'accessing'>
	| result |
	result := GTK.GtkTextIter new.
	self getEndIter: result.
	^result
    ]

    insert: iter text: aString [
	"Insert aString at the insertion point."

	<category: 'accessing'>
	self 
	    insert: iter
	    text: aString
	    len: aString size
    ]

]



Gtk class extend [
    | loop |

    mainQuit [
        loop quit
    ]

    main [
	"Main loop implementation.  Same as gtk_main, but it splits
         g_main_context_run in two threads so that Smalltalk processes
         run.  Like gtk_main, it is ended with Gtk>>#mainQuit."

	<category: 'event loop'>
	| sem newLoop context |
	sem := Semaphore new.
	newLoop := GTK.Gtk main: sem.
        newLoop isNil ifTrue: [ ^self ].
        loop := newLoop.
        context := loop getContext.

	[
            [sem wait.
	    context iterate.
            loop isRunning] whileTrue]
                 ensure: [loop unref]
    ]

]



GtkAccelGroup class extend [

    acceleratorParse: accelerator [
	<category: 'C call-outs'>

	| cAccKey cAccMod |
	cAccKey := CInt gcValue: 0.
	cAccMod := CInt gcValue: 0.
	GTK.Gtk acceleratorParse: accelerator acceleratorKey: cAccKey acceleratorMods: cAccMod.
	^ {cAccKey value. cAccMod value}
    ]

    acceleratorGroup: aGtkAccelGroup accelerator: aString path: aPathString [
	<category: 'C call-outs'>

	| result |
	result := self acceleratorParse: aString.
	GTK.GtkAccelMap addEntry: aPathString accelKey: result first accelMods: result second
    ]
]


GtkAccelGroup extend [

    append: anArray [
        <category: 'accessing'>

        anArray do: [ :each |
            self class
                acceleratorGroup: self
                accelerator: each first
                path: each second ]
    ]
]



GtkButton class extend [

    label: aString onPressedSend: aSymbol to: anObject [
    <category: 'instance creation'>

    ^ (GTK.GtkButton newWithLabel: aString)
        connectSignal: 'pressed' to: anObject selector: aSymbol userData: nil;
        yourself
    ]
]


GTK.GtkDialog extend [
    run [
        <category: 'services'>

        | signals sema answer modal destroyed |
        sema := Semaphore new.
        modal := self getModal.
        self setModal: true.
        signals := {
            self
                connectSignal: 'response'
                to: [ :dialog :integer | answer := integer. sema signal ]
                selector: #value:value:.

            self
                connectSignal: 'unmap'
                to: sema
                selector: #signal.

            self
                connectSignal: 'delete_event'
                to: [ answer := Gtk gtkResponseDeleteEvent. sema signal. true ]
                selector: #value.

            self
                connectSignal: 'destroy'
                to: [ destroyed := true ]
                selector: #value }.

        self show.
        sema wait.
        destroyed ifFalse: [
            self setModal: modal.
            signals do: [ :each | self disconnectSignal: each ] ].
        ^answer
    ]
]


GTK.GtkFileChooserDialog class extend [

    for: aGtkFileChooserAction title: aString parent: aGtkWidget button: aGtkStock  [
        <category: 'instance creation'>

        ^ self
            new: aString
            parent: aGtkWidget
            action: aGtkFileChooserAction
            varargs: {GTK.Gtk gtkStockCancel.
                    GTK.Gtk gtkResponseCancel.
                    aGtkStock.
                    GTK.Gtk gtkResponseAccept.
                    nil}
    ]

    save: aString parent: aGtkWidget [
        <category: 'instance creation'>

        ^ self
            for: GTK.Gtk gtkFileChooserActionSave
            title: aString
            parent: aGtkWidget
            button: GTK.Gtk gtkStockSave
    ]

    load: aString parent: aGtkWidget [
        <category: 'instance creation'>

        ^ self
            for: GTK.Gtk gtkFileChooserActionOpen
            title: aString
            parent: aGtkWidget
            button: GTK.Gtk gtkStockOpen
    ]

    selectFolder: aString parent: aGtkWidget [
        <category: 'instance creation'>

        ^ self
            for: GTK.Gtk gtkFileChooserActionSelectFolder
            title: aString
            parent: aGtkWidget
            button: GTK.Gtk gtkStockOpen    
    ]
]


GTK.GtkListStore extend [

    appendItem: anArray [
	<category: 'accessing'>
   
	| iter |
	iter := self append.
	self at: iter put: anArray.
	^ iter
    ]

    prependItem: anArray [
        <category: 'accessing'>

        | iter |
        iter := self prepend.
        self at: iter put: anArray.
        ^ iter
    ]

    itersDo: aBlock [
	<category: 'accessing'>

	| iter |
	((iter := self getIterFirst) isNil or: [ (self iterIsValid: iter) not ] ) ifTrue: [ ^ nil ].
	aBlock value: iter.
	[ self iterNext: iter ] whileTrue: [ aBlock value: iter ]
    ]
   
    do: aBlock [
	<category: 'accessing'>

	self itersDo: [ :iter |
	    aBlock value: (self at: iter) value: iter ]
    ]

    lastIter [
	<category: 'accessing'>

	| lastIter iter path |
	iter := lastIter := GTK.GtkTreeIter new.
	path := GTK.GtkTreePath newFirst.
	[ self getIter: iter path: path ] whileTrue: [
	    lastIter := iter.
	    iter := GTK.GtkTreeIter new.
            path next ].
	^ lastIter
    ]
]


GTK.GtkMenuItem class extend [

    menuItem: aString connectTo: anObject selector: aSymbol userData: userData [
	<category: 'instance creation'>

	^ (self newWithLabel: aString)
	    connectSignal: 'activate' to: anObject selector: aSymbol userData: userData;
	    yourself
    ]

    menuItem: aString connectTo: anObject selector: aSymbol [
        <category: 'instance creation'>

        ^ self menuItem: aString connectTo: anObject selector: aSymbol userData: nil 
    ]

    menuItem: aString accelPath: anAccelPathString [
	<category: 'instance creation'>

	^ (self newWithLabel: aString)
	    setAccelPath: anAccelPathString;
	    yourself
    ]

    menuItem: aString accelPath: anAccelPathString connectTo: anObject selector: aSymbol [
        <category: 'instance creation'>

        ^ (self menuItem: aString accelPath: anAccelPathString)
            connectSignal: 'activate' to: anObject selector: aSymbol userData: nil;
            yourself
    ]
]


GTK.GtkMenu extend [

    appendSeparator [
    <category: 'accessing'>

    self append: GTK.GtkMenuItem new
    ]

    appendMenuItems: anArray [
    <category: 'accessing'>

    anArray do: [ :each |
        self append: 
	(each isEmpty 
	    ifTrue: [ GTK.GtkMenuItem new ]
	    ifFalse: [ (GTK.GtkMenuItem newWithLabel: (each at: 1))
		connectSignal: 'activate' to: (each at: 2) selector: (each at: 3) userData: nil;
		yourself ]) ]
    ]
]


GTK.GtkScrolledWindow class extend [

    withChild: aGtkWidget [
    <category: 'instance creation'>

    ^ (GTK.GtkScrolledWindow new: nil vadjustment: nil)
        add: aGtkWidget;
        setPolicy: GTK.Gtk gtkPolicyAutomatic vscrollbarPolicy: GTK.Gtk gtkPolicyAutomatic;
        yourself
    ]
]


GTK.GtkTextBuffer extend [

    text [
    <category: 'accessing'>

    ^ self getText: self getStartIter end: self getEndIter includeHiddenChars: false
    ]

    applyTagByName: aSymbol startOffset: aStartInteger endOffset: anEndInteger [
    <category: 'accessing'>

    | end start |
    start := GTK.GtkTextIter new.
        end := GTK.GtkTextIter new.
        self getIterAtOffset: start charOffset: aStartInteger.
        self getIterAtOffset: end charOffset: anEndInteger.
        self applyTagByName: aSymbol start: start end: end
    ]

    getIterAtOffset: offset [
    <category: 'accessing'>

    | result |
    result := GTK.GtkTextIter new.
    self getIterAtOffset: result charOffset: offset.
    ^ result
    ]

    iterOfSelectedText [
        <category: 'text accessing'>

        | iter |
        self getHasSelection
                ifTrue: [ iter := self getSelectionBounds ifNil: [ ^ self ].
                        (iter at: 1) getOffset > ((iter at: 2) getOffset)
                            ifTrue: [ iter swap: 1 with: 2 ] ]
                ifFalse: [ iter := {self getStartIter. self getEndIter} ].
        ^ iter
    ]

    selectedText [
        <category: 'text accessing'>

        | iter |
        iter := self iterOfSelectedText.
        ^ self getText: (iter at: 1) end: (iter at: 2) includeHiddenChars: false
    ]
]


GTK.GtkTreeModel extend [

    at: aGtkTreeIter [
        <category: 'accessing'>

        | values |
        aGtkTreeIter ifNil: [ ^ nil ].
        values := OrderedCollection new.
        0 to: self getNColumns - 1 do: [ :column |
            values add: (self at: aGtkTreeIter column: column) ].
        ^ values
    ]

    at: aGtkTreeIter column: anInteger [
        <category: 'accessing'>

        ^ self getOop: aGtkTreeIter column: anInteger
    ]

    at: aGtkTreeIter column: anInteger put: anObject [
        <category: 'accessing'>

        self setOop: aGtkTreeIter column: anInteger value: anObject
    ]

    at: aGtkTreeIter put: anArray [
        <category: 'accessing'>

        1 to: anArray size do: [ :i |
            self at: aGtkTreeIter column: i - 1 put: (anArray at: i) ]
    ]

    at: aGtkTreeIter do: aBlock [
	<category: 'accessing'>

	(self at: aGtkTreeIter) do: aBlock
    ]

    itersDo: aBlock iter: aGtkTreeIter [
	<category: 'accessing'>

	| childIter |
	childIter := GTK.GtkTreeIter new.
	aBlock value: aGtkTreeIter.
	(self iterChildren: childIter parent: aGtkTreeIter) ifTrue: [ self itersDo: aBlock iter: childIter ].
	[ self iterNext: aGtkTreeIter ] whileTrue: [
	    aBlock value: aGtkTreeIter.
            (self iterChildren: childIter parent: aGtkTreeIter) ifTrue: [ self itersDo: aBlock iter: childIter ] ]
    ]

    itersDo: aBlock [
	<category: 'accessing'>

	| iter child |
	((iter := self getIterFirst) isNil or: [ (self iterIsValid: iter) not ] ) ifTrue: [ ^ nil ].
	self itersDo: aBlock iter: iter
    ]

    do: aBlock [
        <category: 'accessing'>

        self itersDo: [ :iter |
            aBlock value: (self at: iter) value: iter ]
    ]
]


GTK.GtkTreeStore extend [

    itersDo: aBlock iter: aGtkTreeIter [
	<category: 'accessing'>

	| childIter |
	childIter := GTK.GtkTreeIter new.
	aBlock value: aGtkTreeIter.
	(self iterChildren: childIter parent: aGtkTreeIter) ifTrue: [ self itersDo: aBlock iter: childIter ].
	[ self iterNext: aGtkTreeIter ] whileTrue: [
	    aBlock value: aGtkTreeIter.
            (self iterChildren: childIter parent: aGtkTreeIter) ifTrue: [ self itersDo: aBlock iter: childIter ] ]
    ]

    itersDo: aBlock [
	<category: 'accessing'>

	| iter child |
	((iter := self getIterFirst) isNil or: [ (self iterIsValid: iter) not ] ) ifTrue: [ ^ nil ].
	self itersDo: aBlock iter: iter
    ]

    do: aBlock [
        <category: 'accessing'>

        self itersDo: [ :iter |
            aBlock value: (self at: iter) value: iter ]
    ]

    appendItem: anArray [
	<category: 'accessing'>

	^ self append: nil item: anArray
    ]

    append: aGtkTreeIter item: anArray [
	<category: 'accessing'>

        | iter |
        iter := GTK.GtkTreeIter new.
        self 
	    append: iter parent: aGtkTreeIter;
	    at: iter put: anArray.
	^ iter
    ]
]


GTK.GtkTreeView class extend [

    newWith: aGtkModel columns: anArray [
        <category: 'user interface'>

        | view |
        view := self new.
	view setModel: aGtkModel.
	anArray keysAndValuesDo: [ :i :each || col render |
	    col := (GtkTreeViewColumn new)
		    packStart: (render := each key = 'text' ifFalse: [ GTK.GtkCellRendererPixbuf new ] ifTrue: [ GTK.GtkCellRendererText new ]) expand: true;
		    addAttribute: render attribute: each key column: i - 1;
		    yourself.
	    each value isEmpty ifFalse: [ col setTitle: each value ].
	    view insertColumn: col position: -1 ].
	^ view
    ]

    newWith: aGtkModel pack: anArray title: aString [
        <category: 'user interface'>

        | view col |
        view := self new.
	view setModel: aGtkModel.
	col := GtkTreeViewColumn new.
	anArray keysAndValuesDo: [ :i :each || render |
	    col
		packStart: (render := each = 'text' ifFalse: [ GTK.GtkCellRendererPixbuf new ] ifTrue: [ GTK.GtkCellRendererText new ]) expand: each = 'text';
		addAttribute: render attribute: each column: i - 1 ].
	col setTitle: aString.
	view insertColumn: col position: -1.
	^ view
    ]

    newWithTextColumn: aGtkModel title: aString [
        <category: 'user interface'>

        | view col render |
        view := self new
	    setModel: aGtkModel;
	    yourself.
        col := (GtkTreeViewColumn new)
	    packStart: (render := GTK.GtkCellRendererText new) expand: true;
	    addAttribute: render attribute: 'text' column: 0;
	    setTitle: aString;
	    yourself.
        view insertColumn: col position: -1.
    ^ view
    ]

    newWithSortedTextColumn: aGtkModel title: aString [
    <category: 'instance creation'>

        | view col render |
        view := self new
                    setModel: aGtkModel;
                    yourself.
        col := (GtkTreeViewColumn new)
                packStart: (render := GtkCellRendererText new) expand: true;
                addAttribute: render attribute: 'text' column: 0;
                setTitle: aString;
                setSortIndicator: true;
                setSortColumnId: 0;
                setSortOrder: Gtk gtkSortAscending;
                yourself.
        view
            insertColumn: col position: -1.
    ^ view
    ]
]

GTK.GtkTreeView extend [

    hasSelectedItem [
	<category: 'accessing'>

	^ self getSelection getSelected isNil not
    ]

    numberOfItems [
	<category: 'accessing'>

	^ self getModel iterNChildren: nil
    ]

    selectedIter [
	<category: 'accessing'>

	^ self getSelection getSelected
    ]

    selectedIndex [
	<category: 'accessing'>

	self hasSelectedItem ifFalse: [ self error: 'Nothing is selected' ].
	^ (self getModel getPath: self selectedIter) getIndices value + 1
    ]
]


GTK.GtkToolButton class extend [
    newFromStock: icon label: aString [ 
        ^(self newFromStock: icon)
	    setLabel: aString;
	    yourself
    ]
]


"Finish initialization.  This will be done upon #returnFromSnapshot on
 subsequent image loads."

Eval [
    GLib registerAllTypes
]

PK
     
wBb򜣝      example_arrow.stUT	 NQEiux       "======================================================================
|
|   Smalltalk Gtk+ bindings examples
|
 ======================================================================"

"======================================================================
|
| Copyright 2001, 2003, 2008, 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"


PackageLoader fileInPackage: 'GTK'.


Namespace current: GTK [

Object subclass: ArrowExample [
    
    <category: nil>
    <comment: nil>

    destroy: object data: data [
	<category: 'event handling'>
	Gtk mainQuit
    ]

    open [
	<category: 'layout'>
	| window button box |
	window := GtkWindow new: Gtk gtkWindowToplevel.
	window setTitle: 'Arrow Buttons'.
	window 
	    connectSignal: 'destroy'
	    to: self
	    selector: #destroy:data:
	    userData: nil.
	window setBorderWidth: 10.
	box := GtkHBox new: false spacing: 0.
	box setBorderWidth: 2.
	window add: box.
	button := GtkButton createArrowButton: Gtk gtkArrowUp
		    shadowType: Gtk gtkShadowIn.
	box 
	    packStart: button
	    expand: false
	    fill: false
	    padding: 3.
	button := GtkButton createArrowButton: Gtk gtkArrowDown
		    shadowType: Gtk gtkShadowOut.
	box 
	    packStart: button
	    expand: false
	    fill: false
	    padding: 3.
	button := GtkButton createArrowButton: Gtk gtkArrowLeft
		    shadowType: Gtk gtkShadowEtchedIn.
	box 
	    packStart: button
	    expand: false
	    fill: false
	    padding: 3.
	button := GtkButton createArrowButton: Gtk gtkArrowRight
		    shadowType: Gtk gtkShadowEtchedOut.
	box 
	    packStart: button
	    expand: false
	    fill: false
	    padding: 3.
	box show.
	window show
    ]
]

]



GTK.GtkButton class extend [

    createArrowButton: arrowType shadowType: shadowType [
	<category: 'creating arrow buttons'>
	| button arrow |
	button := self new.
	arrow := GtkArrow new: arrowType shadowType: shadowType.
	button add: arrow.
	button show.
	arrow show.
	^button
    ]

]



Namespace current: GTK [
    ArrowExample new open.
    Gtk main
]

PK
     
wB<	  	    example_aspectframe.stUT	 NQEiux       "======================================================================
|
|   Smalltalk Gtk+ bindings examples
|
 ======================================================================"

"======================================================================
|
| Copyright 2001, 2003, 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"


PackageLoader fileInPackage: 'GTK'.


Namespace current: GTK [

Object subclass: AspectFrameExample [
    
    <category: nil>
    <comment: nil>

    destroy: object data: data [
	<category: 'event handling'>
	Gtk mainQuit
    ]

    open [
	<category: 'layout'>
	| window aspectFrame drawingArea |
	window := GtkWindow new: Gtk gtkWindowToplevel.
	window 
	    connectSignal: 'destroy'
	    to: self
	    selector: #destroy:data:
	    userData: nil.
	window setTitle: 'Aspect Frame'.
	window setBorderWidth: 10.
	aspectFrame := GtkAspectFrame 
		    new: '2x1'
		    xalign: 0.5
		    yalign: 0.5
		    ratio: 2
		    obeyChild: false.
	window add: aspectFrame.

	"We ask for a 200x200 drawing area, but we are forcing a 2x1 ratio so
	 the AspectFrame will give us a 200x100 area."
	drawingArea := GtkDrawingArea new.
	drawingArea setSizeRequest: 200 height: 200.
	aspectFrame add: drawingArea.
	drawingArea show.
	aspectFrame show.
	window show
    ]
]

]



Namespace current: GTK [
    AspectFrameExample new open.
    Gtk main
]

PK
     
wB<  <    example_buttonbox.stUT	 NQEiux       "======================================================================
|
|   Smalltalk Gtk+ bindings examples
|
 ======================================================================"

"======================================================================
|
| Copyright 2001, 2003, 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"


PackageLoader fileInPackage: 'GTK'.


Namespace current: GTK [

Object subclass: ButtonBoxExample [
    
    <category: nil>
    <comment: nil>

    destroy: object data: data [
	<category: 'event handling'>
	Gtk mainQuit
    ]

    open [
	<category: 'layout'>
	| window mainVBox hbox vbox frameHorz frameVert |
	window := GtkWindow new: Gtk gtkWindowToplevel.
	window setTitle: 'Button Boxes'.
	window 
	    connectSignal: 'destroy'
	    to: self
	    selector: #destroy:data:
	    userData: nil.
	window setBorderWidth: 10.
	mainVBox := GtkVBox new: false spacing: 0.
	window add: mainVBox.
	frameHorz := GtkFrame new: 'Horizontal Button Boxes'.
	mainVBox 
	    packStart: frameHorz
	    expand: true
	    fill: true
	    padding: 10.
	vbox := GtkVBox new: false spacing: 0.
	vbox setBorderWidth: 10.
	frameHorz add: vbox.
	vbox 
	    packStart: (GtkHButtonBox 
		    createButtonBox: 'Spread (spacing 40)'
		    spacing: 40
		    layout: Gtk gtkButtonboxSpread)
	    expand: true
	    fill: true
	    padding: 0.
	vbox 
	    packStart: (GtkHButtonBox 
		    createButtonBox: 'Edge (spacing 30)'
		    spacing: 30
		    layout: Gtk gtkButtonboxEdge)
	    expand: true
	    fill: true
	    padding: 0.
	vbox 
	    packStart: (GtkHButtonBox 
		    createButtonBox: 'Start (spacing 20)'
		    spacing: 20
		    layout: Gtk gtkButtonboxStart)
	    expand: true
	    fill: true
	    padding: 0.
	vbox 
	    packStart: (GtkHButtonBox 
		    createButtonBox: 'End (spacing 10)'
		    spacing: 10
		    layout: Gtk gtkButtonboxEnd)
	    expand: true
	    fill: true
	    padding: 0.
	frameVert := GtkFrame new: 'Vertical Button Boxes'.
	mainVBox 
	    packStart: frameVert
	    expand: true
	    fill: true
	    padding: 10.
	hbox := GtkHBox new: false spacing: 0.
	hbox setBorderWidth: 10.
	frameVert add: hbox.
	hbox 
	    packStart: (GtkVButtonBox 
		    createButtonBox: 'Spread (spacing 5)'
		    spacing: 5
		    layout: Gtk gtkButtonboxSpread)
	    expand: true
	    fill: true
	    padding: 0.
	hbox 
	    packStart: (GtkVButtonBox 
		    createButtonBox: 'Edge (spacing 30)'
		    spacing: 30
		    layout: Gtk gtkButtonboxEdge)
	    expand: true
	    fill: true
	    padding: 0.
	hbox 
	    packStart: (GtkVButtonBox 
		    createButtonBox: 'Start (spacing 20)'
		    spacing: 20
		    layout: Gtk gtkButtonboxStart)
	    expand: true
	    fill: true
	    padding: 0.
	hbox 
	    packStart: (GtkVButtonBox 
		    createButtonBox: 'End (spacing 20)'
		    spacing: 20
		    layout: Gtk gtkButtonboxEnd)
	    expand: true
	    fill: true
	    padding: 0.
	window showAll
    ]
]

]



GTK.GtkButtonBox class extend [

    createButtonBox: title spacing: spacing layout: layout [
	<category: 'creating button boxes'>
	| box frame button |
	frame := GtkFrame new: title.

	"Note the use of polymorphism here: we are extending the Gtk binding
	 itself!  The original C example had an extra parameter to specify
	 whether to create an horizontal or vertical button box."
	box := self new.
	box setBorderWidth: 5.
	frame add: box.
	box setLayout: layout.
	box setSpacing: spacing.
	button := GtkButton newFromStock: Gtk gtkStockOk.
	box add: button.
	button := GtkButton newFromStock: Gtk gtkStockCancel.
	box add: button.
	button := GtkButton newFromStock: Gtk gtkStockHelp.
	box add: button.
	^frame
    ]

]



Namespace current: GTK [
    ButtonBoxExample new open.
    Gtk main
]

PK
     
wBb%T  T    example_entry.stUT	 NQEiux       "======================================================================
|
|   Smalltalk Gtk+ bindings examples
|
 ======================================================================"

"======================================================================
|
| Copyright 2001, 2003, 2008, 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"


PackageLoader fileInPackage: 'GTK'.


Namespace current: GTK [

Object subclass: EntryExample [
    | entry window |
    
    <category: nil>
    <comment: nil>

    activate: object data: data [
	<category: 'event handling'>
	entry getText displayNl
    ]

    clicked: object data: data [
	<category: 'event handling'>
	window destroy
    ]

    toggled: object data: selector [
	<category: 'event handling'>
	entry perform: selector with: object getActive
    ]

    destroy: object data: data [
	<category: 'event handling'>
	Gtk mainQuit
    ]

    delete: object event: event data: data [
	<category: 'event handling'>
	window destroy
    ]

    open [
	<category: 'layout'>
	| vbox hbox button check pos |
	window := GtkWindow new: Gtk gtkWindowToplevel.
	window setSizeRequest: 200 height: 100.
	window setTitle: 'GTK Entry'.
	window 
	    connectSignal: 'destroy'
	    to: self
	    selector: #destroy:data:
	    userData: nil.
	window 
	    connectSignal: 'delete_event'
	    to: self
	    selector: #delete:event:data:
	    userData: nil.
	vbox := GtkVBox new: false spacing: 0.
	window add: vbox.
	vbox show.
	entry := GtkEntry new.
	entry setMaxLength: 50.
	entry 
	    connectSignal: 'activate'
	    to: self
	    selector: #activate:data:
	    userData: nil.
	entry setText: 'hello'.

	"This function needs an int* as the last parameter."
	entry 
	    insertText: ' world'
	    newTextLength: -1
	    position: (CInt gcValue: entry getText size).
	entry selectRegion: 0 endPos: entry getText size.
	vbox 
	    packStart: entry
	    expand: true
	    fill: true
	    padding: 0.
	entry show.
	hbox := GtkHBox new: false spacing: 0.
	vbox add: hbox.
	hbox show.
	check := GtkCheckButton newWithLabel: 'Editable'.
	hbox 
	    packStart: check
	    expand: true
	    fill: true
	    padding: 0.
	check 
	    connectSignal: 'toggled'
	    to: self
	    selector: #toggled:data:
	    userData: #setEditable:.
	check setActive: true.
	check show.
	check := GtkCheckButton newWithLabel: 'Visible'.
	hbox 
	    packStart: check
	    expand: true
	    fill: true
	    padding: 0.
	check 
	    connectSignal: 'toggled'
	    to: self
	    selector: #toggled:data:
	    userData: #setVisibility:.
	check setActive: true.
	check show.
	button := GtkButton newFromStock: 'gtk-close'.
	button 
	    connectSignal: 'clicked'
	    to: self
	    selector: #clicked:data:
	    userData: nil.
	vbox 
	    packStart: button
	    expand: true
	    fill: true
	    padding: 0.
	button setFlags: Gtk gtkCanDefault.
	button grabDefault.
	button show.
	window show
    ]
]

]



Namespace current: GTK [
    EntryExample new open.
    Gtk main
]

PK
     
wBl+	  	    example_eventbox.stUT	 NQEiux       "======================================================================
|
|   Smalltalk Gtk+ bindings examples
|
 ======================================================================"

"======================================================================
|
| Copyright 2001, 2003, 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"


PackageLoader fileInPackage: 'GTK'.


Namespace current: GTK [

Object subclass: EventBoxExample [
    
    <category: nil>
    <comment: nil>

    buttonPressEvent: object event: event data: data [
	<category: 'event handling'>
	data destroy
    ]

    destroy: object data: data [
	<category: 'event handling'>
	Gtk mainQuit
    ]

    open [
	<category: 'layout'>
	| window eventBox label |
	window := GtkWindow new: Gtk gtkWindowToplevel.
	window 
	    connectSignal: 'destroy'
	    to: self
	    selector: #destroy:data:
	    userData: nil.
	window setTitle: 'Event Box'.
	window setBorderWidth: 10.
	eventBox := GtkEventBox new.
	window add: eventBox.
	eventBox show.
	label := GtkLabel new: 'Click here to quit, quit, quit, quit, quit'.
	eventBox add: label.
	label show.
	label setSizeRequest: 110 height: 20.
	eventBox setEvents: Gdk gdkButtonPressMask.
	eventBox 
	    connectSignal: 'button_press_event'
	    to: self
	    selector: #buttonPressEvent:event:data:
	    userData: window.
	eventBox realize.
	eventBox getWindow setCursor: (GdkCursor new: Gdk gdkHand1).
	window show
    ]
]

]



Namespace current: GTK [
    EventBoxExample new open.
    Gtk main
]

PK
     
wB8      example_hello.stUT	 NQEiux       "======================================================================
|
|   Smalltalk Gtk+ bindings examples
|
 ======================================================================"

"======================================================================
|
| Copyright 2001, 2003, 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"


PackageLoader fileInPackage: 'GTK'.


Namespace current: GTK [

Object subclass: HelloWorldExample [
    
    <category: nil>
    <comment: nil>

    clicked: widget data: data [
	<category: 'event handling'>
	data displayNl
    ]

    destroy: object data: data [
	<category: 'event handling'>
	Gtk mainQuit
    ]

    open [
	<category: 'layout'>
	| w b l |
	w := GtkWindow new: Gtk gtkWindowToplevel.
	b := GtkButton new.
	l := GtkLabel 
		    new: '
                Push me and watch stdout!                ' , '
'.
	w add: b.
	b add: l.
	b show.
	l show.
	w setTitle: 'GTK+ bindings demo'.
	b 
	    connectSignal: 'clicked'
	    to: self
	    selector: #clicked:data:
	    userData: 'Hello, world!'.
	w 
	    connectSignal: 'destroy'
	    to: self
	    selector: #destroy:data:
	    userData: nil.
	w show
    ]
]

]



Namespace current: GTK [
    HelloWorldExample new open.
    Gtk main
]

PK
     
wB|@;      example_tictactoe.stUT	 NQEiux       "======================================================================
|
|   Smalltalk Gtk+ bindings examples
|
 ======================================================================"

"======================================================================
|
| Copyright 2001, 2003, 2009 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.  
|
 ======================================================================"


PackageLoader fileInPackage: 'GTK'.


Namespace current: GTK [

Object subclass: TicTacToe [
    | table buttons window turn state count |
    
    <category: nil>
    <comment: nil>

    button: i setLabel: aString [
	"Note that we get a GtkLabel automagically.  That's because
	 GNU Smalltalk calls #narrow on the GtkWidget returned by
	 gtk_bin_get_child before returning it to us."

	<category: 'data'>
	(buttons at: i) getChild setLabel: aString
    ]

    reset [
	<category: 'data'>
	table := Array new: 9.
	count := 0.
	turn := 'X'.
	state := #neutral.
	1 to: 9 do: [:i | self button: i setLabel: i printString]
    ]

    play: which [
	<category: 'data'>
	state == #neutral ifFalse: [^self].
	(table at: which) isNil 
	    ifTrue: 
		[table at: which put: turn.
		self button: which setLabel: turn.
		count := count + 1.
		count = 9 ifTrue: [state := #draw].
		self win ifTrue: [state := #win].
		state == #win ifTrue: [self message: turn , ' wins!'].
		state == #draw ifTrue: [self message: 'It''s a draw!'].
		turn := turn = 'X' ifTrue: ['O'] ifFalse: ['X']]
    ]

    win [
	"Functional programming frenzy :-)"

	<category: 'data'>
	^#(#(1 2 3) #(4 5 6) #(7 8 9) #(1 4 7) #(2 5 8) #(3 6 9) #(1 5 9) #(3 5 7)) 
	    anySatisfy: 
		[:combo | 
		((combo collect: [:i | table at: i]) 
		    fold: [:a :b | a = b ifTrue: [a] ifFalse: [nil]]) notNil]
    ]

    resetClicked: object data: data [
	<category: 'event handling'>
	self reset
    ]

    clicked: object data: data [
	<category: 'event handling'>
	self play: data
    ]

    destroy: object data: data [
	<category: 'event handling'>
	Gtk mainQuit
    ]

    message: aString [
	<category: 'window layout'>
	| dialog |
	dialog := GtkMessageDialog 
		    new: window
		    flags: Gtk gtkDialogDestroyWithParent
		    type: Gtk gtkMessageInfo
		    buttons: Gtk gtkButtonsClose
		    message: aString.
	dialog
	    run;
	    destroy
    ]

    open [
	<category: 'window layout'>
	| button vbox hbox |
	window := GtkWindow new: Gtk gtkWindowToplevel.
	window setTitle: 'Tic-tac-toe'.
	window 
	    connectSignal: 'destroy'
	    to: self
	    selector: #destroy:data:
	    userData: nil.
	window setBorderWidth: 10.
	vbox := GtkVBox new: false spacing: 0.
	vbox setBorderWidth: 2.
	window add: vbox.
	buttons := Array new: 9.
	1 to: 7
	    by: 3
	    do: 
		[:i | 
		hbox := GtkHBox new: true spacing: 0.
		vbox 
		    packStart: hbox
		    expand: true
		    fill: true
		    padding: 0.
		i to: i + 2
		    do: 
			[:j | 
			buttons at: j put: (button := GtkButton newWithLabel: '').
			button 
			    connectSignal: 'clicked'
			    to: self
			    selector: #clicked:data:
			    userData: j.
			hbox 
			    packStart: button
			    expand: true
			    fill: true
			    padding: 0]].
	button := GtkButton newWithLabel: 'Reset'.
	button 
	    connectSignal: 'clicked'
	    to: self
	    selector: #resetClicked:data:
	    userData: nil.
	vbox 
	    packEnd: button
	    expand: false
	    fill: false
	    padding: 0.
	vbox 
	    packEnd: GtkHSeparator new
	    expand: false
	    fill: false
	    padding: 5.
	self reset.
	window setDefaultSize: 100 height: 130.
	window showAll
    ]
]

]



Namespace current: GTK [
    TicTacToe new open.
    Gtk main
]

PK
     
wB̕      example_tree.stUT	 NQEiux       "======================================================================
|
|   Smalltalk Gtk+ bindings examples
|
 ======================================================================"


PackageLoader fileInPackage: 'GTK'.


Namespace current: GTK [

Object subclass: TreeExample [
    | window treeView treeModel button tree entries selection |
    
    <category: nil>
    <comment: nil>

    closeClicked: aSender [
	<category: 'event handling'>
	window destroy
    ]

    destroy: aSender [
	<category: 'event handling'>
	Gtk mainQuit
    ]

    selectionChangedCallback: aSender [
	<category: 'event handling'>
	| it i |
	treeView getSelection getMode = Gtk gtkSelectionSingle ifFalse: [^self].
	it := GtkTreeIter type new.
	selection := (treeView getSelection getSelected: nil iter: it) 
		    ifTrue: [entries at: (tree getOop: it column: 0)]
		    ifFalse: [nil].
	('Selection: ' , selection printString) printNl
    ]

    rowActivatedCallback: aSender [
	<category: 'event handling'>
	'Row activated!' printNl
    ]

    defaultExpand [
	<category: 'window layout'>
	"Expand all root nodes"

	| it |
	it := GtkTreeIter type new.
	tree iterChildren: it parent: nil.
	it isNil ifTrue: [^self].
	
	[treeView expandToPath: (tree getPath: it).
	tree iterNext: it] whileTrue
    ]

    open [
	<category: 'window layout'>
	"Visual components"

	| vbox frame scroll col rend typs |
	window := GtkWindow new: Gtk gtkWindowToplevel.
	window setTitle: 'Tree Example'.
	window 
	    connectSignal: 'destroy'
	    to: self
	    selector: #destroy:
	    userData: nil.
	window setBorderWidth: 10.
	vbox := GtkVBox new: false spacing: 9.
	vbox setBorderWidth: 2.
	window add: vbox.
	frame := GtkFrame new: nil.
	vbox 
	    packStart: frame
	    expand: true
	    fill: true
	    padding: 0.
	scroll := GtkScrolledWindow new: nil vadjustment: nil.
	frame add: scroll.
	scroll setPolicy: Gtk gtkPolicyAutomatic
	    vscrollbarPolicy: Gtk gtkPolicyAutomatic.
	treeView := GtkTreeView new.
	scroll add: treeView.
	treeView getSelection 
	    connectSignal: 'changed'
	    to: self
	    selector: #selectionChangedCallback:
	    userData: nil.
	treeView 
	    connectSignal: 'row-activated'
	    to: self
	    selector: #rowActivatedCallback:
	    userData: nil.
	button := GtkButton newWithLabel: 'Close'.
	button 
	    connectSignal: 'clicked'
	    to: self
	    selector: #closeClicked:
	    userData: nil.
	vbox 
	    packStart: button
	    expand: false
	    fill: false
	    padding: 0.

	"typs := (CArrayCType elementType: CIntType numberOfElements: 3) new.
	 typs
	 at: 0 put: (GValue typeFromName: 'gint');
	 at: 1 put: (GValue typeFromName: 'gchararray');
	 at: 2 put: (GValue typeFromName: 'gchararray').
	 
	 tree := GtkTreeStore newv: 3 types: typs."
	tree := GtkTreeStore new: 3
		    varargs: 
			{GValue gTypeInt.
			GValue gTypeString.
			GValue gTypeString}.

	"TreeStore"
	col := GtkTreeViewColumn new.
	treeView insertColumn: col position: -1.	"-1 => append"
	col setTitle: 'Class'.
	col packStart: (rend := GtkCellRendererText new) expand: true.
	col 
	    addAttribute: rend
	    attribute: 'text'
	    column: 1.
	col 
	    addAttribute: rend
	    attribute: 'foreground'
	    column: 2.
	treeView setModel: tree.

	"Display"
	window setDefaultSize: 300 height: 500.
	window showAll
    ]

    topLevelNodes [
	<category: 'window layout'>
	| cls |
	cls := Array 
		    streamContents: [:stream | Smalltalk allClassesDo: [:each | stream nextPut: each]].
	^cls 
	    select: [:each | each superclass isNil or: [each superclass environment ~= Smalltalk]]
    ]

    getChildNodesFor: aNode [
	<category: 'window layout'>
	aNode isNil ifTrue: [^self topLevelNodes].
	aNode isClass 
	    ifTrue: [^aNode subclasses select: [:each | each environment = Smalltalk]].
	^nil
    ]

    getColumnValuesFor: aNode [
	<category: 'window layout'>
	^aNode isClass 
	    ifTrue: 
		[
		{aNode name ifNil: ['<unnamed>'].
		aNode subclasses size > 1 ifTrue: ['blue'] ifFalse: ['black']}]
	    ifFalse: 
		[
		{aNode printString.
		'gray'}]
    ]

    buildNode: aNode atIter: aIter [
	<category: 'window layout'>
	| nds cols lbl it n |
	nds := self getChildNodesFor: aNode.
	nds isNil ifTrue: [^self].
	cols := OrderedCollection new: nds size.
	nds do: [:nd | cols add: nd -> (self getColumnValuesFor: nd)].

	"Sort by first column"
	cols := cols 
		    asSortedCollection: [:a :b | (a value at: 1) <= (b value at: 1)].
	cols do: 
		[:each | 
		n := entries size + 1.
		it := GtkTreeIter type new.
		tree append: it parent: aIter.
		tree 
		    setOop: it
		    column: 0
		    value: n.
		each value doWithIndex: 
			[:col :i | 
			tree 
			    setOop: it
			    column: i
			    value: col].
		entries at: n put: each key.
		self buildNode: each key atIter: it]
    ]

    buildTree [
	<category: 'window layout'>
	entries := Dictionary new.	"entries is the reverse lookup"
	self buildNode: nil atIter: nil
    ]
]

]



Namespace current: GTK [
    TreeExample new open buildTree defaultExpand.
    Gtk main
]

PK
     kh[Ӫ    
  Structs.stUT	 EiEiux       "Automatically generated, do not edit!"
CObject variableWordSubclass: #GValue
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

CObject variableWordSubclass: #GTypeInstance
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

GTypeInstance variableWordSubclass: #GObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

GObject variableWordSubclass: #GtkObject
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

CObject variableWordSubclass: #GdkAtom
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

CObject variableWordSubclass: #GtkWidget
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

GtkWidget variableWordSubclass: #GtkEditable
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

PK
     kh[a`      Enums.stUT	 EiEiux       "Automatically generated, do not edit!"
!GValue class methodsFor: 'fundamental types'!

gTypeInvalid ^0!
gTypeNone ^4!
gTypeInterface ^8!
gTypeChar ^12!
gTypeUchar ^16!
gTypeBoolean ^20!
gTypeInt ^24!
gTypeUint ^28!
gTypeLong ^32!
gTypeUlong ^36!
gTypeInt64 ^40!
gTypeUint64 ^44!
gTypeEnum ^48!
gTypeFlags ^52!
gTypeFloat ^56!
gTypeDouble ^60!
gTypeString ^64!
gTypePointer ^68!
gTypeBoxed ^72!
gTypeParam ^76!
gTypeObject ^80! !

!Gtk class methodsFor: 'stock objects'!

gtkStockDialogInfo ^'gtk-dialog-info'!
gtkStockDialogWarning ^'gtk-dialog-warning'!
gtkStockDialogError ^'gtk-dialog-error'!
gtkStockDialogQuestion ^'gtk-dialog-question'!
gtkStockDnd ^'gtk-dnd'!
gtkStockDndMultiple ^'gtk-dnd-multiple'!
gtkStockAdd   ^'gtk-add'!
gtkStockApply ^'gtk-apply'!
gtkStockBold  ^'gtk-bold'!
gtkStockCancel ^'gtk-cancel'!
gtkStockCdrom ^'gtk-cdrom'!
gtkStockClear ^'gtk-clear'!
gtkStockClose ^'gtk-close'!
gtkStockColorPicker ^'gtk-color-picker'!
gtkStockConvert ^'gtk-convert'!
gtkStockCopy ^'gtk-copy'!
gtkStockCut ^'gtk-cut'!
gtkStockDelete ^'gtk-delete'!
gtkStockExecute ^'gtk-execute'!
gtkStockFind ^'gtk-find'!
gtkStockFindAndReplace ^'gtk-find-and-replace'!
gtkStockFloppy ^'gtk-floppy'!
gtkStockGotoBottom ^'gtk-goto-bottom'!
gtkStockGotoFirst ^'gtk-goto-first'!
gtkStockGotoLast ^'gtk-goto-last'!
gtkStockGotoTop ^'gtk-goto-top'!
gtkStockGoBack ^'gtk-go-back'!
gtkStockGoDown ^'gtk-go-down'!
gtkStockGoForward ^'gtk-go-forward'!
gtkStockGoUp ^'gtk-go-up'!
gtkStockHelp ^'gtk-help'!
gtkStockHome ^'gtk-home'!
gtkStockIndex ^'gtk-index'!
gtkStockItalic ^'gtk-italic'!
gtkStockJumpTo ^'gtk-jump-to'!
gtkStockJustifyCenter ^'gtk-justify-center'!
gtkStockJustifyFill ^'gtk-justify-fill'!
gtkStockJustifyLeft ^'gtk-justify-left'!
gtkStockJustifyRight ^'gtk-justify-right'!
gtkStockMissingImage ^'gtk-missing-image'!
gtkStockNew ^'gtk-new'!
gtkStockNo ^'gtk-no'!
gtkStockOk ^'gtk-ok'!
gtkStockOpen ^'gtk-open'!
gtkStockPaste ^'gtk-paste'!
gtkStockPreferences ^'gtk-preferences'!
gtkStockPrint ^'gtk-print'!
gtkStockPrintPreview ^'gtk-print-preview'!
gtkStockProperties ^'gtk-properties'!
gtkStockQuit ^'gtk-quit'!
gtkStockRedo ^'gtk-redo'!
gtkStockRefresh ^'gtk-refresh'!
gtkStockRemove ^'gtk-remove'!
gtkStockRevertToSaved ^'gtk-revert-to-saved'!
gtkStockSave ^'gtk-save'!
gtkStockSaveAs ^'gtk-save-as'!
gtkStockSelectColor ^'gtk-select-color'!
gtkStockSelectFont ^'gtk-select-font'!
gtkStockSortAscending ^'gtk-sort-ascending'!
gtkStockSortDescending ^'gtk-sort-descending'!
gtkStockSpellCheck ^'gtk-spell-check'!
gtkStockStop ^'gtk-stop'!
gtkStockStrikethrough ^'gtk-strikethrough'!
gtkStockUndelete ^'gtk-undelete'!
gtkStockUnderline ^'gtk-underline'!
gtkStockUndo ^'gtk-undo'!
gtkStockYes ^'gtk-yes'!
gtkStockZoom100 ^'gtk-zoom-100'!
gtkStockZoomFit ^'gtk-zoom-fit'!
gtkStockZoomIn ^'gtk-zoom-in'!
gtkStockZoomOut ^'gtk-zoom-out'! !

PK
     kh[a(   (     Funcs.stUT	 EiEiux       "Automatically generated, do not edit!"
PK
     kh[g<                  package.xmlUT Eiux       PK
     B7
Xk
  k
  
            GtkDecl.stUT aQux       PK
     B;
V  V            
  MoreStructs.stUT aQux       PK
     BI              ]  MoreFuncs.stUT aQux       PK
     BsaW  W  
          %=  GtkImpl.stUT aQux       PK
     
wBb򜣝                example_arrow.stUT NQux       PK
     
wB<	  	            f  example_aspectframe.stUT NQux       PK
     
wB<  <            ũ  example_buttonbox.stUT NQux       PK
     
wBb%T  T            O  example_entry.stUT NQux       PK
     
wBl+	  	              example_eventbox.stUT NQux       PK
     
wB8                example_hello.stUT NQux       PK
     
wB|@;                example_tictactoe.stUT NQux       PK
     
wB̕                example_tree.stUT NQux       PK
     kh[Ӫ    
          q Structs.stUT Eiux       PK
     kh[a`               Enums.stUT Eiux       PK
     kh[a(   (              Funcs.stUT Eiux       PK      C  J   