package org.cdavies.itunes;

import java.util.*;

import org.cdavies.itunes.hash.*;
import org.cdavies.itunes.request.*;

public class ItunesConnectionFactory {
	
	private Vector _connections;
	
	public ItunesConnectionFactory() {
		
		_connections = new Vector(5);
		
	}
	
	private ItunesConnection locateExistingConnection(String server, int port) {
		
		String _serverName = server + ":" + port;
		Enumeration _e = _connections.elements();
		
		ItunesConnection _conn;
		
		while (_e.hasMoreElements()) {
			
			_conn = (ItunesConnection)_e.nextElement();
			if (_serverName.equals(_conn.getServerName() + ":" + _conn.getPort()))
				return _conn;
				
		
		}
		
		return null;
		
	}
	
	public void removeCachedItunesConnection(String name) {
		
		ItunesConnection _conn;
		
		for (int _i = 0; _i < _connections.size(); _i++) {
			
			_conn = (ItunesConnection)_connections.elementAt(_i);
			if (_conn.toString().equals(name)) {
				
				_connections.removeElementAt(_i);
				break;
				
			}
			
		}
		
	}
	
	public ItunesConnection produceConnectionInstance(String server, int port, String serverTitle) throws NoServerPermissionException {
		
		ItunesConnection _conn;
		
		if ((_conn = locateExistingConnection(server, port)) != null)
			return _conn;
		
		/* Determing the version of our DAAP server, and construct a suitable connection */
		
		ServerInfoRequest _sir = new LegacyServerInfoRequest(server, port);
		_sir.setHash(new Itunes45Hash());
		_sir.constructQuery();
		_sir.runQuery();
		_sir.process();
		
		double _daapVersion = _sir.getServerDAAPVersion();
		
		if (_daapVersion < 3)
			_conn = new Itunes4Connection(server, port, serverTitle);
		else
			_conn = new Itunes45Connection(server, port, serverTitle);
		
		_connections.add(_conn);
		
		return _conn;
		
	}
	
}
