/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import org.igoweb.igoweb.client.CGameListEntry;
import org.igoweb.igoweb.client.CGlobalGames;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.ClientPanel;
import org.igoweb.igoweb.client.swing.GameList;
import org.igoweb.igoweb.shared.GameContainers;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.IntHashSet;

public abstract class GlobalGamePanel
extends ClientPanel
implements EventListener,
ActionListener {
    private final GameList gameList;
    private final CGlobalGames games;
    private IntHashSet knownGames;

    public GlobalGamePanel(Client client, CGlobalGames newGames) {
        this.setLayout(new BorderLayout());
        this.games = newGames;
        this.add("North", this.titlePanel);
        String name = Defs.getString(1689845736 + newGames.type.ordinal());
        this.setName(name);
        this.titlePanel.add("xGrow=t", new JLabel(name));
        this.titlePanel.add("xGrow=f", this.popBut);
        this.titlePanel.add(this.closeBut);
        this.closeBut.addActionListener(this);
        this.gameList = this.buildGameList(newGames, client, (newGames.type == GameContainers.CHALLENGES ? 1 : (newGames.type == GameContainers.FANS ? 0 : 4)) | 2);
        newGames.addListener(this.gameList);
        newGames.addListener(this);
        this.add(this.gameList);
        if (newGames.type == GameContainers.FANS) {
            this.knownGames = new IntHashSet();
        }
    }

    @Override
    public String getSortKey() {
        return "0 " + (Object)((Object)this.games.type);
    }

    @Override
    public boolean closeForTournament() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeBut) {
            this.close();
        }
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 16: {
                this.emit(65540);
                break;
            }
            case 57: {
                if (this.knownGames == null || !this.knownGames.add(((CGameListEntry)event.arg).id)) break;
                this.emit(65537);
                break;
            }
            case 58: {
                if (this.knownGames == null) break;
                this.knownGames.remove(((CGameListEntry)event.arg).id);
                if (!this.knownGames.isEmpty()) break;
                this.emit(65538);
            }
        }
    }

    @Override
    public void close() {
        this.games.sendUnjoinRequest();
    }

    public GameContainers getType() {
        return this.games.type;
    }

    public abstract GameList buildGameList(CGlobalGames var1, Client var2, int var3);
}

