/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.utils.ProcessUtils;
import net.sf.gogui.utils.StringUtils;

public class Platform {
    public static String getHostInfo() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "?";
        }
        try {
            String[] stringArray;
            String string2;
            int n;
            if (new File("/proc/cpuinfo").exists() && (n = (string2 = ProcessUtils.runCommand((String[])(stringArray = new String[]{"/bin/sh", "-c", "grep '^model name' /proc/cpuinfo"}))).indexOf(58)) >= 0) {
                string = string + " (";
                int n2 = string2.indexOf("\n");
                string = n2 >= 0 ? string + string2.substring(n + 1, n2).trim() : string + string2.substring(n + 1).trim();
                string = string + ")";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static boolean isGnuClasspath() {
        return System.getProperty("gnu.classpath.version") != null;
    }

    public static boolean isMac() {
        return System.getProperty("mrj.version") != null;
    }

    public static boolean isUnix() {
        String string = System.getProperty("os.name");
        return string.indexOf("nix") >= 0 || string.indexOf("nux") >= 0;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean openInExternalBrowser(URL uRL) {
        if (Platform.isMac()) {
            String[] stringArray = new String[]{"/usr/bin/open", uRL.toString()};
            if (Platform.runProcess(stringArray)) {
                return true;
            }
        } else if (Platform.isWindows()) {
            String[] stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", uRL.toString()};
            if (Platform.runProcess(stringArray)) {
                return true;
            }
        } else if (Platform.isUnix()) {
            String[] stringArray = new String[]{"xdg-open", uRL.toString()};
            if (Platform.runProcess(stringArray)) {
                return true;
            }
            if (Platform.checkKDERunning() && Platform.runProcess(stringArray = new String[]{"kfmclient", "openURL", uRL.toString()})) {
                return true;
            }
            stringArray = new String[]{"firefox", uRL.toString()};
            if (Platform.runProcess(stringArray)) {
                return true;
            }
            stringArray = new String[]{"mozilla", uRL.toString()};
            if (Platform.runProcess(stringArray)) {
                return true;
            }
            stringArray = new String[]{"opera", uRL.toString()};
            if (Platform.runProcess(stringArray)) {
                return true;
            }
        }
        return false;
    }

    public static void registerSpecialMacHandler(SpecialMacHandler specialMacHandler) {
        try {
            Object[] objectArray = new Object[]{specialMacHandler};
            Class[] classArray = new Class[]{SpecialMacHandler.class};
            String string = "net.sf.gogui.specialmac.RegisterSpecialMacHandler";
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            StringUtils.printException(exception);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            StringUtils.printException(noClassDefFoundError);
        }
    }

    private static boolean checkKDERunning() {
        try {
            String[] stringArray = new String[]{"dcop"};
            String string = ProcessUtils.runCommand((String[])stringArray);
            return string.indexOf("kicker") >= 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean runProcess(String[] stringArray) {
        try {
            ProcessUtils.runProcess((String[])stringArray);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

