/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console.prefs;

import free.jin.BadChangesException;
import free.jin.I18n;
import free.jin.console.ConsoleManager;
import free.jin.ui.PreferencesPanel;
import free.util.swing.PreferredSizedPanel;
import java.awt.Component;
import java.awt.Container;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class EncodingPrefsPanel
extends PreferencesPanel {
    private final ConsoleManager consoleManager;
    private final JList encodingsList;

    public EncodingPrefsPanel(ConsoleManager consoleManager) {
        this.consoleManager = consoleManager;
        this.encodingsList = new JList<Object>(Charset.availableCharsets().values().toArray());
        this.encodingsList.setSelectionMode(0);
        this.encodingsList.addListSelectionListener(this.proxyListSelectionListener);
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.encodingsList.setVisibleRowCount(10);
        PreferredSizedPanel preferredSizedPanel = new PreferredSizedPanel();
        preferredSizedPanel.setLayout(new BoxLayout((Container)preferredSizedPanel, 1));
        preferredSizedPanel.setAlignmentX(0.0f);
        JLabel jLabel = I18n.get((Class)EncodingPrefsPanel.class).createLabel("encodingsLabel");
        jLabel.setAlignmentX(0.0f);
        jLabel.setLabelFor(this.encodingsList);
        preferredSizedPanel.add(jLabel);
        preferredSizedPanel.add(Box.createVerticalStrut(10));
        JScrollPane jScrollPane = new JScrollPane(this.encodingsList);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.encodingsList.setSelectedValue(Charset.forName(this.consoleManager.getEncoding()), true);
        preferredSizedPanel.add(jScrollPane);
        this.add((Component)preferredSizedPanel);
    }

    public void applyChanges() throws BadChangesException {
        Charset charset = (Charset)this.encodingsList.getSelectedValue();
        try {
            this.consoleManager.setEncoding(charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }
}

