/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import gnu.xml.xpath.XPathParser;
import gnu.xml.xpath.XPathTokenizer;
import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.xml.sax.InputSource;

public class XPathImpl
implements XPath {
    XPathParser parser = new XPathParser();
    NamespaceContext namespaceContext;
    XPathVariableResolver variableResolver;
    XPathFunctionResolver functionResolver;

    public void reset() {
        this.parser.namespaceContext = this.namespaceContext;
        this.parser.variableResolver = this.variableResolver;
        this.parser.functionResolver = this.functionResolver;
    }

    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.parser.variableResolver = xPathVariableResolver;
    }

    public XPathVariableResolver getXPathVariableResolver() {
        return this.parser.variableResolver;
    }

    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        this.parser.functionResolver = xPathFunctionResolver;
    }

    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.parser.functionResolver;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.parser.namespaceContext = namespaceContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.parser.namespaceContext;
    }

    public XPathExpression compile(String string) throws XPathExpressionException {
        XPathTokenizer xPathTokenizer = new XPathTokenizer(string);
        try {
            return (Expr)this.parser.yyparse(xPathTokenizer);
        }
        catch (IOException iOException) {
            throw new XPathExpressionException(iOException);
        }
        catch (XPathParser.yyException yyException2) {
            throw new XPathExpressionException(string);
        }
    }

    public Object evaluate(String string, Object object, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object, qName);
    }

    public String evaluate(String string, Object object) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object);
    }

    public Object evaluate(String string, InputSource inputSource, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource, qName);
    }

    public String evaluate(String string, InputSource inputSource) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource);
    }

    XPathImpl(NamespaceContext namespaceContext, XPathVariableResolver xPathVariableResolver, XPathFunctionResolver xPathFunctionResolver) {
        this.namespaceContext = namespaceContext;
        this.variableResolver = xPathVariableResolver;
        this.functionResolver = xPathFunctionResolver;
        this.reset();
    }
}

