#---------------------------------------------------------------
# The configuration options
#---------------------------------------------------------------
source "options.tcl"

#---------------------------------------------------------------
# Setting up the windows
#---------------------------------------------------------------

#---------------------------------------------------------------
# (1) The menu bar
#---------------------------------------------------------------
source "menu.tcl"

#---------------------------------------------------------------
# (2) The banner
#---------------------------------------------------------------
label .title -text "The Keyboard Practicer" -relief groove -bd 2 \
	-font "-adobe-helvetica-bold-r-normal--17-*-75-75-*-*-*-*"
pack .title -fill x -padx 4 -pady 4

#---------------------------------------------------------------
# (3) The text
#---------------------------------------------------------------
frame .text -relief groove -bd 2
scrollbar .text.vsb -orient "vertical" -command {.text.text yview}
text .text.text -relief sunken -bd 2 -height 11 -width 84 \
	-yscrollcommand {.text.vsb set} -takefocus 0
pack .text.vsb -side left -fill y
pack [frame .text.dummy -width 4] -side left
pack .text.text -side left -fill x
pack .text -side top -fill x -padx 4

#---------------------------------------------------------------
# (4) The status area
#---------------------------------------------------------------
source "status.tcl"

#---------------------------------------------------------------
# (5) The keyboard
#---------------------------------------------------------------
source "keyboard.tcl"

#---------------------------------------------------------------
# Help utilities
#---------------------------------------------------------------
source "help.tcl"

#---------------------------------------------------------------
# Where the user's keystrokes go
#---------------------------------------------------------------
source "entry.tcl"

#---------------------------------------------------------------
# Cursor movements
#---------------------------------------------------------------
source "cursor.tcl"

remapkeys 0 0 0

#---------------------------------------------------------------
# The initial message
#---------------------------------------------------------------
#\n\t\"',-_=+ <= some special keys :)\

set initmessage	"Welcome to the Keyboard Practicer (KP)!\
\n\nHit the key that is indicated by the cursor.  The cursor will advance\
\nif you hit the right key.\
\n\nThis is the initial screen.\
\nSelect the \"Load file\" button in the File menu to try other files.\
\nSelect the \"Reload initial screen\" button in the File menu\
to get back here.\
\n\nYou might want to play around with the Options menu too.\
\n\nEnjoy! :) \n"

#---------------------------------------------------------------
# Procedure: settext {text}
#  Sets text
#---------------------------------------------------------------
proc settext {text} {
    global origtext
    # delete doublestrikes and underlines
    regsub -all ".\b" $text "" text
    display "$text"
    set origtext "$text"
}

#---------------------------------------------------------------
# Procedure: display {text}
#  Displays text
#---------------------------------------------------------------
proc display {text} {
    # delete multiple empty lines
    regsub -all "\n(( |\t)*\n)+" $text "\n\n" text
    .text.text delete 1.0 end
    .text.text insert end "$text"
    .text.text mark set insert 1.0
    retag
}
set origtext ""

#---------------------------------------------------------------
# Procedure: reload
#  Reloads initial screen.
#---------------------------------------------------------------
proc reload {} {
    global initmessage
    settext "$initmessage"
}

#---------------------------------------------------------------
# Procedure: reinit
#  Resets stats.
#---------------------------------------------------------------
proc reinit {} {
    global speed mistakes
    set speed 0
    set mistakes 0.000
}

#---------------------------------------------------------------
# The file utilities
#---------------------------------------------------------------
source "file.tcl"

if {[loadfilename] != ""} {
    loadfile [loadfilename]
} else {
    reload
}

#---------------------------------------------------------------
# The filter utilities
#---------------------------------------------------------------
source "filter.tcl"

#---------------------------------------------------------------
# Procedure: press {b c}
#  Press button $b, do $c, then reset $b
#---------------------------------------------------------------
proc press {b c} {
    $b configure -relief sunken
    update idletasks
    eval "$c"
    # Check if button is still there...sometimes the command
    #  will destroy it
    if [winfo exists $b] {
	$b configure -relief raised
    }
}

#---------------------------------------------------------------
# Procedure: relative {parent child xoffset yoffset}
#  Sets geometry of $child to be +$xoffset+$yoffset relative
#   from $parent's.
#---------------------------------------------------------------
proc relative {parent child xoffset yoffset} {
    regexp {\+([0-9]+)\+([0-9]+)$} [wm geometry $parent] dummy x y
    wm geometry $child +[expr $x+$xoffset]+[expr $y+$yoffset]
}
