package TDS::Skelton;
# $Id: Skelton.pm,v 1.21 2001/01/03 08:20:43 tom Exp $
################################################################

=head1 NAME

TDS::Skelton - TDS ѥȥ

=head1 SYNOPSIS

=cut

use strict qw(vars);
use vars qw(@ISA @EXPORT
	    $MetaGeneratorTemplate $TDS_BannerTemplate);
use Exporter;

use Skelton;
use JConv;
use Template;

use TDS;
use TDS::System;
use TDS::Status;
use TDS::IdentInfo;
use TDS::Mode;
use TDS::DirInfo;

@ISA = qw(Skelton);
@EXPORT = qw(attributes);

attributes qw();


$MetaGeneratorTemplate = qq(<meta name="generator" content="Tomsoft Diary System/%version (%mode)">\n)
    unless defined $MetaGeneratorTemplate;
$TDS_BannerTemplate = qq(<a href="%tds_homepage"><img src="%src" width="%width" height="%height" alt="%alt" border="%border" align="%align"></a>)
    unless defined $TDS_BannerTemplate;

################################################################
sub initialize($)
{
    my $self = shift;
#    print "content-type: text/html\n\n<h1>from Skelton</h1>";
    unless ($self->filename){
	my $class = ref $self;
	my $var = "${class}::SkeltonFilename";
	my $filename = $$var;
	my $skelton_file = GetStyleDir() . "/$filename";
	if (-f $skelton_file){
	    $self->filename($skelton_file);
	} else {
	    #$self->filename(GetWebDiaryDir() . "/$filename");
	    $self->filename(GetCustomizeDir() . "/$filename");	    
	}
    }
    $self->SUPER::initialize;
}
    
sub SetMacros($)
{
    my $self = shift;

    # add generator description to head using meta
    {
	my $skelton = $self->skelton;
	my $version = $TDS::Version;
	my $mode = TDS::Mode::GetMode();
	my $params = {'version'=>$version,
		      'mode'=>$mode};
	my $value = Expand($MetaGeneratorTemplate, $params);
	$skelton =~ s@(</head>)@$value$1@i;
#	$skelton =~ s@(</head>)@<meta name="generator" content="Tomsoft Diary System/$version ($mode)">\n$1@i;
	$self->skelton($skelton);
    }
	
    # system variable
    $self->SetMacro("TDS\$", qq(<a href="$TDS::TDSHomePage">Tomsoft Diary System $TDS::Version</a>));
    $self->SetMacro("TDS_BANNER", sub {
	my $params = {'tds_homepage'=>$TDS::TDSHomePage,
		      'src'=>'image/tds-banner.jpg',
		      width=>200, height=>40,
		      alt=>'[TDS]',
		      border=>'0',
		      align=>'right'};
	return Expand($TDS_BannerTemplate, $params);
	#qq(<a href="$TDS::TDSHomePage"><img src="image/tds-banner.jpg" width="200" height="40" alt="[TDS]" border="0" align="right"></a>)});
    });
    
    $self->SetMacro("VERSION", sub {
	my ($self, $cmd, $var) = @_;
	# lib ͭλlib/ ʲ script Ťǽ
	if ($TDS::SetupedVersion ne $TDS::Version){
	    return qq($TDS::SetupedVersion(lib:$TDS::Version));
	} else {
	    return $TDS::Version;
	}
    });
    $self->SetMacro("DIARY_URL", TDS::IdentInfo->Get('url'));
    $self->SetMacro("BASE_URL", sub {
	my $url = TDS::IdentInfo->Get('url');
	$url =~ m!^(.*/)[^/]*$!;
	return $1;
    });
    $self->SetMacro("CHARSET", sub {
	return Skelton::GetOutputCharset();
    });
    $self->SetMacro("MAIL_ADDRESS", TDS::IdentInfo->Get('address'));
    $self->SetMacro("MAILTO", sub {
	my ($self, $cmd, $var) = @_;
	$var ||= TDS::IdentInfo->Get('author');
	return sprintf(qq(<a href="mailto:%s">%s</a>),
		     TDS::IdentInfo->Get('address'),
		       $var);
    });
    $self->SetMacro("AUTHOR_NAME", TDS::IdentInfo->Get('author'));

    # ȥ ???
    $self->SetMacro("TITLE", TDS::IdentInfo->Get('title'))
	unless $self->hash->{"TITLE"};

    # ǯ
    $self->SetMacro("YEAR", $TDS::Status->year);
    $self->SetMacro("MONTH", $TDS::Status->month);
    $self->SetMacro("EXIST_YEARS", sub {
	my ($self, $cmd, $var) = @_;

	my @exist_years = @{$TDS::Status->exist_years};
	my $rtn = shift @exist_years;
	my $old = $rtn;
	my $n = 0;
	for (@exist_years){
	    if ($_ == $old+1){    # ³Ƥ
		unless ($n){         # ä³
		    $rtn .= "-";
		}
		$n = $_;
	    } else {              # Ǥ
		if ($n){             # ³Ƥ
		    $rtn .= $n;        # Ĥ
		}
		$rtn .= ",$_";
		$n = 0;           # ³ꥢ
	    }
	    $old = $_;
	}
	if ($n){
	    $rtn .= $n;
	}
	return $rtn;
    });
	
    $self->SUPER::SetMacros;
}
1;
