/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2022-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_DISPATCH_H
#define VATOMIC_DISPATCH_H
/*******************************************************************************
 * @file dispatch.h
 * @brief Set of macros to dispatch atomic functions.
 *
 * These macros select the atomic function variant based on the
 * argument type, for example, vatomic_read(a) calls vatomic32_read(a) if `a` is
 * a vatomic32_t and calls vatomic64_read(a) if `a` is a vatomic64_t.
 * vatomicptr_t is mapped to either 32 or 64 bits functions depending on the
 * architecture.
 ******************************************************************************/
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */

#include <vsync/atomic/internal/dispatch.h>

/* *****************************************************************************
 * init
 * ****************************************************************************/

/**
 * @def vatomic_init(a, v)
 * @brief Dispatches init calls with configurable memory order.
 *
 * See @ref vatomic32_init for details.
 *
 * @param a atomic variable
 * @param v initial value
 */
#define vatomic_init(a, v) vatomic_write(a, v)

/* *****************************************************************************
 * read/write/xchg/cmpxchg
 * ****************************************************************************/

/**
 * @def vatomic_read(a)
 * @brief Dispatches read calls with seq_cst memory order.
 *
 * See @ref vatomic32_read for details.
 *
 * @param a atomic variable
 * @return current value
 * @memord seq_cst
 */
#define vatomic_read(a) V_DISPATCH(ALL_RET, read, mo_seq, a)
/**
 * @def vatomic_read_acq(a)
 * @brief Dispatches read calls with acquire memory order.
 *
 * See @ref vatomic32_read_acq for details.
 *
 * @param a atomic variable
 * @return current value
 * @memord acquire
 */
#define vatomic_read_acq(a) V_DISPATCH(ALL_RET, read, mo_acq, a)
/**
 * @def vatomic_read_rlx(a)
 * @brief Dispatches read calls with relaxed memory order.
 *
 * See @ref vatomic32_read_rlx for details.
 *
 * @param a atomic variable
 * @return current value
 * @memord relaxed
 */
#define vatomic_read_rlx(a) V_DISPATCH(ALL_RET, read, mo_rlx, a)

/**
 * @def vatomic_write(a, v)
 * @brief Dispatches write calls with seq_cst memory order.
 *
 * See @ref vatomic32_write for details.
 *
 * @param a atomic variable
 * @param v new value
 * @memord seq_cst
 */
#define vatomic_write(a, v) V_DISPATCH(ALL, write, mo_seq, a, v)
/**
 * @def vatomic_write_rel(a, v)
 * @brief Dispatches write calls with release memory order.
 *
 * See @ref vatomic32_write_rel for details.
 *
 * @param a atomic variable
 * @param v new value
 * @memord release
 */
#define vatomic_write_rel(a, v) V_DISPATCH(ALL, write, mo_rel, a, v)
/**
 * @def vatomic_write_rlx(a, v)
 * @brief Dispatches write calls with relaxed memory order.
 *
 * See @ref vatomic32_write_rlx for details.
 *
 * @param a atomic variable
 * @param v new value
 * @memord relaxed
 */
#define vatomic_write_rlx(a, v) V_DISPATCH(ALL, write, mo_rlx, a, v)

/**
 * @def vatomic_xchg(a, v)
 * @brief Dispatches xchg calls with seq_cst memory order.
 *
 * See @ref vatomic32_xchg for details.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord seq_cst
 */
#define vatomic_xchg(a, v) V_DISPATCH(ALL_RET, xchg, mo_seq, a, v)
/**
 * @def vatomic_xchg_acq(a, v)
 * @brief Dispatches xchg calls with acquire memory order.
 *
 * See @ref vatomic32_xchg_acq for details.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord acquire
 */
#define vatomic_xchg_acq(a, v) V_DISPATCH(ALL_RET, xchg, mo_acq, a, v)
/**
 * @def vatomic_xchg_rel(a, v)
 * @brief Dispatches xchg calls with release memory order.
 *
 * See @ref vatomic32_xchg_rel for details.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord release
 */
#define vatomic_xchg_rel(a, v) V_DISPATCH(ALL_RET, xchg, mo_rel, a, v)
/**
 * @def vatomic_xchg_rlx(a, v)
 * @brief Dispatches xchg calls with relaxed memory order.
 *
 * See @ref vatomic32_xchg_rlx for details.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord relaxed
 */
#define vatomic_xchg_rlx(a, v) V_DISPATCH(ALL_RET, xchg, mo_rlx, a, v)

/**
 * @def vatomic_cmpxchg(a, c, v)
 * @brief Dispatches cmpxchg calls with seq_cst memory order.
 *
 * See @ref vatomic32_cmpxchg for details.
 *
 * @param a atomic variable
 * @param c expected value
 * @param v new value
 * @return old value
 * @memord seq_cst
 */
#define vatomic_cmpxchg(a, c, v) V_DISPATCH(ALL_RET, cmpxchg, mo_seq, a, c, v)
/**
 * @def vatomic_cmpxchg_acq(a, c, v)
 * @brief Dispatches cmpxchg calls with acquire memory order.
 *
 * See @ref vatomic32_cmpxchg_acq for details.
 *
 * @param a atomic variable
 * @param c expected value
 * @param v new value
 * @return old value
 * @memord acquire
 */
#define vatomic_cmpxchg_acq(a, c, v)                                           \
    V_DISPATCH(ALL_RET, cmpxchg, mo_acq, a, c, v)
/**
 * @def vatomic_cmpxchg_rel(a, c, v)
 * @brief Dispatches cmpxchg calls with release memory order.
 *
 * See @ref vatomic32_cmpxchg_rel for details.
 *
 * @param a atomic variable
 * @param c expected value
 * @param v new value
 * @return old value
 * @memord release
 */
#define vatomic_cmpxchg_rel(a, c, v)                                           \
    V_DISPATCH(ALL_RET, cmpxchg, mo_rel, a, c, v)
/**
 * @def vatomic_cmpxchg_rlx(a, c, v)
 * @brief Dispatches cmpxchg calls with relaxed memory order.
 *
 * See @ref vatomic32_cmpxchg_rlx for details.
 *
 * @param a atomic variable
 * @param c expected value
 * @param v new value
 * @return old value
 * @memord relaxed
 */
#define vatomic_cmpxchg_rlx(a, c, v)                                           \
    V_DISPATCH(ALL_RET, cmpxchg, mo_rlx, a, c, v)

/* *****************************************************************************
 * RMW with 1 argument
 * ****************************************************************************/

/**
 * @def vatomic_inc(a)
 * @brief Dispatches inc calls with seq_cst memory order.
 *
 * See @ref vatomic32_inc for details.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
#define vatomic_inc(a) V_DISPATCH(INT, inc, mo_seq, a)
/**
 * @def vatomic_inc_rel(a)
 * @brief Dispatches inc calls with release memory order.
 *
 * See @ref vatomic32_inc_rel for details.
 *
 * @param a atomic variable
 * @memord release
 */
#define vatomic_inc_rel(a) V_DISPATCH(INT, inc, mo_rel, a)
/**
 * @def vatomic_inc_rlx(a)
 * @brief Dispatches inc calls with relaxed memory order.
 *
 * See @ref vatomic32_inc_rlx for details.
 *
 * @param a atomic variable
 * @memord relaxed
 */
#define vatomic_inc_rlx(a) V_DISPATCH(INT, inc, mo_rlx, a)
/**
 * @def vatomic_dec(a)
 * @brief Dispatches dec calls with seq_cst memory order.
 *
 * See @ref vatomic32_dec for details.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
#define vatomic_dec(a) V_DISPATCH(INT, dec, mo_seq, a)
/**
 * @def vatomic_dec_rel(a)
 * @brief Dispatches dec calls with release memory order.
 *
 * See @ref vatomic32_dec_rel for details.
 *
 * @param a atomic variable
 * @memord release
 */
#define vatomic_dec_rel(a) V_DISPATCH(INT, dec, mo_rel, a)
/**
 * @def vatomic_dec_rlx(a)
 * @brief Dispatches dec calls with relaxed memory order.
 *
 * See @ref vatomic32_dec_rlx for details.
 *
 * @param a atomic variable
 * @memord relaxed
 */
#define vatomic_dec_rlx(a) V_DISPATCH(INT, dec, mo_rlx, a)

/**
 * @def vatomic_inc_get(a)
 * @brief Dispatches inc_get calls with seq_cst memory order.
 *
 * See vatomic32_inc_get for details.
 *
 * @param a atomic variable
 * @return new value
 * @memord seq_cst
 */
#define vatomic_inc_get(a) V_DISPATCH(INT_RET, inc_get, mo_seq, a)
/**
 * @def vatomic_inc_get_acq(a)
 * @brief Dispatches inc_get calls with acquire memory order.
 *
 * See vatomic32_inc_get_acq for details.
 *
 * @param a atomic variable
 * @return new value
 * @memord acquire
 */
#define vatomic_inc_get_acq(a) V_DISPATCH(INT_RET, inc_get, mo_acq, a)
/**
 * @def vatomic_inc_get_rel(a)
 * @brief Dispatches inc_get calls with release memory order.
 *
 * See vatomic32_inc_get_rel for details.
 *
 * @param a atomic variable
 * @return new value
 * @memord release
 */
#define vatomic_inc_get_rel(a) V_DISPATCH(INT_RET, inc_get, mo_rel, a)
/**
 * @def vatomic_inc_get_rlx(a)
 * @brief Dispatches inc_get calls with relaxed memory order.
 *
 * See vatomic32_inc_get_rlx for details.
 *
 * @param a atomic variable
 * @return new value
 * @memord relaxed
 */
#define vatomic_inc_get_rlx(a) V_DISPATCH(INT_RET, inc_get, mo_rlx, a)
/**
 * @def vatomic_dec_get(a)
 * @brief Dispatches dec_get calls with seq_cst memory order.
 *
 * See vatomic32_dec_get for details.
 *
 * @param a atomic variable
 * @return new value
 * @memord seq_cst
 */
#define vatomic_dec_get(a) V_DISPATCH(INT_RET, dec_get, mo_seq, a)
/**
 * @def vatomic_dec_get_acq(a)
 * @brief Dispatches dec_get calls with acquire memory order.
 *
 * See vatomic32_dec_get_acq for details.
 *
 * @param a atomic variable
 * @return new value
 * @memord acquire
 */
#define vatomic_dec_get_acq(a) V_DISPATCH(INT_RET, dec_get, mo_acq, a)
/**
 * @def vatomic_dec_get_rel(a)
 * @brief Dispatches dec_get calls with release memory order.
 *
 * See vatomic32_dec_get_rel for details.
 *
 * @param a atomic variable
 * @return new value
 * @memord release
 */
#define vatomic_dec_get_rel(a) V_DISPATCH(INT_RET, dec_get, mo_rel, a)
/**
 * @def vatomic_dec_get_rlx(a)
 * @brief Dispatches dec_get calls with relaxed memory order.
 *
 * See vatomic32_dec_get_rlx for details.
 *
 * @param a atomic variable
 * @return new value
 * @memord relaxed
 */
#define vatomic_dec_get_rlx(a) V_DISPATCH(INT_RET, dec_get, mo_rlx, a)

/**
 * @def vatomic_get_inc(a)
 * @brief Dispatches get_inc calls with seq_cst memory order.
 *
 * See vatomic32_get_inc for details.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
#define vatomic_get_inc(a) V_DISPATCH(INT_RET, get_inc, mo_seq, a)
/**
 * @def vatomic_get_inc_acq(a)
 * @brief Dispatches get_inc calls with acquire memory order.
 *
 * See vatomic32_get_inc_acq for details.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
#define vatomic_get_inc_acq(a) V_DISPATCH(INT_RET, get_inc, mo_acq, a)
/**
 * @def vatomic_get_inc_rel(a)
 * @brief Dispatches get_inc calls with release memory order.
 *
 * See vatomic32_get_inc_rel for details.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
#define vatomic_get_inc_rel(a) V_DISPATCH(INT_RET, get_inc, mo_rel, a)
/**
 * @def vatomic_get_inc_rlx(a)
 * @brief Dispatches get_inc calls with relaxed memory order.
 *
 * See vatomic32_get_inc_rlx for details.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
#define vatomic_get_inc_rlx(a) V_DISPATCH(INT_RET, get_inc, mo_rlx, a)
/**
 * @def vatomic_get_dec(a)
 * @brief Dispatches get_dec calls with seq_cst memory order.
 *
 * See vatomic32_get_dec for details.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
#define vatomic_get_dec(a) V_DISPATCH(INT_RET, get_dec, mo_seq, a)
/**
 * @def vatomic_get_dec_acq(a)
 * @brief Dispatches get_dec calls with acquire memory order.
 *
 * See vatomic32_get_dec_acq for details.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
#define vatomic_get_dec_acq(a) V_DISPATCH(INT_RET, get_dec, mo_acq, a)
/**
 * @def vatomic_get_dec_rel(a)
 * @brief Dispatches get_dec calls with release memory order.
 *
 * See vatomic32_get_dec_rel for details.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
#define vatomic_get_dec_rel(a) V_DISPATCH(INT_RET, get_dec, mo_rel, a)
/**
 * @def vatomic_get_dec_rlx(a)
 * @brief Dispatches get_dec calls with relaxed memory order.
 *
 * See vatomic32_get_dec_rlx for details.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
#define vatomic_get_dec_rlx(a) V_DISPATCH(INT_RET, get_dec, mo_rlx, a)

/* *****************************************************************************
 * RMW with 2 argument
 * ****************************************************************************/

/**
 * @def vatomic_add(a, v)
 * @brief Dispatches add calls with seq_cst memory order.
 *
 * See @ref vatomic32_add for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord seq_cst
 */
#define vatomic_add(a, v) V_DISPATCH(INT, add, mo_seq, a, v)
/**
 * @def vatomic_add_rel(a, v)
 * @brief Dispatches add calls with release memory order.
 *
 * See @ref vatomic32_add_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord release
 */
#define vatomic_add_rel(a, v) V_DISPATCH(INT, add, mo_rel, a, v)
/**
 * @def vatomic_add_rlx(a, v)
 * @brief Dispatches add calls with relaxed memory order.
 *
 * See @ref vatomic32_add_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord relaxed
 */
#define vatomic_add_rlx(a, v) V_DISPATCH(INT, add, mo_rlx, a, v)
/**
 * @def vatomic_sub(a, v)
 * @brief Dispatches sub calls with seq_cst memory order.
 *
 * See @ref vatomic32_sub for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord seq_cst
 */
#define vatomic_sub(a, v) V_DISPATCH(INT, sub, mo_seq, a, v)
/**
 * @def vatomic_sub_rel(a, v)
 * @brief Dispatches sub calls with release memory order.
 *
 * See @ref vatomic32_sub_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord release
 */
#define vatomic_sub_rel(a, v) V_DISPATCH(INT, sub, mo_rel, a, v)
/**
 * @def vatomic_sub_rlx(a, v)
 * @brief Dispatches sub calls with relaxed memory order.
 *
 * See @ref vatomic32_sub_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord relaxed
 */
#define vatomic_sub_rlx(a, v) V_DISPATCH(INT, sub, mo_rlx, a, v)
/**
 * @def vatomic_and(a, v)
 * @brief Dispatches and calls with seq_cst memory order.
 *
 * See @ref vatomic32_and for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord seq_cst
 */
#define vatomic_and(a, v) V_DISPATCH(INT, and, mo_seq, a, v)
/**
 * @def vatomic_and_rel(a, v)
 * @brief Dispatches and calls with release memory order.
 *
 * See @ref vatomic32_and_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord release
 */
#define vatomic_and_rel(a, v) V_DISPATCH(INT, and, mo_rel, a, v)
/**
 * @def vatomic_and_rlx(a, v)
 * @brief Dispatches and calls with relaxed memory order.
 *
 * See @ref vatomic32_and_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord relaxed
 */
#define vatomic_and_rlx(a, v) V_DISPATCH(INT, and, mo_rlx, a, v)
/**
 * @def vatomic_xor(a, v)
 * @brief Dispatches xor calls with seq_cst memory order.
 *
 * See @ref vatomic32_xor for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord seq_cst
 */
#define vatomic_xor(a, v) V_DISPATCH(INT, xor, mo_seq, a, v)
/**
 * @def vatomic_xor_rel(a, v)
 * @brief Dispatches xor calls with release memory order.
 *
 * See @ref vatomic32_xor_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord release
 */
#define vatomic_xor_rel(a, v) V_DISPATCH(INT, xor, mo_rel, a, v)
/**
 * @def vatomic_xor_rlx(a, v)
 * @brief Dispatches xor calls with relaxed memory order.
 *
 * See @ref vatomic32_xor_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord relaxed
 */
#define vatomic_xor_rlx(a, v) V_DISPATCH(INT, xor, mo_rlx, a, v)
/**
 * @def vatomic_or(a, v)
 * @brief Dispatches or calls with seq_cst memory order.
 *
 * See @ref vatomic32_or for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord seq_cst
 */
#define vatomic_or(a, v) V_DISPATCH(INT, or, mo_seq, a, v)
/**
 * @def vatomic_or_rel(a, v)
 * @brief Dispatches or calls with release memory order.
 *
 * See @ref vatomic32_or_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord release
 */
#define vatomic_or_rel(a, v) V_DISPATCH(INT, or, mo_rel, a, v)
/**
 * @def vatomic_or_rlx(a, v)
 * @brief Dispatches or calls with relaxed memory order.
 *
 * See @ref vatomic32_or_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord relaxed
 */
#define vatomic_or_rlx(a, v) V_DISPATCH(INT, or, mo_rlx, a, v)
/**
 * @def vatomic_max(a, v)
 * @brief Dispatches max calls with seq_cst memory order.
 *
 * See @ref vatomic32_max for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord seq_cst
 */
#define vatomic_max(a, v) V_DISPATCH(INT, max, mo_seq, a, v)
/**
 * @def vatomic_max_rel(a, v)
 * @brief Dispatches max calls with release memory order.
 *
 * See @ref vatomic32_max_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord release
 */
#define vatomic_max_rel(a, v) V_DISPATCH(INT, max, mo_rel, a, v)
/**
 * @def vatomic_max_rlx(a, v)
 * @brief Dispatches max calls with relaxed memory order.
 *
 * See @ref vatomic32_max_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @memord relaxed
 */
#define vatomic_max_rlx(a, v) V_DISPATCH(INT, max, mo_rlx, a, v)

/**
 * @def vatomic_add_get(a, v)
 * @brief Dispatches add_get calls with seq_cst memory order.
 *
 * See @ref vatomic32_add_get for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord seq_cst
 */
#define vatomic_add_get(a, v) V_DISPATCH(INT_RET, add_get, mo_seq, a, v)
/**
 * @def vatomic_add_get_acq(a, v)
 * @brief Dispatches add_get calls with acquire memory order.
 *
 * See @ref vatomic32_add_get_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord acquire
 */
#define vatomic_add_get_acq(a, v) V_DISPATCH(INT_RET, add_get, mo_acq, a, v)
/**
 * @def vatomic_add_get_rel(a, v)
 * @brief Dispatches add_get calls with release memory order.
 *
 * See @ref vatomic32_add_get_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord release
 */
#define vatomic_add_get_rel(a, v) V_DISPATCH(INT_RET, add_get, mo_rel, a, v)
/**
 * @def vatomic_add_get_rlx(a, v)
 * @brief Dispatches add_get calls with relaxed memory order.
 *
 * See @ref vatomic32_add_get_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord relaxed
 */
#define vatomic_add_get_rlx(a, v) V_DISPATCH(INT_RET, add_get, mo_rlx, a, v)
/**
 * @def vatomic_sub_get(a, v)
 * @brief Dispatches sub_get calls with seq_cst memory order.
 *
 * See @ref vatomic32_sub_get for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord seq_cst
 */
#define vatomic_sub_get(a, v) V_DISPATCH(INT_RET, sub_get, mo_seq, a, v)
/**
 * @def vatomic_sub_get_acq(a, v)
 * @brief Dispatches sub_get calls with acquire memory order.
 *
 * See @ref vatomic32_sub_get_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord acquire
 */
#define vatomic_sub_get_acq(a, v) V_DISPATCH(INT_RET, sub_get, mo_acq, a, v)
/**
 * @def vatomic_sub_get_rel(a, v)
 * @brief Dispatches sub_get calls with release memory order.
 *
 * See @ref vatomic32_sub_get_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord release
 */
#define vatomic_sub_get_rel(a, v) V_DISPATCH(INT_RET, sub_get, mo_rel, a, v)
/**
 * @def vatomic_sub_get_rlx(a, v)
 * @brief Dispatches sub_get calls with relaxed memory order.
 *
 * See @ref vatomic32_sub_get_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord relaxed
 */
#define vatomic_sub_get_rlx(a, v) V_DISPATCH(INT_RET, sub_get, mo_rlx, a, v)
/**
 * @def vatomic_and_get(a, v)
 * @brief Dispatches and_get calls with seq_cst memory order.
 *
 * See @ref vatomic32_and_get for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord seq_cst
 */
#define vatomic_and_get(a, v) V_DISPATCH(INT_RET, and_get, mo_seq, a, v)
/**
 * @def vatomic_and_get_acq(a, v)
 * @brief Dispatches and_get calls with acquire memory order.
 *
 * See @ref vatomic32_and_get_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord acquire
 */
#define vatomic_and_get_acq(a, v) V_DISPATCH(INT_RET, and_get, mo_acq, a, v)
/**
 * @def vatomic_and_get_rel(a, v)
 * @brief Dispatches and_get calls with release memory order.
 *
 * See @ref vatomic32_and_get_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord release
 */
#define vatomic_and_get_rel(a, v) V_DISPATCH(INT_RET, and_get, mo_rel, a, v)
/**
 * @def vatomic_and_get_rlx(a, v)
 * @brief Dispatches and_get calls with relaxed memory order.
 *
 * See @ref vatomic32_and_get_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord relaxed
 */
#define vatomic_and_get_rlx(a, v) V_DISPATCH(INT_RET, and_get, mo_rlx, a, v)
/**
 * @def vatomic_xor_get(a, v)
 * @brief Dispatches xor_get calls with seq_cst memory order.
 *
 * See @ref vatomic32_xor_get for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord seq_cst
 */
#define vatomic_xor_get(a, v) V_DISPATCH(INT_RET, xor_get, mo_seq, a, v)
/**
 * @def vatomic_xor_get_acq(a, v)
 * @brief Dispatches xor_get calls with acquire memory order.
 *
 * See @ref vatomic32_xor_get_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord acquire
 */
#define vatomic_xor_get_acq(a, v) V_DISPATCH(INT_RET, xor_get, mo_acq, a, v)
/**
 * @def vatomic_xor_get_rel(a, v)
 * @brief Dispatches xor_get calls with release memory order.
 *
 * See @ref vatomic32_xor_get_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord release
 */
#define vatomic_xor_get_rel(a, v) V_DISPATCH(INT_RET, xor_get, mo_rel, a, v)
/**
 * @def vatomic_xor_get_rlx(a, v)
 * @brief Dispatches xor_get calls with relaxed memory order.
 *
 * See @ref vatomic32_xor_get_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord relaxed
 */
#define vatomic_xor_get_rlx(a, v) V_DISPATCH(INT_RET, xor_get, mo_rlx, a, v)
/**
 * @def vatomic_or_get(a, v)
 * @brief Dispatches or_get calls with seq_cst memory order.
 *
 * See @ref vatomic32_or_get for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord seq_cst
 */
#define vatomic_or_get(a, v) V_DISPATCH(INT_RET, or_get, mo_seq, a, v)
/**
 * @def vatomic_or_get_acq(a, v)
 * @brief Dispatches or_get calls with acquire memory order.
 *
 * See @ref vatomic32_or_get_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord acquire
 */
#define vatomic_or_get_acq(a, v) V_DISPATCH(INT_RET, or_get, mo_acq, a, v)
/**
 * @def vatomic_or_get_rel(a, v)
 * @brief Dispatches or_get calls with release memory order.
 *
 * See @ref vatomic32_or_get_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord release
 */
#define vatomic_or_get_rel(a, v) V_DISPATCH(INT_RET, or_get, mo_rel, a, v)
/**
 * @def vatomic_or_get_rlx(a, v)
 * @brief Dispatches or_get calls with relaxed memory order.
 *
 * See @ref vatomic32_or_get_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord relaxed
 */
#define vatomic_or_get_rlx(a, v) V_DISPATCH(INT_RET, or_get, mo_rlx, a, v)
/**
 * @def vatomic_max_get(a, v)
 * @brief Dispatches max_get calls with seq_cst memory order.
 *
 * See @ref vatomic32_max_get for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord seq_cst
 */
#define vatomic_max_get(a, v) V_DISPATCH(INT_RET, max_get, mo_seq, a, v)
/**
 * @def vatomic_max_get_acq(a, v)
 * @brief Dispatches max_get calls with acquire memory order.
 *
 * See @ref vatomic32_max_get_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord acquire
 */
#define vatomic_max_get_acq(a, v) V_DISPATCH(INT_RET, max_get, mo_acq, a, v)
/**
 * @def vatomic_max_get_rel(a, v)
 * @brief Dispatches max_get calls with release memory order.
 *
 * See @ref vatomic32_max_get_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord release
 */
#define vatomic_max_get_rel(a, v) V_DISPATCH(INT_RET, max_get, mo_rel, a, v)
/**
 * @def vatomic_max_get_rlx(a, v)
 * @brief Dispatches max_get calls with relaxed memory order.
 *
 * See @ref vatomic32_max_get_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return new value
 * @memord relaxed
 */
#define vatomic_max_get_rlx(a, v) V_DISPATCH(INT_RET, max_get, mo_rlx, a, v)

/**
 * @def vatomic_get_add(a, v, mo)
 * @brief Dispatches get_add calls with seq_cst memory order.
 *
 * See @ref vatomic32_get_add for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord seq_cst
 */
#define vatomic_get_add(a, v) V_DISPATCH(INT_RET, get_add, mo_seq, a, v)
/**
 * @def vatomic_get_add(a, v, mo)
 * @brief Dispatches get_add calls with acquire memory order.
 *
 * See @ref vatomic32_get_add_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord acquire
 */
#define vatomic_get_add_acq(a, v) V_DISPATCH(INT_RET, get_add, mo_acq, a, v)
/**
 * @def vatomic_get_add(a, v, mo)
 * @brief Dispatches get_add calls with release memory order.
 *
 * See @ref vatomic32_get_add_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord release
 */
#define vatomic_get_add_rel(a, v) V_DISPATCH(INT_RET, get_add, mo_rel, a, v)
/**
 * @def vatomic_get_add(a, v, mo)
 * @brief Dispatches get_add calls with relaxed memory order.
 *
 * See @ref vatomic32_get_add_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord relaxed
 */
#define vatomic_get_add_rlx(a, v) V_DISPATCH(INT_RET, get_add, mo_rlx, a, v)
/**
 * @def vatomic_get_sub(a, v, mo)
 * @brief Dispatches get_sub calls with seq_cst memory order.
 *
 * See @ref vatomic32_get_sub for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord seq_cst
 */
#define vatomic_get_sub(a, v) V_DISPATCH(INT_RET, get_sub, mo_seq, a, v)
/**
 * @def vatomic_get_sub(a, v, mo)
 * @brief Dispatches get_sub calls with acquire memory order.
 *
 * See @ref vatomic32_get_sub_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord acquire
 */
#define vatomic_get_sub_acq(a, v) V_DISPATCH(INT_RET, get_sub, mo_acq, a, v)
/**
 * @def vatomic_get_sub(a, v, mo)
 * @brief Dispatches get_sub calls with release memory order.
 *
 * See @ref vatomic32_get_sub_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord release
 */
#define vatomic_get_sub_rel(a, v) V_DISPATCH(INT_RET, get_sub, mo_rel, a, v)
/**
 * @def vatomic_get_sub(a, v, mo)
 * @brief Dispatches get_sub calls with relaxed memory order.
 *
 * See @ref vatomic32_get_sub_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord relaxed
 */
#define vatomic_get_sub_rlx(a, v) V_DISPATCH(INT_RET, get_sub, mo_rlx, a, v)
/**
 * @def vatomic_get_and(a, v, mo)
 * @brief Dispatches get_and calls with seq_cst memory order.
 *
 * See @ref vatomic32_get_and for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord seq_cst
 */
#define vatomic_get_and(a, v) V_DISPATCH(INT_RET, get_and, mo_seq, a, v)
/**
 * @def vatomic_get_and(a, v, mo)
 * @brief Dispatches get_and calls with acquire memory order.
 *
 * See @ref vatomic32_get_and_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord acquire
 */
#define vatomic_get_and_acq(a, v) V_DISPATCH(INT_RET, get_and, mo_acq, a, v)
/**
 * @def vatomic_get_and(a, v, mo)
 * @brief Dispatches get_and calls with release memory order.
 *
 * See @ref vatomic32_get_and_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord release
 */
#define vatomic_get_and_rel(a, v) V_DISPATCH(INT_RET, get_and, mo_rel, a, v)
/**
 * @def vatomic_get_and(a, v, mo)
 * @brief Dispatches get_and calls with relaxed memory order.
 *
 * See @ref vatomic32_get_and_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord relaxed
 */
#define vatomic_get_and_rlx(a, v) V_DISPATCH(INT_RET, get_and, mo_rlx, a, v)
/**
 * @def vatomic_get_xor(a, v, mo)
 * @brief Dispatches get_xor calls with seq_cst memory order.
 *
 * See @ref vatomic32_get_xor for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord seq_cst
 */
#define vatomic_get_xor(a, v) V_DISPATCH(INT_RET, get_xor, mo_seq, a, v)
/**
 * @def vatomic_get_xor(a, v, mo)
 * @brief Dispatches get_xor calls with acquire memory order.
 *
 * See @ref vatomic32_get_xor_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord acquire
 */
#define vatomic_get_xor_acq(a, v) V_DISPATCH(INT_RET, get_xor, mo_acq, a, v)
/**
 * @def vatomic_get_xor(a, v, mo)
 * @brief Dispatches get_xor calls with release memory order.
 *
 * See @ref vatomic32_get_xor_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord release
 */
#define vatomic_get_xor_rel(a, v) V_DISPATCH(INT_RET, get_xor, mo_rel, a, v)
/**
 * @def vatomic_get_xor(a, v, mo)
 * @brief Dispatches get_xor calls with relaxed memory order.
 *
 * See @ref vatomic32_get_xor_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord relaxed
 */
#define vatomic_get_xor_rlx(a, v) V_DISPATCH(INT_RET, get_xor, mo_rlx, a, v)
/**
 * @def vatomic_get_or(a, v, mo)
 * @brief Dispatches get_or calls with seq_cst memory order.
 *
 * See @ref vatomic32_get_or for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord seq_cst
 */
#define vatomic_get_or(a, v) V_DISPATCH(INT_RET, get_or, mo_seq, a, v)
/**
 * @def vatomic_get_or(a, v, mo)
 * @brief Dispatches get_or calls with acquire memory order.
 *
 * See @ref vatomic32_get_or_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord acquire
 */
#define vatomic_get_or_acq(a, v) V_DISPATCH(INT_RET, get_or, mo_acq, a, v)
/**
 * @def vatomic_get_or(a, v, mo)
 * @brief Dispatches get_or calls with release memory order.
 *
 * See @ref vatomic32_get_or_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord release
 */
#define vatomic_get_or_rel(a, v) V_DISPATCH(INT_RET, get_or, mo_rel, a, v)
/**
 * @def vatomic_get_or(a, v, mo)
 * @brief Dispatches get_or calls with relaxed memory order.
 *
 * See @ref vatomic32_get_or_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord relaxed
 */
#define vatomic_get_or_rlx(a, v) V_DISPATCH(INT_RET, get_or, mo_rlx, a, v)
/**
 * @def vatomic_get_max(a, v, mo)
 * @brief Dispatches get_max calls with seq_cst memory order.
 *
 * See @ref vatomic32_get_max for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord seq_cst
 */
#define vatomic_get_max(a, v) V_DISPATCH(INT_RET, get_max, mo_seq, a, v)
/**
 * @def vatomic_get_max(a, v, mo)
 * @brief Dispatches get_max calls with acquire memory order.
 *
 * See @ref vatomic32_get_max_acq for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord acquire
 */
#define vatomic_get_max_acq(a, v) V_DISPATCH(INT_RET, get_max, mo_acq, a, v)
/**
 * @def vatomic_get_max(a, v, mo)
 * @brief Dispatches get_max calls with release memory order.
 *
 * See @ref vatomic32_get_max_rel for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord release
 */
#define vatomic_get_max_rel(a, v) V_DISPATCH(INT_RET, get_max, mo_rel, a, v)
/**
 * @def vatomic_get_max(a, v, mo)
 * @brief Dispatches get_max calls with relaxed memory order.
 *
 * See @ref vatomic32_get_max_rlx for details.
 *
 * @param a atomic variable
 * @param v operand value
 * @return old value
 * @memord relaxed
 */
#define vatomic_get_max_rlx(a, v) V_DISPATCH(INT_RET, get_max, mo_rlx, a, v)

/* *****************************************************************************
 * await functions
 * ****************************************************************************/

/**
 * @def vatomic_await_eq(a, c)
 * @brief Dispatches await_eq calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_eq for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return previously read value
 * @memord seq_cst
 */
#define vatomic_await_eq(a, c) V_DISPATCH32(ALL_RET, await_eq, mo_seq, a, c)
/**
 * @def vatomic_await_eq_acq(a, c)
 * @brief Dispatches await_eq calls with acquire memory order.
 *
 * See @ref vatomic32_await_eq_acq for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return previously read value
 * @memord acquire
 */
#define vatomic_await_eq_acq(a, c) V_DISPATCH32(ALL_RET, await_eq, mo_acq, a, c)
/**
 * @def vatomic_await_eq_rlx(a, c)
 * @brief Dispatches await_eq calls with relaxed memory order.
 *
 * See @ref vatomic32_await_eq_rlx for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return previously read value
 * @memord relaxed
 */
#define vatomic_await_eq_rlx(a, c) V_DISPATCH32(ALL_RET, await_eq, mo_rlx, a, c)
/**
 * @def vatomic_await_neq(a, c)
 * @brief Dispatches await_neq calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_neq for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_neq(a, c) V_DISPATCH32(ALL_RET, await_neq, mo_seq, a, c)
/**
 * @def vatomic_await_neq_acq(a, c)
 * @brief Dispatches await_neq calls with acquire memory order.
 *
 * See @ref vatomic32_await_neq_acq for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_neq_acq(a, c)                                            \
    V_DISPATCH32(ALL_RET, await_neq, mo_acq, a, c)
/**
 * @def vatomic_await_neq_rlx(a, c)
 * @brief Dispatches await_neq calls with relaxed memory order.
 *
 * See @ref vatomic32_await_neq_rlx for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_neq_rlx(a, c)                                            \
    V_DISPATCH32(ALL_RET, await_neq, mo_rlx, a, c)
/**
 * @def vatomic_await_le(a, c)
 * @brief Dispatches await_le calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_le for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_le(a, c) V_DISPATCH32(INT_RET, await_le, mo_seq, a, c)
/**
 * @def vatomic_await_le_acq(a, c)
 * @brief Dispatches await_le calls with acquire memory order.
 *
 * See @ref vatomic32_await_le_acq for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_le_acq(a, c) V_DISPATCH32(INT_RET, await_le, mo_acq, a, c)
/**
 * @def vatomic_await_le_rlx(a, c)
 * @brief Dispatches await_le calls with relaxed memory order.
 *
 * See @ref vatomic32_await_le_rlx for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_le_rlx(a, c) V_DISPATCH32(INT_RET, await_le, mo_rlx, a, c)
/**
 * @def vatomic_await_lt(a, c)
 * @brief Dispatches await_lt calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_lt for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_lt(a, c) V_DISPATCH32(INT_RET, await_lt, mo_seq, a, c)
/**
 * @def vatomic_await_lt_acq(a, c)
 * @brief Dispatches await_lt calls with acquire memory order.
 *
 * See @ref vatomic32_await_lt_acq for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_lt_acq(a, c) V_DISPATCH32(INT_RET, await_lt, mo_acq, a, c)
/**
 * @def vatomic_await_lt_rlx(a, c)
 * @brief Dispatches await_lt calls with relaxed memory order.
 *
 * See @ref vatomic32_await_lt_rlx for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_lt_rlx(a, c) V_DISPATCH32(INT_RET, await_lt, mo_rlx, a, c)
/**
 * @def vatomic_await_gt(a, c)
 * @brief Dispatches await_gt calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_gt for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_gt(a, c) V_DISPATCH32(INT_RET, await_gt, mo_seq, a, c)
/**
 * @def vatomic_await_gt_acq(a, c)
 * @brief Dispatches await_gt calls with acquire memory order.
 *
 * See @ref vatomic32_await_gt_acq for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_gt_acq(a, c) V_DISPATCH32(INT_RET, await_gt, mo_acq, a, c)
/**
 * @def vatomic_await_gt_rlx(a, c)
 * @brief Dispatches await_gt calls with relaxed memory order.
 *
 * See @ref vatomic32_await_gt_rlx for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_gt_rlx(a, c) V_DISPATCH32(INT_RET, await_gt, mo_rlx, a, c)
/**
 * @def vatomic_await_ge(a, c)
 * @brief Dispatches await_ge calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_ge for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_ge(a, c) V_DISPATCH32(INT_RET, await_ge, mo_seq, a, c)
/**
 * @def vatomic_await_ge_acq(a, c)
 * @brief Dispatches await_ge calls with acquire memory order.
 *
 * See @ref vatomic32_await_ge_acq for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_ge_acq(a, c) V_DISPATCH32(INT_RET, await_ge, mo_acq, a, c)
/**
 * @def vatomic_await_ge_rlx(a, c)
 * @brief Dispatches await_ge calls with relaxed memory order.
 *
 * See @ref vatomic32_await_ge_rlx for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_ge_rlx(a, c) V_DISPATCH32(INT_RET, await_ge, mo_rlx, a, c)

/**
 * @def vatomic_await_eq_set(a, c, v)
 * @brief Dispatches await_eq_set calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_eq_set_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord seq_cst
 */
#define vatomic_await_eq_set(a, c, v)                                          \
    V_DISPATCH32(ALL_RET, await_eq_set, mo_seq, a, c, v)
/**
 * @def vatomic_await_eq_set_acq(a, c, v)
 * @brief Dispatches await_eq_set calls with acquire memory order.
 *
 * See @ref vatomic32_await_eq_set_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord acquire
 */
#define vatomic_await_eq_set_acq(a, c, v)                                      \
    V_DISPATCH32(ALL_RET, await_eq_set, mo_acq, a, c, v)
/**
 * @def vatomic_await_eq_set_rel(a, c, v)
 * @brief Dispatches await_eq_set calls with release memory order.
 *
 * See @ref vatomic32_await_eq_set_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord release
 */
#define vatomic_await_eq_set_rel(a, c, v)                                      \
    V_DISPATCH32(ALL_RET, await_eq_set, mo_rel, a, c, v)
/**
 * @def vatomic_await_eq_set_rlx(a, c, v)
 * @brief Dispatches await_eq_set calls with relaxed memory order.
 *
 * See @ref vatomic32_await_eq_set_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord relaxed
 */
#define vatomic_await_eq_set_rlx(a, c, v)                                      \
    V_DISPATCH32(ALL_RET, await_eq_set, mo_rlx, a, c, v)
/**
 * @def vatomic_await_eq_sub(a, c, v)
 * @brief Dispatches await_eq_sub calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_eq_sub_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord seq_cst
 */
#define vatomic_await_eq_sub(a, c, v)                                          \
    V_DISPATCH32(ALL_RET, await_eq_sub, mo_seq, a, c, v)
/**
 * @def vatomic_await_eq_sub_acq(a, c, v)
 * @brief Dispatches await_eq_sub calls with acquire memory order.
 *
 * See @ref vatomic32_await_eq_sub_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord acquire
 */
#define vatomic_await_eq_sub_acq(a, c, v)                                      \
    V_DISPATCH32(ALL_RET, await_eq_sub, mo_acq, a, c, v)
/**
 * @def vatomic_await_eq_sub_rel(a, c, v)
 * @brief Dispatches await_eq_sub calls with release memory order.
 *
 * See @ref vatomic32_await_eq_sub_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord release
 */
#define vatomic_await_eq_sub_rel(a, c, v)                                      \
    V_DISPATCH32(ALL_RET, await_eq_sub, mo_rel, a, c, v)
/**
 * @def vatomic_await_eq_sub_rlx(a, c, v)
 * @brief Dispatches await_eq_sub calls with relaxed memory order.
 *
 * See @ref vatomic32_await_eq_sub_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord relaxed
 */
#define vatomic_await_eq_sub_rlx(a, c, v)                                      \
    V_DISPATCH32(ALL_RET, await_eq_sub, mo_rlx, a, c, v)
/**
 * @def vatomic_await_eq_add(a, c, v)
 * @brief Dispatches await_eq_add calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_eq_add_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord seq_cst
 */
#define vatomic_await_eq_add(a, c, v)                                          \
    V_DISPATCH32(ALL_RET, await_eq_add, mo_seq, a, c, v)
/**
 * @def vatomic_await_eq_add_acq(a, c, v)
 * @brief Dispatches await_eq_add calls with acquire memory order.
 *
 * See @ref vatomic32_await_eq_add_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord acquire
 */
#define vatomic_await_eq_add_acq(a, c, v)                                      \
    V_DISPATCH32(ALL_RET, await_eq_add, mo_acq, a, c, v)
/**
 * @def vatomic_await_eq_add_rel(a, c, v)
 * @brief Dispatches await_eq_add calls with release memory order.
 *
 * See @ref vatomic32_await_eq_add_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord release
 */
#define vatomic_await_eq_add_rel(a, c, v)                                      \
    V_DISPATCH32(ALL_RET, await_eq_add, mo_rel, a, c, v)
/**
 * @def vatomic_await_eq_add_rlx(a, c, v)
 * @brief Dispatches await_eq_add calls with relaxed memory order.
 *
 * See @ref vatomic32_await_eq_add_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return previously read value
 * @memord relaxed
 */
#define vatomic_await_eq_add_rlx(a, c, v)                                      \
    V_DISPATCH32(ALL_RET, await_eq_add, mo_rlx, a, c, v)
/**
 * @def vatomic_await_neq_set(a, c, v)
 * @brief Dispatches await_neq_set calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_neq_set_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_neq_set(a, c, v)                                         \
    V_DISPATCH32(ALL_RET, await_neq_set, mo_seq, a, c, v)
/**
 * @def vatomic_await_neq_set_acq(a, c, v)
 * @brief Dispatches await_neq_set calls with acquire memory order.
 *
 * See @ref vatomic32_await_neq_set_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_neq_set_acq(a, c, v)                                     \
    V_DISPATCH32(ALL_RET, await_neq_set, mo_acq, a, c, v)
/**
 * @def vatomic_await_neq_set_rel(a, c, v)
 * @brief Dispatches await_neq_set calls with release memory order.
 *
 * See @ref vatomic32_await_neq_set_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_neq_set_rel(a, c, v)                                     \
    V_DISPATCH32(ALL_RET, await_neq_set, mo_rel, a, c, v)
/**
 * @def vatomic_await_neq_set_rlx(a, c, v)
 * @brief Dispatches await_neq_set calls with relaxed memory order.
 *
 * See @ref vatomic32_await_neq_set_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_neq_set_rlx(a, c, v)                                     \
    V_DISPATCH32(ALL_RET, await_neq_set, mo_rlx, a, c, v)
/**
 * @def vatomic_await_neq_sub(a, c, v)
 * @brief Dispatches await_neq_sub calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_neq_sub_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_neq_sub(a, c, v)                                         \
    V_DISPATCH32(ALL_RET, await_neq_sub, mo_seq, a, c, v)
/**
 * @def vatomic_await_neq_sub_acq(a, c, v)
 * @brief Dispatches await_neq_sub calls with acquire memory order.
 *
 * See @ref vatomic32_await_neq_sub_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_neq_sub_acq(a, c, v)                                     \
    V_DISPATCH32(ALL_RET, await_neq_sub, mo_acq, a, c, v)
/**
 * @def vatomic_await_neq_sub_rel(a, c, v)
 * @brief Dispatches await_neq_sub calls with release memory order.
 *
 * See @ref vatomic32_await_neq_sub_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_neq_sub_rel(a, c, v)                                     \
    V_DISPATCH32(ALL_RET, await_neq_sub, mo_rel, a, c, v)
/**
 * @def vatomic_await_neq_sub_rlx(a, c, v)
 * @brief Dispatches await_neq_sub calls with relaxed memory order.
 *
 * See @ref vatomic32_await_neq_sub_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_neq_sub_rlx(a, c, v)                                     \
    V_DISPATCH32(ALL_RET, await_neq_sub, mo_rlx, a, c, v)
/**
 * @def vatomic_await_neq_add(a, c, v)
 * @brief Dispatches await_neq_add calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_neq_add_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_neq_add(a, c, v)                                         \
    V_DISPATCH32(ALL_RET, await_neq_add, mo_seq, a, c, v)
/**
 * @def vatomic_await_neq_add_acq(a, c, v)
 * @brief Dispatches await_neq_add calls with acquire memory order.
 *
 * See @ref vatomic32_await_neq_add_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_neq_add_acq(a, c, v)                                     \
    V_DISPATCH32(ALL_RET, await_neq_add, mo_acq, a, c, v)
/**
 * @def vatomic_await_neq_add_rel(a, c, v)
 * @brief Dispatches await_neq_add calls with release memory order.
 *
 * See @ref vatomic32_await_neq_add_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_neq_add_rel(a, c, v)                                     \
    V_DISPATCH32(ALL_RET, await_neq_add, mo_rel, a, c, v)
/**
 * @def vatomic_await_neq_add_rlx(a, c, v)
 * @brief Dispatches await_neq_add calls with relaxed memory order.
 *
 * See @ref vatomic32_await_neq_add_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_neq_add_rlx(a, c, v)                                     \
    V_DISPATCH32(ALL_RET, await_neq_add, mo_rlx, a, c, v)
/**
 * @def vatomic_await_le_set(a, c, v)
 * @brief Dispatches await_le_set calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_le_set_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_le_set(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_le_set, mo_seq, a, c, v)
/**
 * @def vatomic_await_le_set_acq(a, c, v)
 * @brief Dispatches await_le_set calls with acquire memory order.
 *
 * See @ref vatomic32_await_le_set_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_le_set_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_le_set, mo_acq, a, c, v)
/**
 * @def vatomic_await_le_set_rel(a, c, v)
 * @brief Dispatches await_le_set calls with release memory order.
 *
 * See @ref vatomic32_await_le_set_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_le_set_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_le_set, mo_rel, a, c, v)
/**
 * @def vatomic_await_le_set_rlx(a, c, v)
 * @brief Dispatches await_le_set calls with relaxed memory order.
 *
 * See @ref vatomic32_await_le_set_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_le_set_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_le_set, mo_rlx, a, c, v)
/**
 * @def vatomic_await_le_sub(a, c, v)
 * @brief Dispatches await_le_sub calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_le_sub_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_le_sub(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_le_sub, mo_seq, a, c, v)
/**
 * @def vatomic_await_le_sub_acq(a, c, v)
 * @brief Dispatches await_le_sub calls with acquire memory order.
 *
 * See @ref vatomic32_await_le_sub_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_le_sub_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_le_sub, mo_acq, a, c, v)
/**
 * @def vatomic_await_le_sub_rel(a, c, v)
 * @brief Dispatches await_le_sub calls with release memory order.
 *
 * See @ref vatomic32_await_le_sub_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_le_sub_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_le_sub, mo_rel, a, c, v)
/**
 * @def vatomic_await_le_sub_rlx(a, c, v)
 * @brief Dispatches await_le_sub calls with relaxed memory order.
 *
 * See @ref vatomic32_await_le_sub_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_le_sub_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_le_sub, mo_rlx, a, c, v)
/**
 * @def vatomic_await_le_add(a, c, v)
 * @brief Dispatches await_le_add calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_le_add_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_le_add(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_le_add, mo_seq, a, c, v)
/**
 * @def vatomic_await_le_add_acq(a, c, v)
 * @brief Dispatches await_le_add calls with acquire memory order.
 *
 * See @ref vatomic32_await_le_add_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_le_add_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_le_add, mo_acq, a, c, v)
/**
 * @def vatomic_await_le_add_rel(a, c, v)
 * @brief Dispatches await_le_add calls with release memory order.
 *
 * See @ref vatomic32_await_le_add_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_le_add_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_le_add, mo_rel, a, c, v)
/**
 * @def vatomic_await_le_add_rlx(a, c, v)
 * @brief Dispatches await_le_add calls with relaxed memory order.
 *
 * See @ref vatomic32_await_le_add_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_le_add_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_le_add, mo_rlx, a, c, v)
/**
 * @def vatomic_await_lt_set(a, c, v)
 * @brief Dispatches await_lt_set calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_lt_set_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_lt_set(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_lt_set, mo_seq, a, c, v)
/**
 * @def vatomic_await_lt_set_acq(a, c, v)
 * @brief Dispatches await_lt_set calls with acquire memory order.
 *
 * See @ref vatomic32_await_lt_set_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_lt_set_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_lt_set, mo_acq, a, c, v)
/**
 * @def vatomic_await_lt_set_rel(a, c, v)
 * @brief Dispatches await_lt_set calls with release memory order.
 *
 * See @ref vatomic32_await_lt_set_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_lt_set_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_lt_set, mo_rel, a, c, v)
/**
 * @def vatomic_await_lt_set_rlx(a, c, v)
 * @brief Dispatches await_lt_set calls with relaxed memory order.
 *
 * See @ref vatomic32_await_lt_set_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_lt_set_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_lt_set, mo_rlx, a, c, v)
/**
 * @def vatomic_await_lt_sub(a, c, v)
 * @brief Dispatches await_lt_sub calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_lt_sub_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_lt_sub(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_lt_sub, mo_seq, a, c, v)
/**
 * @def vatomic_await_lt_sub_acq(a, c, v)
 * @brief Dispatches await_lt_sub calls with acquire memory order.
 *
 * See @ref vatomic32_await_lt_sub_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_lt_sub_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_lt_sub, mo_acq, a, c, v)
/**
 * @def vatomic_await_lt_sub_rel(a, c, v)
 * @brief Dispatches await_lt_sub calls with release memory order.
 *
 * See @ref vatomic32_await_lt_sub_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_lt_sub_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_lt_sub, mo_rel, a, c, v)
/**
 * @def vatomic_await_lt_sub_rlx(a, c, v)
 * @brief Dispatches await_lt_sub calls with relaxed memory order.
 *
 * See @ref vatomic32_await_lt_sub_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_lt_sub_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_lt_sub, mo_rlx, a, c, v)
/**
 * @def vatomic_await_lt_add(a, c, v)
 * @brief Dispatches await_lt_add calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_lt_add_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_lt_add(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_lt_add, mo_seq, a, c, v)
/**
 * @def vatomic_await_lt_add_acq(a, c, v)
 * @brief Dispatches await_lt_add calls with acquire memory order.
 *
 * See @ref vatomic32_await_lt_add_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_lt_add_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_lt_add, mo_acq, a, c, v)
/**
 * @def vatomic_await_lt_add_rel(a, c, v)
 * @brief Dispatches await_lt_add calls with release memory order.
 *
 * See @ref vatomic32_await_lt_add_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_lt_add_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_lt_add, mo_rel, a, c, v)
/**
 * @def vatomic_await_lt_add_rlx(a, c, v)
 * @brief Dispatches await_lt_add calls with relaxed memory order.
 *
 * See @ref vatomic32_await_lt_add_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_lt_add_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_lt_add, mo_rlx, a, c, v)
/**
 * @def vatomic_await_gt_set(a, c, v)
 * @brief Dispatches await_gt_set calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_gt_set_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_gt_set(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_gt_set, mo_seq, a, c, v)
/**
 * @def vatomic_await_gt_set_acq(a, c, v)
 * @brief Dispatches await_gt_set calls with acquire memory order.
 *
 * See @ref vatomic32_await_gt_set_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_gt_set_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_gt_set, mo_acq, a, c, v)
/**
 * @def vatomic_await_gt_set_rel(a, c, v)
 * @brief Dispatches await_gt_set calls with release memory order.
 *
 * See @ref vatomic32_await_gt_set_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_gt_set_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_gt_set, mo_rel, a, c, v)
/**
 * @def vatomic_await_gt_set_rlx(a, c, v)
 * @brief Dispatches await_gt_set calls with relaxed memory order.
 *
 * See @ref vatomic32_await_gt_set_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_gt_set_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_gt_set, mo_rlx, a, c, v)
/**
 * @def vatomic_await_gt_sub(a, c, v)
 * @brief Dispatches await_gt_sub calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_gt_sub_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_gt_sub(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_gt_sub, mo_seq, a, c, v)
/**
 * @def vatomic_await_gt_sub_acq(a, c, v)
 * @brief Dispatches await_gt_sub calls with acquire memory order.
 *
 * See @ref vatomic32_await_gt_sub_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_gt_sub_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_gt_sub, mo_acq, a, c, v)
/**
 * @def vatomic_await_gt_sub_rel(a, c, v)
 * @brief Dispatches await_gt_sub calls with release memory order.
 *
 * See @ref vatomic32_await_gt_sub_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_gt_sub_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_gt_sub, mo_rel, a, c, v)
/**
 * @def vatomic_await_gt_sub_rlx(a, c, v)
 * @brief Dispatches await_gt_sub calls with relaxed memory order.
 *
 * See @ref vatomic32_await_gt_sub_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_gt_sub_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_gt_sub, mo_rlx, a, c, v)
/**
 * @def vatomic_await_gt_add(a, c, v)
 * @brief Dispatches await_gt_add calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_gt_add_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_gt_add(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_gt_add, mo_seq, a, c, v)
/**
 * @def vatomic_await_gt_add_acq(a, c, v)
 * @brief Dispatches await_gt_add calls with acquire memory order.
 *
 * See @ref vatomic32_await_gt_add_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_gt_add_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_gt_add, mo_acq, a, c, v)
/**
 * @def vatomic_await_gt_add_rel(a, c, v)
 * @brief Dispatches await_gt_add calls with release memory order.
 *
 * See @ref vatomic32_await_gt_add_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_gt_add_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_gt_add, mo_rel, a, c, v)
/**
 * @def vatomic_await_gt_add_rlx(a, c, v)
 * @brief Dispatches await_gt_add calls with relaxed memory order.
 *
 * See @ref vatomic32_await_gt_add_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_gt_add_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_gt_add, mo_rlx, a, c, v)
/**
 * @def vatomic_await_ge_set(a, c, v)
 * @brief Dispatches await_ge_set calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_ge_set_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_ge_set(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_ge_set, mo_seq, a, c, v)
/**
 * @def vatomic_await_ge_set_acq(a, c, v)
 * @brief Dispatches await_ge_set calls with acquire memory order.
 *
 * See @ref vatomic32_await_ge_set_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_ge_set_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_ge_set, mo_acq, a, c, v)
/**
 * @def vatomic_await_ge_set_rel(a, c, v)
 * @brief Dispatches await_ge_set calls with release memory order.
 *
 * See @ref vatomic32_await_ge_set_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_ge_set_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_ge_set, mo_rel, a, c, v)
/**
 * @def vatomic_await_ge_set_rlx(a, c, v)
 * @brief Dispatches await_ge_set calls with relaxed memory order.
 *
 * See @ref vatomic32_await_ge_set_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_ge_set_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_ge_set, mo_rlx, a, c, v)
/**
 * @def vatomic_await_ge_sub(a, c, v)
 * @brief Dispatches await_ge_sub calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_ge_sub_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_ge_sub(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_ge_sub, mo_seq, a, c, v)
/**
 * @def vatomic_await_ge_sub_acq(a, c, v)
 * @brief Dispatches await_ge_sub calls with acquire memory order.
 *
 * See @ref vatomic32_await_ge_sub_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_ge_sub_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_ge_sub, mo_acq, a, c, v)
/**
 * @def vatomic_await_ge_sub_rel(a, c, v)
 * @brief Dispatches await_ge_sub calls with release memory order.
 *
 * See @ref vatomic32_await_ge_sub_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_ge_sub_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_ge_sub, mo_rel, a, c, v)
/**
 * @def vatomic_await_ge_sub_rlx(a, c, v)
 * @brief Dispatches await_ge_sub calls with relaxed memory order.
 *
 * See @ref vatomic32_await_ge_sub_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_ge_sub_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_ge_sub, mo_rlx, a, c, v)
/**
 * @def vatomic_await_ge_add(a, c, v)
 * @brief Dispatches await_ge_add calls with seq_cst memory order.
 *
 * See @ref vatomic32_await_ge_add_seq_cst for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord seq_cst
 */
#define vatomic_await_ge_add(a, c, v)                                          \
    V_DISPATCH32(INT_RET, await_ge_add, mo_seq, a, c, v)
/**
 * @def vatomic_await_ge_add_acq(a, c, v)
 * @brief Dispatches await_ge_add calls with acquire memory order.
 *
 * See @ref vatomic32_await_ge_add_acquire for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord acquire
 */
#define vatomic_await_ge_add_acq(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_ge_add, mo_acq, a, c, v)
/**
 * @def vatomic_await_ge_add_rel(a, c, v)
 * @brief Dispatches await_ge_add calls with release memory order.
 *
 * See @ref vatomic32_await_ge_add_release for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord release
 */
#define vatomic_await_ge_add_rel(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_ge_add, mo_rel, a, c, v)
/**
 * @def vatomic_await_ge_add_rlx(a, c, v)
 * @brief Dispatches await_ge_add calls with relaxed memory order.
 *
 * See @ref vatomic32_await_ge_add_relaxed for details.
 *
 * @param a atomic variable
 * @param c condition value
 * @param v operand value
 * @return value satisfying condition
 * @memord relaxed
 */
#define vatomic_await_ge_add_rlx(a, c, v)                                      \
    V_DISPATCH32(INT_RET, await_ge_add, mo_rlx, a, c, v)

#endif /* VATOMIC_DISPATCH_H */
