/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;

public class RoomSubmenu
extends JMenu
implements Comparator<CRoom> {
    public static final int ENABLED_ALWAYS = -1;
    public static final int ENABLED_NEVER = 0;
    public static final int ENABLED_PRIVATE = 1;
    public static final int ENABLED_NON_PRIVATE = 2;
    public static final int ENABLED_TOURNAMENT = 4;
    public static final int ENABLED_NON_TOURNAMENT = 8;
    private final Client client;
    private int whenEnabled;
    private final EventListener listener;
    private final int eventType;
    private Object arg;
    private final Collator collator = Collator.getInstance();

    public RoomSubmenu(String label, Client client, int whenEnabled, EventListener listener, int eventType, Object arg) {
        super(label);
        this.client = client;
        this.setWhenEnabled(whenEnabled);
        this.listener = listener;
        this.eventType = eventType;
        this.arg = arg;
    }

    public void setEventArg(Object newArg) {
        this.arg = newArg;
    }

    public void setWhenEnabled(int newWhenEnabled) {
        this.whenEnabled = newWhenEnabled;
    }

    @Override
    public void setPopupMenuVisible(boolean isVisible) {
        if (isVisible) {
            ArrayList<CRoom> rooms = new ArrayList<CRoom>();
            Iterator<Object> iter = this.client.getSubscribedRooms().iterator();
            while (iter.hasNext()) {
                rooms.add((CRoom)iter.next());
            }
            Collections.sort(rooms, this);
            for (final CRoom room : rooms) {
                JMenuItem mi = new JMenuItem(room.getName());
                mi.setEnabled((this.whenEnabled & (room.isPrivate() ? 1 : 2)) != 0 && (this.whenEnabled & (room.isTournOnly() ? 4 : 8)) != 0);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        RoomSubmenu.this.listener.handleEvent(new Event(room, RoomSubmenu.this.eventType, RoomSubmenu.this.arg));
                    }
                });
                this.add(mi);
            }
        } else {
            this.removeAll();
        }
        super.setPopupMenuVisible(isVisible);
    }

    @Override
    public int compare(CRoom raw1, CRoom raw2) {
        CRoom r1 = raw1;
        CRoom r2 = raw2;
        return this.collator.compare(r1.getName(), r2.getName());
    }
}

