/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.Chunk;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Bin
implements Comparable<Bin> {
    private final int referenceSequence;
    private final int binNumber;
    private List<Chunk> chunkList;
    private Chunk lastChunk;

    public Bin(int referenceSequence, int binNumber) {
        this.referenceSequence = referenceSequence;
        this.binNumber = binNumber;
    }

    protected int getReferenceSequence() {
        return this.referenceSequence;
    }

    public int getBinNumber() {
        return this.binNumber;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Bin)) {
            return false;
        }
        Bin otherBin = (Bin)other;
        return this.referenceSequence == otherBin.referenceSequence && this.binNumber == otherBin.binNumber;
    }

    public int hashCode() {
        return Integer.valueOf(this.referenceSequence).hashCode() ^ Integer.valueOf(this.binNumber).hashCode();
    }

    public boolean containsChunks() {
        return this.chunkList != null;
    }

    @Override
    public int compareTo(Bin other) {
        if (other == null) {
            throw new ClassCastException("Cannot compare to a null object");
        }
        if (this.referenceSequence != other.referenceSequence) {
            return this.referenceSequence - other.referenceSequence;
        }
        return this.binNumber - other.binNumber;
    }

    public void addInitialChunk(Chunk newChunk) {
        ArrayList<Chunk> oldChunks = new ArrayList<Chunk>();
        this.setChunkList(oldChunks);
        this.setLastChunk(newChunk);
        oldChunks.add(newChunk);
    }

    public void addChunk(Chunk newChunk) {
        if (!this.containsChunks()) {
            this.addInitialChunk(newChunk);
        } else {
            long chunkStart = newChunk.getChunkStart();
            long chunkEnd = newChunk.getChunkEnd();
            Chunk lastChunk = this.getLastChunk();
            if (BlockCompressedFilePointerUtil.areInSameOrAdjacentBlocks(lastChunk.getChunkEnd(), chunkStart)) {
                lastChunk.setChunkEnd(chunkEnd);
            } else {
                this.chunkList.add(newChunk);
                this.setLastChunk(newChunk);
            }
        }
    }

    public void setChunkList(List<Chunk> list) {
        this.chunkList = list;
    }

    public List<Chunk> getChunkList() {
        if (this.chunkList == null) {
            return Collections.emptyList();
        }
        return this.chunkList;
    }

    public void setLastChunk(Chunk c) {
        this.lastChunk = c;
    }

    public Chunk getLastChunk() {
        return this.lastChunk;
    }

    Bin shift(long offset) {
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>();
        for (Chunk chunk : this.getChunkList()) {
            chunkList.add(chunk.shift(offset));
        }
        Bin newBin = new Bin(this.referenceSequence, this.binNumber);
        newBin.setChunkList(chunkList);
        newBin.setLastChunk((Chunk)chunkList.get(chunkList.size() - 1));
        return newBin;
    }
}

