/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import java.nio.ByteBuffer;

final class Utils {
    Utils() {
    }

    private static void reverse(byte[] array, int offset, int size) {
        if (array == null) {
            return;
        }
        int i = offset;
        for (int j = offset + size - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    static void reverse(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            Utils.reverse(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        } else {
            for (int i = 0; i < byteBuffer.limit(); ++i) {
                byte tmp = byteBuffer.get(i);
                byteBuffer.put(i, byteBuffer.get(byteBuffer.limit() - i - 1));
                byteBuffer.put(byteBuffer.limit() - i - 1, tmp);
            }
        }
    }

    static int RANSDecodeGet(int r, int scaleBits) {
        return r & (1 << scaleBits) - 1;
    }

    static int RANSDecodeRenormalize(int r, ByteBuffer byteBuffer) {
        if (r < 0x800000) {
            while ((r = r << 8 | 0xFF & byteBuffer.get()) < 0x800000) {
            }
        }
        return r;
    }
}

