/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class BasicRadioButtonUI
extends BasicToggleButtonUI {
    protected Icon icon = this.getDefaultIcon();

    public static ComponentUI createUI(JComponent c) {
        return new BasicRadioButtonUI();
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (b.getIcon() == null) {
            b.setIcon(this.icon);
        }
        if (b.getSelectedIcon() == null) {
            b.setSelectedIcon(this.icon);
        }
        if (b.getDisabledIcon() == null) {
            b.setDisabledIcon(this.icon);
        }
        if (b.getDisabledSelectedIcon() == null) {
            b.setDisabledSelectedIcon(this.icon);
        }
    }

    protected String getPropertyPrefix() {
        return "RadioButton.";
    }

    public Icon getDefaultIcon() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        return defaults.getIcon(this.getPropertyPrefix() + "icon");
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Rectangle tr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle vr = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        Icon currentIcon = null;
        currentIcon = b.isSelected() && b.isEnabled() ? b.getSelectedIcon() : (!b.isSelected() && b.isEnabled() ? b.getIcon() : (b.isSelected() && !b.isEnabled() ? b.getDisabledSelectedIcon() : b.getDisabledIcon()));
        SwingUtilities.calculateInnerArea(b, vr);
        String text = SwingUtilities.layoutCompoundLabel(c, g.getFontMetrics(f), b.getText(), currentIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), vr, ir, tr, b.getIconTextGap() + this.defaultTextShiftOffset);
        if (currentIcon != null) {
            currentIcon.paintIcon(c, g, ir.x, ir.y);
        }
        if (text != null) {
            this.paintText(g, b, tr, text);
        }
        if (b.hasFocus() && b.isFocusPainted() && b.isEnabled()) {
            this.paintFocus(g, tr, null);
        }
    }

    protected void paintFocus(Graphics g, Rectangle tr, Dimension size) {
        Color focusColor = UIManager.getColor(this.getPropertyPrefix() + ".focus");
        Color saved = g.getColor();
        g.setColor(focusColor);
        g.drawRect(tr.x, tr.y, tr.width, tr.height);
        g.setColor(saved);
    }
}

