/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stats;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.feature.Range;
import org.broad.igv.util.collections.IntArrayList;

public class KaplanMeierEstimator {
    static List<Interval> compute(int[] time, boolean[] censured) {
        if (time.length != censured.length) {
            // empty if block
        }
        if (time.length < 2) {
            // empty if block
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        int startTime = 0;
        int endTime = 0;
        for (int i = 0; i < time.length; ++i) {
            endTime = time[i];
            if (censured[i] || endTime <= startTime) continue;
            intervals.add(new Interval(startTime, endTime));
            startTime = endTime;
        }
        if (endTime > startTime) {
            intervals.add(new Interval(startTime, endTime));
        }
        float atRisk = time.length;
        float cumulativeSurvival = 1.0f;
        Iterator intervalIter = intervals.iterator();
        Interval currentInterval = (Interval)intervalIter.next();
        currentInterval.setCumulativeSurvival(cumulativeSurvival);
        for (int i = 0; i < time.length; ++i) {
            int t = time[i];
            if (t > currentInterval.getEnd()) {
                float survivors = (atRisk -= (float)currentInterval.getNumberCensured()) - (float)currentInterval.getNumberDied();
                float tmp = survivors / atRisk;
                cumulativeSurvival *= tmp;
                atRisk -= (float)currentInterval.getNumberDied();
                while (intervalIter.hasNext() && t > currentInterval.getEnd()) {
                    currentInterval = (Interval)intervalIter.next();
                    currentInterval.setCumulativeSurvival(cumulativeSurvival);
                }
            }
            if (censured[i]) {
                currentInterval.addCensure(time[i]);
                continue;
            }
            currentInterval.incDied();
        }
        currentInterval.setCumulativeSurvival(cumulativeSurvival);
        return intervals;
    }

    public static void main(String[] args) {
        int[] survival = new int[]{1, 2, 3, 4, 5, 10, 12};
        boolean[] alive = new boolean[]{false, true, true, false, true, false, true};
        List<Interval> intervals = KaplanMeierEstimator.compute(survival, alive);
        for (Interval i : intervals) {
            System.out.println(i.getStart() + "\t" + i.getEnd() + "\t" + i.getNumberDied() + "\t" + i.getCensored().size() + "\t" + i.getCumulativeSurvival());
        }
    }

    public static class Interval
    extends Range {
        private int numberDied;
        private IntArrayList censored = new IntArrayList();
        private float cumulativeSurvival;

        public Interval(int start, int end) {
            super(null, start, end);
        }

        void incDied() {
            ++this.numberDied;
        }

        void addCensure(int time) {
            this.censored.add(time);
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getNumberDied() {
            return this.numberDied;
        }

        public IntArrayList getCensored() {
            return this.censored;
        }

        public float getCumulativeSurvival() {
            return this.cumulativeSurvival;
        }

        public void setCumulativeSurvival(float cumulativeSurvival) {
            this.cumulativeSurvival = cumulativeSurvival;
        }

        public int getNumberCensured() {
            return this.censored.size();
        }
    }
}

