# /u/sy/beebe/tex/bibclean/lex/bibdup.awk, Thu Jan 14 07:14:47 1993
# Edit by Nelson H. F. Beebe <beebe@plot79.math.utah.edu>
# ========================================================================
# Find duplicate @string{...} definitions and duplicate citation keys
# in a token stream from bibclean or biblex.
#
# Usage:
#
#	bibclean -no-pretty bibfiles | tr A-Z a-z | nawk -f bibdup.awk
# or
#	biblex bibfiles | tr A-Z a-z | nawk -f bibdup.awk
#
# [16-Jan-1993]
# ========================================================================

/^#/ 	{ last_line = $0 }

$2 == "key" {
		if ($3 in key)
		    printf("Duplicate key [%s]:\n\t%s\n\t%s\n",
			   $3, key[$3], last_line);
		else
		    key[$3] = last_line;
}

($2 == "string") || ($2 == "entry") { last_entry = $3 }

($2 == "abbrev") && (last_entry == "\"string\"") {
		if ($3 in abbrev)
		    printf("Duplicate string abbreviation [%s]:\n\t%s\n\t%s\n",
			   $3, abbrev[$3], last_line);
		else
		    abbrev[$3] = last_line;
}
