//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef RECORDS_TYPE_H
#define RECORDS_TYPE_H

#include "constants.h"
#include "datatypes.h"
#include "endianmess.h"
#include "packet.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


/// Garmin Records-Type 
/**
   A packet of this type is send after a wypoint rout or track request,
   it contains the number of packets that are going to be transmited from
   the device.
   This kind of packte is also send before any data is sent to the device,
   where n is the number of packets that are going to be sent.

*/
class Records_Type : Endianmess, Constants
{
   public: 

   /// constructor 
   Records_Type(void);

   /// calls set with the given Packet
   Records_Type(Packet);

   /// resets internal data
   void clear(void);

   /// set the data, also returns n like n()
   int set(Packet);

   /// make the packet
   Packet makePacket(void);
   /// returns the number of packets that are goint to be send
   g_int n;

 
   private: 

} ;


}
#endif

