/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.experimental;

import htsjdk.samtools.cram.encoding.core.experimental.ExperimentalCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;

class GolombIntegerCodec
extends ExperimentalCodec<Integer> {
    private final boolean QUOTIENT_BIT = true;
    private final int m;
    private final int offset;

    public GolombIntegerCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, int offset, int m) {
        super(coreBlockInputStream, coreBlockOutputStream);
        if (m < 2) {
            throw new IllegalArgumentException("M parameter must be at least 2.");
        }
        this.m = m;
        this.offset = offset;
    }

    @Override
    public final Integer read() {
        int quotient = 0;
        while (this.coreBlockInputStream.readBit()) {
            ++quotient;
        }
        int ceiling = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        int reminder = this.coreBlockInputStream.readBits(ceiling - 1);
        if ((double)reminder >= Math.pow(2.0, ceiling) - (double)this.m) {
            reminder <<= 1;
            reminder |= this.coreBlockInputStream.readBits(1);
            reminder = (int)((double)reminder - (Math.pow(2.0, ceiling) - (double)this.m));
        }
        return quotient * this.m + reminder - this.offset;
    }

    @Override
    public final void write(Integer value) {
        int newValue = value + this.offset;
        int quotient = newValue / this.m;
        int reminder = newValue % this.m;
        int ceiling = (int)(Math.log(this.m) / Math.log(2.0) + 1.0);
        this.coreBlockOutputStream.write(true, (long)quotient);
        this.coreBlockOutputStream.write(false);
        if ((double)reminder < Math.pow(2.0, ceiling) - (double)this.m) {
            this.coreBlockOutputStream.write(reminder, ceiling - 1);
        } else {
            this.coreBlockOutputStream.write((int)((double)reminder + Math.pow(2.0, ceiling) - (double)this.m), ceiling);
        }
    }

    @Override
    public Integer read(int length) {
        throw new RuntimeException("Multi-value read method not defined.");
    }

    public String toString() {
        return String.format("m: %d", this.m);
    }
}

