/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.external;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.external.ExternalByteCodec;
import htsjdk.samtools.cram.encoding.external.ExternalEncoding;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public final class ExternalByteEncoding
extends ExternalEncoding<Byte> {
    public ExternalByteEncoding(int externalBlockContentId) {
        super(externalBlockContentId);
    }

    public static ExternalByteEncoding fromSerializedEncodingParams(byte[] serializedParams) {
        int contentId = ITF8.readUnsignedITF8(serializedParams);
        return new ExternalByteEncoding(contentId);
    }

    @Override
    public CRAMCodec<Byte> buildCodec(SliceBlocksReadStreams sliceBlocksReadStreams, SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        ByteArrayInputStream is = sliceBlocksReadStreams == null ? null : sliceBlocksReadStreams.getExternalInputStream(this.externalBlockContentId);
        ByteArrayOutputStream os = sliceBlocksWriteStreams == null ? null : sliceBlocksWriteStreams.getExternalOutputStream(this.externalBlockContentId);
        return new ExternalByteCodec(is, os);
    }
}

