/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicPopupMenuUI
extends PopupMenuUI {
    static transient MouseInputListener mouseInputListener;
    protected JPopupMenu popupMenu;
    private transient PopupMenuListener popupMenuListener = new PopupMenuHandler();
    TopWindowListener topWindowListener = new TopWindowListener();

    public static ComponentUI createUI(JComponent x) {
        return new BasicPopupMenuUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.popupMenu = (JPopupMenu)c;
        this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        this.popupMenu.setBorderPainted(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(true);
        this.installDefaults();
        this.installListeners();
    }

    public void installDefaults() {
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        this.popupMenu.setOpaque(true);
    }

    protected void installListeners() {
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.popupMenu = null;
    }

    protected void uninstallDefaults() {
        this.popupMenu.setBackground(null);
        this.popupMenu.setBorder(null);
        this.popupMenu.setFont(null);
        this.popupMenu.setForeground(null);
    }

    protected void uninstallListeners() {
        this.popupMenu.removePopupMenuListener(this.popupMenuListener);
    }

    protected void uninstallKeyboardActions() {
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public boolean isPopupTrigger(MouseEvent e) {
        return false;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PopupMenuHandler
    implements PopupMenuListener {
        public void popupMenuCanceled(PopupMenuEvent event) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            boolean topLevelMenu;
            Component invoker = BasicPopupMenuUI.this.popupMenu.getInvoker();
            RootPaneContainer rootContainer = (RootPaneContainer)((Object)SwingUtilities.getRoot(invoker));
            ((Container)((Object)rootContainer)).removeComponentListener(BasicPopupMenuUI.this.topWindowListener);
            boolean bl = false;
            if (BasicPopupMenuUI.this.popupMenu.getInvoker() instanceof JMenu && ((JMenu)BasicPopupMenuUI.this.popupMenu.getInvoker()).isTopLevelMenu()) {
                bl = true;
            }
            if ((topLevelMenu = bl) || !(BasicPopupMenuUI.this.popupMenu.getInvoker() instanceof MenuElement)) {
                Container glassPane = (Container)rootContainer.getGlassPane();
                glassPane.setVisible(false);
                glassPane.removeMouseListener(mouseInputListener);
                mouseInputListener = null;
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
            MenuSelectionManager manager;
            Component invoker = BasicPopupMenuUI.this.popupMenu.getInvoker();
            RootPaneContainer rootContainer = (RootPaneContainer)((Object)SwingUtilities.getRoot(invoker));
            ((Container)((Object)rootContainer)).addComponentListener(BasicPopupMenuUI.this.topWindowListener);
            if (mouseInputListener == null) {
                Container glassPane = (Container)rootContainer.getGlassPane();
                glassPane.setVisible(true);
                mouseInputListener = new MouseInputHandler(rootContainer);
                glassPane.addMouseListener(mouseInputListener);
                glassPane.addMouseMotionListener(mouseInputListener);
            }
            if ((manager = MenuSelectionManager.defaultManager()).getSelectedPath().length == 0) {
                MenuElement[] path = new MenuElement[2];
                path[0] = BasicPopupMenuUI.this.popupMenu;
                Component[] comps = BasicPopupMenuUI.this.popupMenu.getComponents();
                if (comps.length != 0 && comps[0] instanceof MenuElement) {
                    path[1] = (MenuElement)((Object)comps[0]);
                    manager.setSelectedPath(path);
                }
            }
        }

        private PopupMenuHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TopWindowListener
    implements ComponentListener {
        public void componentResized(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void componentMoved(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void componentShown(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        public void componentHidden(ComponentEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        private TopWindowListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MouseInputHandler
    implements MouseInputListener {
        private JLayeredPane layeredPane;
        private Container glassPane;
        private Cursor nativeCursor;
        private transient Component mouseEventTarget;
        private transient Component pressedComponent;
        private transient Component lastComponentEntered;
        private transient Component tempComponent;
        private transient int pressCount;

        public void mouseClicked(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            this.handleEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.handleEvent(e);
        }

        public void acquireComponentForMouseEvent(MouseEvent me) {
            int x = me.getX();
            int y = me.getY();
            Container parent = this.layeredPane;
            Component candidate = null;
            Point p = me.getPoint();
            while (candidate == null && parent != null) {
                p = SwingUtilities.convertPoint(this.glassPane, p.x, p.y, parent);
                candidate = SwingUtilities.getDeepestComponentAt(parent, p.x, p.y);
                if (candidate != null) continue;
                p = SwingUtilities.convertPoint(parent, p.x, p.y, parent.getParent());
                parent = parent.getParent();
            }
            if (candidate == this.layeredPane) {
                candidate = null;
            }
            if (this.lastComponentEntered != null && this.lastComponentEntered.isShowing() && this.lastComponentEntered != candidate) {
                if (SwingUtilities.isDescendingFrom(this.lastComponentEntered, this.layeredPane)) {
                    Point tp = SwingUtilities.convertPoint(this.layeredPane, x, y, this.lastComponentEntered);
                    MouseEvent exited = new MouseEvent(this.lastComponentEntered, 505, me.getWhen(), me.getModifiersEx(), tp.x, tp.y, me.getClickCount(), me.isPopupTrigger(), me.getButton());
                    this.tempComponent = this.lastComponentEntered;
                    this.lastComponentEntered = null;
                    this.tempComponent.dispatchEvent(exited);
                }
                this.lastComponentEntered = null;
            }
            if (candidate != null) {
                this.mouseEventTarget = candidate;
                if (candidate.isLightweight() && candidate.isShowing() && candidate != this.layeredPane && candidate != this.lastComponentEntered) {
                    this.lastComponentEntered = this.mouseEventTarget;
                    Point cp = SwingUtilities.convertPoint(this.layeredPane, x, y, this.lastComponentEntered);
                    MouseEvent entered = new MouseEvent(this.lastComponentEntered, 504, me.getWhen(), me.getModifiersEx(), cp.x, cp.y, me.getClickCount(), me.isPopupTrigger(), me.getButton());
                    this.lastComponentEntered.dispatchEvent(entered);
                }
            }
            if (me.getID() == 502 || me.getID() == 501 && this.pressCount > 0 || me.getID() == 506) {
                if (SwingUtilities.isDescendingFrom(this.pressedComponent, this.layeredPane)) {
                    this.mouseEventTarget = this.pressedComponent;
                } else if (me.getID() == 500) {
                    if (candidate != this.pressedComponent) {
                        this.mouseEventTarget = null;
                    } else if (this.pressCount == 0) {
                        this.pressedComponent = null;
                    }
                }
            }
        }

        public void handleEvent(AWTEvent e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                this.acquireComponentForMouseEvent(me);
                if (this.mouseEventTarget != null && this.mouseEventTarget.isShowing() && e.getID() != 504 && e.getID() != 505) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(this.glassPane, me, this.mouseEventTarget);
                    this.mouseEventTarget.dispatchEvent(newEvt);
                    if (e.getID() == 502) {
                        boolean partOfMenuHierarchy = false;
                        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                        partOfMenuHierarchy = manager.isComponentPartOfCurrentMenu(this.mouseEventTarget);
                        if (!partOfMenuHierarchy) {
                            manager.clearSelectedPath();
                        }
                    }
                    switch (e.getID()) {
                        case 501: {
                            if (this.pressCount++ != 0) break;
                            this.pressedComponent = this.mouseEventTarget;
                            break;
                        }
                        case 502: {
                            if (--this.pressCount != 0 || this.mouseEventTarget == this.pressedComponent) break;
                            this.pressedComponent = null;
                            break;
                        }
                    }
                }
            }
        }

        public MouseInputHandler(RootPaneContainer c) {
            this.layeredPane = c.getLayeredPane();
            this.glassPane = (Container)c.getGlassPane();
        }
    }
}

