/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkGraphics;
import gnu.java.awt.peer.gtk.GdkGraphics2D;
import gnu.java.awt.peer.gtk.GtkFramePeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkToolkit;
import gnu.java.awt.peer.gtk.GtkVolatileImage;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.event.TextEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.util.Timer;
import java.util.TimerTask;

public class GtkComponentPeer
extends GtkGenericPeer
implements ComponentPeer {
    static final Timer repaintTimer = new Timer(true);
    VolatileImage backBuffer;
    BufferCapabilities caps;
    Component awtComponent;
    Insets insets;
    boolean isInRepaint;

    native boolean isEnabled();

    static native boolean modalHasGrab();

    native int[] gtkWidgetGetForeground();

    native int[] gtkWidgetGetBackground();

    native void gtkWidgetGetDimensions(int[] var1);

    native void gtkWidgetGetPreferredDimensions(int[] var1);

    native void gtkWidgetGetLocationOnScreen(int[] var1);

    native void gtkWidgetSetCursor(int var1);

    native void gtkWidgetSetCursorUnlocked(int var1);

    native void gtkWidgetSetBackground(int var1, int var2, int var3);

    native void gtkWidgetSetForeground(int var1, int var2, int var3);

    native void gtkWidgetSetSensitive(boolean var1);

    native void gtkWidgetSetParent(ComponentPeer var1);

    native void gtkWidgetRequestFocus();

    native void gtkWidgetDispatchKeyEvent(int var1, long var2, int var4, int var5, int var6);

    native boolean isRealized();

    void realize() {
    }

    native void setNativeEventMask();

    void create() {
        throw new RuntimeException();
    }

    native void connectSignals();

    void setParentAndBounds() {
        this.setParent();
        this.setComponentBounds();
        this.setVisibleAndEnabled();
    }

    void setParent() {
        ComponentPeer p;
        Component component = this.awtComponent;
        while ((p = (component = component.getParent()).getPeer()) instanceof LightweightPeer) {
        }
        if (p != null) {
            this.gtkWidgetSetParent(p);
        }
    }

    void beginNativeRepaint() {
        this.isInRepaint = true;
    }

    void endNativeRepaint() {
        this.isInRepaint = false;
    }

    void setComponentBounds() {
        Rectangle bounds = this.awtComponent.getBounds();
        if (bounds.x == 0 && bounds.y == 0 && bounds.width == 0 && bounds.height == 0) {
            return;
        }
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    void setVisibleAndEnabled() {
        this.setVisible(this.awtComponent.isVisible());
        this.setEnabled(this.awtComponent.isEnabled());
    }

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        return this.getToolkit().checkImage(image, width, height, observer);
    }

    public Image createImage(ImageProducer producer) {
        return new GtkImage(producer);
    }

    public Image createImage(int width, int height) {
        Image image = GtkToolkit.useGraphics2D() ? new BufferedImage(width, height, 1) : new GtkImage(width, height);
        Graphics g = image.getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        return image;
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.getToolkit().getFontMetrics(font);
    }

    public Graphics getGraphics() {
        if (GtkToolkit.useGraphics2D()) {
            return new GdkGraphics2D(this);
        }
        return new GdkGraphics(this);
    }

    public Point getLocationOnScreen() {
        int[] point = new int[2];
        this.gtkWidgetGetLocationOnScreen(point);
        return new Point(point[0], point[1]);
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public void handleEvent(AWTEvent event) {
        int id = event.getID();
        KeyEvent ke = null;
        switch (id) {
            case 800: 
            case 801: {
                try {
                    Graphics g = this.getGraphics();
                    if (g == null) break;
                    g.setClip(((PaintEvent)event).getUpdateRect());
                    if (id == 800) {
                        this.awtComponent.paint(g);
                    } else {
                        this.awtComponent.update(g);
                    }
                    g.dispose();
                }
                catch (InternalError e) {
                    System.err.println(e);
                }
                break;
            }
            case 401: {
                ke = (KeyEvent)event;
                this.gtkWidgetDispatchKeyEvent(ke.getID(), ke.getWhen(), ke.getModifiersEx(), ke.getKeyCode(), ke.getKeyLocation());
                break;
            }
            case 402: {
                ke = (KeyEvent)event;
                this.gtkWidgetDispatchKeyEvent(ke.getID(), ke.getWhen(), ke.getModifiersEx(), ke.getKeyCode(), ke.getKeyLocation());
                break;
            }
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Dimension minimumSize() {
        int[] dim = new int[2];
        this.gtkWidgetGetPreferredDimensions(dim);
        return new Dimension(dim[0], dim[1]);
    }

    public void paint(Graphics g) {
    }

    public Dimension preferredSize() {
        int[] dim = new int[2];
        this.gtkWidgetGetPreferredDimensions(dim);
        return new Dimension(dim[0], dim[1]);
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        return this.getToolkit().prepareImage(image, width, height, observer);
    }

    public void print(Graphics g) {
        throw new RuntimeException();
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        if (x == 0 && y == 0 && width == 0 && height == 0) {
            return;
        }
        repaintTimer.schedule((TimerTask)new RepaintTimerTask(x, y, width, height), tm);
    }

    public void requestFocus() {
        this.gtkWidgetRequestFocus();
        this.postFocusEvent(1004, false);
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public void setBackground(Color c) {
        this.gtkWidgetSetBackground(c.getRed(), c.getGreen(), c.getBlue());
    }

    native void setNativeBounds(int var1, int var2, int var3, int var4);

    public void setBounds(int x, int y, int width, int height) {
        int new_x = x;
        int new_y = y;
        Container parent = this.awtComponent.getParent();
        boolean lightweightChild = false;
        while (parent.isLightweight()) {
            lightweightChild = true;
            Container next_parent = parent.getParent();
            Insets i = parent.getInsets();
            if (next_parent instanceof Window) {
                new_x += i.left;
                new_y += i.top;
            } else {
                new_x += parent.getX() + i.left;
                new_y += parent.getY() + i.top;
            }
            parent = next_parent;
        }
        if (parent instanceof Window && !lightweightChild) {
            GtkWindowPeer peer = (GtkWindowPeer)parent.getPeer();
            Insets insets = peer.getInsets();
            int menuBarHeight = 0;
            if (peer instanceof GtkFramePeer) {
                menuBarHeight = ((GtkFramePeer)peer).getMenuBarHeight();
            }
            new_x = x - insets.left;
            new_y = y - insets.top + menuBarHeight;
        }
        this.setNativeBounds(new_x, new_y, width, height);
    }

    void setCursor() {
        this.setCursor(this.awtComponent.getCursor());
    }

    public void setCursor(Cursor cursor) {
        if (Thread.currentThread() == GtkToolkit.mainThread) {
            this.gtkWidgetSetCursorUnlocked(cursor.getType());
        } else {
            this.gtkWidgetSetCursor(cursor.getType());
        }
    }

    public void setEnabled(boolean b) {
        this.gtkWidgetSetSensitive(b);
    }

    public void setFont(Font f) {
        this.gtkWidgetModifyFont(f.getName(), f.getStyle(), f.getSize());
    }

    public void setForeground(Color c) {
        this.gtkWidgetSetForeground(c.getRed(), c.getGreen(), c.getBlue());
    }

    public Color getForeground() {
        int[] rgb = this.gtkWidgetGetForeground();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public Color getBackground() {
        int[] rgb = this.gtkWidgetGetBackground();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public native void setVisibleNative(boolean var1);

    public native void setVisibleNativeUnlocked(boolean var1);

    public void setVisible(boolean b) {
        if (Thread.currentThread() == GtkToolkit.mainThread) {
            this.setVisibleNativeUnlocked(b);
        } else {
            this.setVisibleNative(b);
        }
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    protected void postMouseEvent(int id, long when, int mods, int x, int y, int clickCount, boolean popupTrigger) {
        GtkComponentPeer.q().postEvent(new MouseEvent(this.awtComponent, id, when, mods, x, y, clickCount, popupTrigger));
    }

    protected void postExposeEvent(int x, int y, int width, int height) {
        if (!this.isInRepaint) {
            GtkComponentPeer.q().postEvent(new PaintEvent(this.awtComponent, 800, new Rectangle(x, y, width, height)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void postKeyEvent(int id, long when, int mods, int keyCode, char keyChar, int keyLocation) {
        KeyEvent keyEvent = new KeyEvent(this.awtComponent, id, when, mods, keyCode, keyChar, keyLocation);
        if (keyEvent.getID() == 401 && !keyEvent.isActionKey() && keyCode != 16 && keyCode != 17 && keyCode != 18) {
            EventQueue eventQueue = q;
            synchronized (eventQueue) {
                GtkComponentPeer.q().postEvent(keyEvent);
                GtkComponentPeer.q().postEvent(new KeyEvent(this.awtComponent, 400, when, mods, 0, keyChar, keyLocation));
                return;
            }
        }
        GtkComponentPeer.q().postEvent(keyEvent);
    }

    protected void postFocusEvent(int id, boolean temporary) {
        GtkComponentPeer.q().postEvent(new FocusEvent(this.awtComponent, id, temporary));
    }

    protected void postItemEvent(Object item, int stateChange) {
        GtkComponentPeer.q().postEvent(new ItemEvent((ItemSelectable)((Object)this.awtComponent), 701, item, stateChange));
    }

    protected void postTextEvent() {
        GtkComponentPeer.q().postEvent(new TextEvent(this.awtComponent, 900));
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return null;
    }

    public void setEventMask(long mask) {
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean requestFocus(Component source, boolean b1, boolean b2, long x) {
        return false;
    }

    public boolean isObscured() {
        return false;
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    public void coalescePaintEvent(PaintEvent e) {
    }

    public void updateCursorImmediately() {
        if (this.awtComponent.getCursor() != null) {
            this.setCursor(this.awtComponent.getCursor());
        }
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public VolatileImage createVolatileImage(int width, int height) {
        return new GtkVolatileImage(width, height);
    }

    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
        if (numBuffers != 2) {
            throw new AWTException("GtkComponentPeer.createBuffers: multi-buffering not supported");
        }
        this.backBuffer = new GtkVolatileImage(this.awtComponent.getWidth(), this.awtComponent.getHeight(), caps.getBackBufferCapabilities());
        this.caps = caps;
    }

    public Image getBackBuffer() {
        return this.backBuffer;
    }

    public void flip(BufferCapabilities.FlipContents contents) {
        this.getGraphics().drawImage(this.backBuffer, this.awtComponent.getWidth(), this.awtComponent.getHeight(), null);
        if (contents == BufferCapabilities.FlipContents.BACKGROUND) {
            this.backBuffer = this.createVolatileImage(this.awtComponent.getWidth(), this.awtComponent.getHeight());
            this.backBuffer.getGraphics().clearRect(0, 0, this.awtComponent.getWidth(), this.awtComponent.getHeight());
        }
    }

    public void destroyBuffers() {
        this.backBuffer.flush();
    }

    public String toString() {
        return "peer of " + this.awtComponent.toString();
    }

    public Rectangle getBounds() {
        return null;
    }

    public void reparent(ContainerPeer parent) {
    }

    public void setBounds(int x, int y, int width, int height, int z) {
        this.setBounds(x, y, width, height);
    }

    public boolean isReparentSupported() {
        return false;
    }

    public void layout() {
    }

    protected GtkComponentPeer(Component awtComponent) {
        super(awtComponent);
        this.awtComponent = awtComponent;
        this.insets = new Insets(0, 0, 0, 0);
        this.create();
        this.connectSignals();
        if (awtComponent.getForeground() != null) {
            this.setForeground(awtComponent.getForeground());
        }
        if (awtComponent.getBackground() != null) {
            this.setBackground(awtComponent.getBackground());
        }
        if (awtComponent.getFont() != null) {
            this.setFont(awtComponent.getFont());
        }
        Container parent = awtComponent.getParent();
        if (awtComponent instanceof Window || parent != null && !parent.isShowing()) {
            this.setParentAndBounds();
        }
        this.setNativeEventMask();
        this.realize();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RepaintTimerTask
    extends TimerTask {
        private int x;
        private int y;
        private int width;
        private int height;

        public void run() {
            GtkComponentPeer.q().postEvent(new PaintEvent(GtkComponentPeer.this.awtComponent, 801, new Rectangle(this.x, this.y, this.width, this.height)));
        }

        RepaintTimerTask(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

