/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.windows.CloneableOpenSupport;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class POMDataObject
extends MultiDataObject {
    public static final String SETTINGS_MIME_TYPE = "text/x-maven-settings+xml";
    static final String POM_ICON = "org/netbeans/modules/maven/grammar/xmlObject.gif";
    private static final Logger LOG = Logger.getLogger(POMDataObject.class.getName());

    public POMDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)new POMDataEditor());
        cookies.add((Node.Cookie)new ValidateXMLSupport(DataObjectAdapters.inputSource((DataObject)this)));
    }

    public static MultiViewEditorElement createMultiViewEditorElement(Lookup context) {
        return new MultiViewEditorElement(context);
    }

    public static MultiViewEditorElement createSettingsMultiViewEditorElement(Lookup context) {
        return new MultiViewEditorElement(context);
    }

    protected int associateLookup() {
        return 1;
    }

    static String annotateWithProjectName(FileObject primaryFile) {
        if (primaryFile.getNameExt().equals("pom.xml")) {
            try {
                String text;
                Element artifactId = XMLUtil.findElement((Element)XMLUtil.parse((InputSource)new InputSource(primaryFile.toURL().toString()), (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null).getDocumentElement(), (String)"artifactId", null);
                if (artifactId != null && (text = XMLUtil.findText((Node)artifactId)) != null) {
                    return " [" + text + "]";
                }
            }
            catch (IOException x) {
                LOG.log(Level.INFO, null, x);
            }
            catch (IllegalArgumentException x) {
                LOG.log(Level.FINE, null, x);
            }
            catch (SAXException x) {
                LOG.log(Level.FINE, null, x);
            }
        }
        return "";
    }

    private static class POMEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 1L;

        POMEnv(MultiDataObject d) {
            super((DataObject)d);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getLookup().lookup(POMDataEditor.class);
        }
    }

    private class POMDataEditor
    extends DataEditorSupport
    implements EditorCookie.Observable,
    OpenCookie,
    EditCookie,
    PrintCookie,
    CloseCookie {
        private String cachedTitleSuffix;
        private final Object TITLE_LOCK;
        private final SaveCookie save;
        private final FileChangeListener listener;

        POMDataEditor() {
            super((DataObject)POMDataObject.this, null, (CloneableEditorSupport.Env)new POMEnv(POMDataObject.this));
            this.cachedTitleSuffix = null;
            this.TITLE_LOCK = new Object();
            this.save = new SaveCookie(){

                public void save() throws IOException {
                    POMDataEditor.this.saveDocument();
                }

                public String toString() {
                    return POMDataObject.this.getPrimaryFile().getNameExt();
                }
            };
            this.listener = new FileChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileChanged(FileEvent fe) {
                    Object object = POMDataEditor.this.TITLE_LOCK;
                    synchronized (object) {
                        POMDataEditor.this.cachedTitleSuffix = null;
                    }
                    POMDataEditor.this.updateTitles();
                }
            };
            POMDataObject.this.getPrimaryFile().addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)POMDataObject.this.getPrimaryFile()));
        }

        protected CloneableEditorSupport.Pane createPane() {
            return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)"text/x-maven-pom+xml", (Serializable)this.getDataObject());
        }

        protected boolean notifyModified() {
            if (!super.notifyModified()) {
                return false;
            }
            if (POMDataObject.this.getLookup().lookup(SaveCookie.class) == null) {
                POMDataObject.this.getCookieSet().add((Node.Cookie)this.save);
                POMDataObject.this.setModified(true);
            }
            return true;
        }

        protected void notifyUnmodified() {
            super.notifyUnmodified();
            if (POMDataObject.this.getLookup().lookup(SaveCookie.class) == this.save) {
                POMDataObject.this.getCookieSet().remove((Node.Cookie)this.save);
                POMDataObject.this.setModified(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String messageName() {
            String titleSuffix = null;
            Object object = this.TITLE_LOCK;
            synchronized (object) {
                if (this.cachedTitleSuffix == null) {
                    this.cachedTitleSuffix = POMDataObject.annotateWithProjectName(POMDataObject.this.getPrimaryFile());
                }
                titleSuffix = this.cachedTitleSuffix;
            }
            return super.messageName() + titleSuffix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String messageHtmlName() {
            String titleSuffix = null;
            Object object = this.TITLE_LOCK;
            synchronized (object) {
                if (this.cachedTitleSuffix == null) {
                    this.cachedTitleSuffix = POMDataObject.annotateWithProjectName(POMDataObject.this.getPrimaryFile());
                }
                titleSuffix = this.cachedTitleSuffix;
            }
            return super.messageHtmlName() + titleSuffix;
        }

        protected boolean asynchronousOpen() {
            return true;
        }
    }
}

