/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesParser;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.PropertiesStructure;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class StructHandler {
    private PropertiesFileEntry propFileEntry;
    private WeakReference<RequestProcessor.Task> parsingTaskWRef = new WeakReference<Object>(null);
    private SoftReference<PropertiesStructure> propStructureSRef = new SoftReference<Object>(null);
    private WeakReference<PropertiesParser> parserWRef = new WeakReference<Object>(null);
    private boolean parsingAllowed = true;
    static final long serialVersionUID = -3367087822606643886L;

    public StructHandler(PropertiesFileEntry propFileEntry) {
        this.propFileEntry = propFileEntry;
    }

    PropertiesStructure reparseNowBlocking() {
        return this.reparseNowBlocking(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesStructure reparseNowBlocking(boolean fire) {
        PropertiesStructure propStructure = null;
        StructHandler structHandler = this;
        synchronized (structHandler) {
            if (!this.parsingAllowed) {
                return null;
            }
            FileObject fo = this.propFileEntry.getFile();
            if (!fo.canRead()) {
                return null;
            }
            PropertiesParser parser = new PropertiesParser(this.propFileEntry);
            try {
                this.parserWRef = new WeakReference<PropertiesParser>(parser);
                parser.initParser();
                propStructure = parser.parseFile();
            }
            catch (IOException iOException) {
            }
            finally {
                parser.clean();
            }
        }
        this.updatePropertiesStructure(propStructure, fire);
        return propStructure;
    }

    synchronized void stopParsing() {
        this.parsingAllowed = false;
        PropertiesParser parser = (PropertiesParser)this.parserWRef.get();
        if (parser != null) {
            parser.stop();
        }
    }

    synchronized void allowParsing() {
        this.parsingAllowed = true;
    }

    public PropertiesFileEntry getEntry() {
        return this.propFileEntry;
    }

    void autoParse() {
        if (!this.isStructureLoaded()) {
            return;
        }
        RequestProcessor.Task previousTask = (RequestProcessor.Task)this.parsingTaskWRef.get();
        if (previousTask != null) {
            previousTask.schedule(500);
        } else {
            this.parsingTaskWRef = new WeakReference<RequestProcessor.Task>(PropertiesRequestProcessor.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    StructHandler.this.reparseNowBlocking();
                }
            }));
        }
    }

    private void updatePropertiesStructure(PropertiesStructure newPropStructure, boolean fire) {
        if (newPropStructure == null) {
            this.propStructureSRef = new SoftReference<Object>(null);
            return;
        }
        PropertiesStructure propStructure = this.propStructureSRef.get();
        if (propStructure == null) {
            newPropStructure.setParent(this);
            propStructure = newPropStructure;
            this.propStructureSRef = new SoftReference<PropertiesStructure>(propStructure);
            if (fire) {
                propStructure.structureChanged();
            }
        } else {
            propStructure.update(newPropStructure);
        }
    }

    public PropertiesStructure getStructure() {
        PropertiesStructure propStructure = this.propStructureSRef.get();
        if (propStructure != null) {
            return propStructure;
        }
        return this.reparseNowBlocking(false);
    }

    private boolean isStructureLoaded() {
        return this.propStructureSRef.get() != null;
    }
}

