/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.task;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.FileUtil;

public class NSConfig {
    public static final String WORKERS_CONFIG = "/conf/workers.properties";
    public static final String NS_CONFIG = "/conf/obj.conf";
    public static final String JK_LOG_LOCATION = "/logs/netscape_redirect.log";

    public void execute(ContextManager cm) throws TomcatException {
        try {
            String tomcatHome = cm.getHome();
            PrintWriter objfile = new PrintWriter(new FileWriter(String.valueOf(tomcatHome) + NS_CONFIG + "-auto"));
            objfile.println("###################################################################");
            objfile.println("# Auto generated configuration. Dated: " + new Date());
            objfile.println("###################################################################");
            objfile.println();
            objfile.println("#");
            objfile.println("# You will need to merge the content of this file with your ");
            objfile.println("# regular obj.conf and then restart (=stop + start) your Netscape server. ");
            objfile.println("#");
            objfile.println();
            objfile.println("#");
            objfile.println("# Loading the redirector into your server");
            objfile.println("#");
            objfile.println();
            objfile.println("Init fn=\"load-modules\" funcs=\"jk_init,jk_service\" shlib=\"<put full path to the redirector here>\"");
            objfile.println("Init fn=\"jk_init\" worker_file=\"" + new File(tomcatHome, WORKERS_CONFIG).toString().replace('\\', '/') + "\" log_level=\"debug\" log_file=\"" + new File(tomcatHome, JK_LOG_LOCATION).toString().replace('\\', '/') + "\"");
            objfile.println();
            objfile.println("<Object name=default>");
            objfile.println("#");
            objfile.println("# Redirecting the root context requests to tomcat.");
            objfile.println("#");
            objfile.println("NameTrans fn=\"assign-name\" from=\"/servlet/*\" name=\"servlet\"");
            objfile.println("NameTrans fn=\"assign-name\" from=\"/*.jsp\" name=\"servlet\"");
            objfile.println();
            Enumeration enumeration = cm.getContexts();
            while (enumeration.hasMoreElements()) {
                Context context = (Context)enumeration.nextElement();
                String path = context.getPath();
                String vhost = context.getHost();
                if (vhost != null || path.length() <= 1) continue;
                String docBase = context.getDocBase();
                if (!FileUtil.isAbsolute(docBase)) {
                    docBase = String.valueOf(tomcatHome) + "/" + docBase;
                }
                docBase = FileUtil.patch(docBase).replace('\\', '/');
                objfile.println("#########################################################");
                objfile.println("# Auto configuration for the " + path + " context starts.");
                objfile.println("#########################################################");
                objfile.println();
                objfile.println("#");
                objfile.println("# The following line mounts all JSP file and the /servlet/ uri to tomcat");
                objfile.println("#");
                objfile.println("NameTrans fn=\"assign-name\" from=\"" + path + "/servlet/*\" name=\"servlet\"");
                objfile.println("NameTrans fn=\"assign-name\" from=\"" + path + "/*.jsp\" name=\"servlet\"");
                objfile.println("NameTrans fn=pfx2dir from=\"" + path + "\" dir=\"" + docBase + "\"");
                objfile.println();
                objfile.println("#######################################################");
                objfile.println("# Auto configuration for the " + path + " context ends.");
                objfile.println("#######################################################");
                objfile.println();
            }
            objfile.println("#######################################################");
            objfile.println("# Protecting the web inf directory.");
            objfile.println("#######################################################");
            objfile.println("PathCheck fn=\"deny-existence\" path=\"*/WEB-INF/*\"");
            objfile.println();
            objfile.println("</Object>");
            objfile.println();
            objfile.println("#######################################################");
            objfile.println("# New object to execute your servlet requests.");
            objfile.println("#######################################################");
            objfile.println("<Object name=servlet>");
            objfile.println("ObjectType fn=force-type type=text/html");
            objfile.println("Service fn=\"jk_service\" worker=\"ajp12\" path=\"/*\"");
            objfile.println("</Object>");
            objfile.println();
            objfile.close();
        }
        catch (Exception ex) {
            System.out.println("Error generating automatic Netscape configuration " + ex);
            ex.printStackTrace(System.out);
        }
    }
}

