/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.options;

import java.util.List;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.javascript.nodejs.exec.ExpressExecutable;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.openide.util.NbPreferences;

public final class NodeJsOptions {
    public static final String NODE_PATH = "node.path";
    public static final String NODE_SOURCES_PATH = "node.sources.path";
    public static final String NPM_PATH = "npm.path";
    public static final String NPM_IGNORE_NODE_MODULES = "npm.ignore.node_modules";
    public static final String EXPRESS_PATH = "express.path";
    private static final String PREFERENCES_PATH = "nodejs";
    private static final NodeJsOptions INSTANCE = new NodeJsOptions();
    private final Preferences preferences = NbPreferences.forModule(NodeJsOptions.class).node("nodejs");
    private volatile boolean nodeSearched = false;
    private volatile boolean npmSearched = false;
    private volatile boolean expressSearched = false;

    private NodeJsOptions() {
    }

    public static NodeJsOptions getInstance() {
        return INSTANCE;
    }

    public void addPreferenceChangeListener(PreferenceChangeListener listener) {
        this.preferences.addPreferenceChangeListener(listener);
    }

    public void removePreferenceChangeListener(PreferenceChangeListener listener) {
        this.preferences.removePreferenceChangeListener(listener);
    }

    @CheckForNull
    public String getNode() {
        String path = this.preferences.get(NODE_PATH, null);
        if (path == null && !this.nodeSearched) {
            this.nodeSearched = true;
            path = NodeJsUtils.getNode();
            if (path != null) {
                this.setNode(path);
            }
        }
        return path;
    }

    public void setNode(String node) {
        this.preferences.put(NODE_PATH, node);
    }

    @CheckForNull
    public String getNodeSources() {
        return this.preferences.get(NODE_SOURCES_PATH, null);
    }

    public void setNodeSources(@NullAllowed String nodeSources) {
        if (nodeSources == null) {
            this.preferences.remove(NODE_SOURCES_PATH);
        } else {
            this.preferences.put(NODE_SOURCES_PATH, nodeSources);
        }
    }

    @CheckForNull
    public String getNpm() {
        String path = this.preferences.get(NPM_PATH, null);
        if (path == null && !this.npmSearched) {
            this.npmSearched = true;
            path = NodeJsUtils.getNpm();
            if (path != null) {
                this.setNpm(path);
            }
        }
        return path;
    }

    public void setNpm(String npm) {
        this.preferences.put(NPM_PATH, npm);
    }

    public boolean isNpmIgnoreNodeModules() {
        return this.preferences.getBoolean(NPM_IGNORE_NODE_MODULES, true);
    }

    public void setNpmIgnoreNodeModules(boolean npmIgnoreNodeModules) {
        this.preferences.putBoolean(NPM_IGNORE_NODE_MODULES, npmIgnoreNodeModules);
    }

    @CheckForNull
    public String getExpress() {
        String path = this.preferences.get(EXPRESS_PATH, null);
        if (path == null && !this.expressSearched) {
            this.expressSearched = true;
            List<String> files = FileUtils.findFileOnUsersPath(ExpressExecutable.EXPRESS_NAME);
            if (!files.isEmpty()) {
                path = files.get(0);
                this.setExpress(path);
            }
        }
        return path;
    }

    public void setExpress(String express) {
        this.preferences.put(EXPRESS_PATH, express);
    }
}

