/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.run;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.extexecution.print.LineProcessors;
import org.netbeans.modules.php.phpunit.commands.PhpUnit;
import org.netbeans.modules.php.phpunit.run.Bundle;
import org.netbeans.modules.php.phpunit.run.TestSuiteVo;
import org.netbeans.modules.php.spi.testing.run.OutputLineHandler;
import org.openide.windows.OutputWriter;

public final class TestSessionVo {
    private final List<TestSuiteVo> testSuites = new ArrayList<TestSuiteVo>();
    private final String customSuitePath;
    private boolean started = false;

    public TestSessionVo(@NullAllowed String customSuitePath) {
        this.customSuitePath = customSuitePath;
    }

    public void addTestSuite(TestSuiteVo testSuite) {
        this.testSuites.add(testSuite);
    }

    public List<TestSuiteVo> getTestSuites() {
        return Collections.unmodifiableList(this.testSuites);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public String getInitMessage() {
        if (this.customSuitePath != null) {
            return Bundle.TestSessionVo_msg_customSuite(this.customSuitePath);
        }
        return null;
    }

    @CheckForNull
    public String getFinishMessage() {
        if (this.testSuites.isEmpty()) {
            return null;
        }
        return Bundle.TestSessionVo_msg_output();
    }

    public String getFinishError() {
        if (this.testSuites.isEmpty()) {
            return Bundle.TestSessionVo_err_output();
        }
        return null;
    }

    public String toString() {
        return String.format("TestSessionVo{started: %s, suites: %d}", this.started, this.testSuites.size());
    }

    public OutputLineHandler getOutputLineHandler() {
        return new PhpOutputLineHandler();
    }

    private static final class PhpOutputLineHandler
    implements OutputLineHandler {
        private static final LineConvertor CONVERTOR = LineConvertors.proxy((LineConvertor[])new LineConvertor[]{LineConvertors.filePattern(null, (Pattern)PhpUnit.OUT_LINE_PATTERN, null, (int)1, (int)2), LineConvertors.filePattern(null, (Pattern)PhpUnit.ERR_LINE_PATTERN, null, (int)1, (int)2)});

        private PhpOutputLineHandler() {
        }

        public void handleLine(OutputWriter out, String text) {
            LineProcessors.printing((OutputWriter)out, (LineConvertor)CONVERTOR, (boolean)true).processLine(text);
        }
    }
}

