/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class JCServerTask
extends Task {
    boolean inNetBeans() {
        return System.getProperty("netbeans.home") != null;
    }

    protected void startServer() {
        if (this.inNetBeans()) {
            return;
        }
        File emulatorBinary = this.getFileProp("javacard.emulator");
        String[] commandLine = new String[]{emulatorBinary.getAbsolutePath(), "-ramsize", this.getRamSize(), "-e2psize", this.getE2pSize(), "-corsize", this.getCorSize(), "-e2pfile", this.getEepromFile().getAbsolutePath(), "-loggerlevel", this.getLoggerLevel().toLowerCase(), "-httpport", this.getHttpPort(), "-contactedport", this.getContactedPort(), "-contactedprotocol", this.getContactedProtocol(), "-contactlessport", this.getContactlessPort(), this.isSuspend() ? "" : "-nosuspend"};
    }

    protected void resumeServer() {
        if (this.inNetBeans()) {
            return;
        }
        File emulatorBinary = this.getFileProp("javacard.emulator");
        String[] commandLine = new String[]{emulatorBinary.getAbsolutePath(), "-resume"};
    }

    protected void stopServer() {
        if (this.inNetBeans()) {
            return;
        }
    }

    protected void restartServer() {
        if (this.inNetBeans()) {
            return;
        }
        this.stopServer();
        this.startServer();
    }

    private String getPlatformID() {
        return this.getProp("javacard.instance.id");
    }

    private String getDeviceID() {
        return this.getProp("javacard.device.name");
    }

    private String getJCDKHome() {
        return this.getProp("javacard.home");
    }

    private boolean isSuspend() {
        return !this.getBool("javacard.device.nosuspend");
    }

    private String getContactedPort() {
        return this.getProp("javacard.device.contactedPort");
    }

    private String getContactedProtocol() {
        return this.getProp("javacard.device.contactedProtocol");
    }

    private String getContactlessPort() {
        return this.getProp("javacard.device.contactlessPort");
    }

    private String getCorSize() {
        return this.getProp("javacard.device.corSize");
    }

    private String getE2pSize() {
        return this.getProp("javacard.device.e2pSize");
    }

    private File getEepromFile() {
        File f = this.getFileProp("javacard.device.eeprom.folder", true);
        String deviceId = this.getProp("javacard.device.name");
        String ext = this.getProp("javacard.device.eprom.file.extension", false);
        if (ext == null) {
            ext = "eprom";
        }
        File epromFile = new File(f, deviceId + '.' + ext);
        return epromFile;
    }

    private String getHttpPort() {
        return this.getProp("javacard.device.httpPort");
    }

    private String getLoggerLevel() {
        return this.getProp("javacard.device.loggerLevel");
    }

    private String getProxy2cjcrePort() {
        return this.getProp("javacard.device.proxy2cjcrePort");
    }

    private String getRamSize() {
        return this.getProp("javacard.device.ramSize");
    }

    protected boolean getBool(String key) {
        String val = this.getProp(key, false);
        return val == null ? false : Boolean.valueOf(val);
    }

    protected String getProp(String key) throws BuildException {
        return this.getProp(key, true);
    }

    protected String getProp(String key, boolean failOnNull) throws BuildException {
        String result = this.getProject().getProperty(key);
        if (failOnNull && result == null) {
            throw new BuildException(key + " not set");
        }
        return result;
    }

    protected File getFileProp(String key) throws BuildException {
        return this.getFileProp(key, true);
    }

    protected File getFileProp(String key, boolean mustBeSet) throws BuildException {
        String prop = this.getProp(key, mustBeSet);
        if (prop != null) {
            prop = prop.replace('/', File.separatorChar);
            File f = new File(prop);
            File[] roots = File.listRoots();
            boolean absolute = false;
            if (f != null) {
                for (File r : roots) {
                    String s;
                    if (prop.startsWith(r.getAbsolutePath())) {
                        absolute = true;
                        break;
                    }
                    File upper = new File(r.getAbsolutePath().toUpperCase());
                    if (!upper.exists() || !(s = prop.toUpperCase()).startsWith(upper.getAbsolutePath())) continue;
                    absolute = true;
                    break;
                }
            }
            if (absolute) {
                this.log("Resolved " + key + " as absolute file " + f);
                return f;
            }
            f = new File(this.getProject().getBaseDir(), prop);
            this.log("Resolved " + key + " as relative file " + f);
            return f;
        }
        throw new AssertionError();
    }
}

