/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.jcfile.instructions.JcInstruction;

public class InstrContainer {
    private int forced_type;
    private OperandStack parent_operand_stack;
    private OperandStack working_operand_stack;
    private JInstruction j_instr;
    private JcInstruction jc_instr;
    private InstrContainer prev_instr_container;
    private InstrContainer next_instr_container;
    private InstrContainer[] out_instr_containers;
    private boolean label_flag;
    private int label = -1;
    private boolean controlFlowLabelFlag = false;
    private boolean catch_finally_block_leader;
    private boolean changed_flag = false;
    private boolean visited_flag = false;
    private boolean isInserted = false;

    public InstrContainer(JInstruction jInstruction) {
        this.j_instr = jInstruction;
        this.out_instr_containers = new InstrContainer[0];
    }

    public JInstruction getJInstr() {
        return this.j_instr;
    }

    public void setJInstr(JInstruction jInstruction) {
        this.j_instr = jInstruction;
    }

    public boolean isInserted() {
        return this.isInserted;
    }

    public void setInserted(boolean bl) {
        this.isInserted = bl;
    }

    public JcInstruction getJcInstr() {
        return this.jc_instr;
    }

    public void setJcInstr(JcInstruction jcInstruction) {
        this.jc_instr = jcInstruction;
    }

    public InstrContainer getPrevInstrContainer() {
        return this.prev_instr_container;
    }

    public void setPrevInstrContainer(InstrContainer instrContainer) {
        this.prev_instr_container = instrContainer;
    }

    public InstrContainer getNextInstrContainer() {
        return this.next_instr_container;
    }

    public void setNextInstrContainer(InstrContainer instrContainer) {
        this.next_instr_container = instrContainer;
    }

    public InstrContainer[] getOutInstrContainers() {
        return this.out_instr_containers;
    }

    public void link(InstrContainer instrContainer) {
        int n = this.out_instr_containers.length;
        for (int i = 0; i < n; ++i) {
            if (this.out_instr_containers[i].getJInstr().getPC() != instrContainer.getJInstr().getPC()) continue;
            return;
        }
        InstrContainer[] instrContainerArray = new InstrContainer[n + 1];
        System.arraycopy(this.out_instr_containers, 0, instrContainerArray, 0, n);
        instrContainerArray[n] = instrContainer;
        this.out_instr_containers = instrContainerArray;
    }

    public void relink(InstrContainer instrContainer, InstrContainer instrContainer2) {
        int n = this.out_instr_containers.length;
        for (int i = 0; i < n; ++i) {
            if (this.out_instr_containers[i].getJInstr().getPC() != instrContainer.getJInstr().getPC()) continue;
            this.out_instr_containers[i] = instrContainer2;
        }
    }

    public OperandStack getOperandStack() {
        return this.working_operand_stack;
    }

    public void forceNewStack(OperandStack operandStack) {
        this.parent_operand_stack = operandStack;
        this.working_operand_stack = operandStack;
    }

    public void resetStack() {
        this.parent_operand_stack = null;
        this.working_operand_stack = null;
    }

    public void resetWorkingStack() {
        this.working_operand_stack = null;
    }

    public void setOperandStack(OperandStack operandStack) {
        if (this.parent_operand_stack == null) {
            this.parent_operand_stack = operandStack;
            this.changed_flag = true;
        } else {
            this.merge(operandStack);
        }
        this.working_operand_stack = (OperandStack)this.parent_operand_stack.clone();
    }

    public int getForcedType() {
        return this.forced_type;
    }

    public void setForcedType(int n) {
        this.forced_type = n;
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int n) {
        this.label = n;
    }

    public boolean hasLabel() {
        return this.label_flag;
    }

    public void setLabelFlag(boolean bl) {
        this.label_flag = bl;
    }

    public boolean getControlFlowLabelFlag() {
        return this.controlFlowLabelFlag;
    }

    public void setControlFlowLabelFlag(boolean bl) {
        this.controlFlowLabelFlag = bl;
    }

    public boolean isCatchFinallyBlockLeader() {
        return this.catch_finally_block_leader;
    }

    public void setCatchFinallyBlockLeader(boolean bl) {
        this.catch_finally_block_leader = bl;
    }

    public void setChangedFlag(boolean bl) {
        this.changed_flag = bl;
    }

    public boolean hasChanged() {
        return this.changed_flag;
    }

    public boolean isVisited() {
        return this.visited_flag;
    }

    public void setVisited(boolean bl) {
        this.visited_flag = bl;
    }

    private void merge(OperandStack operandStack) {
        OperandStackEntry[] operandStackEntryArray;
        OperandStackEntry[] operandStackEntryArray2 = this.parent_operand_stack.getStackEntries();
        if (operandStackEntryArray2.length != (operandStackEntryArray = operandStack.getStackEntries()).length) {
            throw new ConverterInternalError();
        }
        for (int i = operandStackEntryArray2.length - 1; i >= 0; --i) {
            if (operandStackEntryArray2[i].getType() == operandStackEntryArray[i].getType()) continue;
            if (operandStackEntryArray2[i].getType() == 3) {
                operandStackEntryArray[i].rollBack();
            }
            if (operandStackEntryArray[i].getType() == 3) {
                this.parent_operand_stack = operandStack;
                this.changed_flag = true;
                operandStackEntryArray2[i].rollBack();
            }
            if (operandStackEntryArray2[i].getType() == 10) {
                throw new ConverterInternalError();
            }
            if (operandStackEntryArray[i].getType() != 10) continue;
            throw new ConverterInternalError();
        }
    }

    public void reset() {
        if (this.parent_operand_stack == null) {
            throw new ConverterInternalError();
        }
        this.working_operand_stack = (OperandStack)this.parent_operand_stack.clone();
        this.jc_instr = null;
    }

    public InstrContainer findRetInstrContainer() {
        InstrContainer instrContainer = this.getOutInstrContainers()[0];
        switch (instrContainer.getJInstr().getOpcode()) {
            case 75: {
                return instrContainer.findRetInstrContainer(0);
            }
            case 76: {
                return instrContainer.findRetInstrContainer(1);
            }
            case 77: {
                return instrContainer.findRetInstrContainer(2);
            }
            case 78: {
                return instrContainer.findRetInstrContainer(3);
            }
            case 58: {
                return instrContainer.findRetInstrContainer(((JInstrByteIndex)instrContainer.getJInstr()).getIndex());
            }
        }
        throw new ConverterInternalError();
    }

    private InstrContainer findRetInstrContainer(int n) {
        for (InstrContainer instrContainer = this; instrContainer != null; instrContainer = instrContainer.getNextInstrContainer()) {
            if (instrContainer.getJInstr().getOpcode() != 169 || ((JInstrByteIndex)instrContainer.getJInstr()).getIndex() != n) continue;
            return instrContainer;
        }
        return null;
    }
}

