/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.netbeans.modules.j2me.project.ui.customizer.PermissionsProvider;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddPermissionPanel
extends JPanel {
    private static final CharsetEncoder ASCII_CHARSET_ENCODER = Charset.forName("US-ASCII").newEncoder();
    private JComboBox<PermissionsProvider.PermissionDescriptor> permissionsCombo;
    private JTextField nameField;
    private JCheckBox useNullName;
    private JTextField actionsField;
    private JCheckBox useNullActions;
    private JLabel errorLabel;
    private ParameterDefinition nameDefinition;
    private ParameterDefinition actionsDefinition;
    private DialogDescriptor dd;
    private final PermissionsProvider.PermissionsFactory permissionsFactory;

    protected AddPermissionPanel(Window owner, PermissionsProvider permissionsProvider, Collection<String> existingPermissions, String permissionToEdit) {
        if (permissionToEdit != null) {
            existingPermissions = new HashSet<String>(existingPermissions);
            existingPermissions.remove(permissionToEdit);
        }
        this.permissionsFactory = permissionsProvider.getPermissionsFactory(existingPermissions);
        this.createUI(permissionToEdit);
    }

    private static String getUIString(String uiKey) {
        return NbBundle.getMessage(AddPermissionPanel.class, (String)uiKey);
    }

    private void createUI(String permissionToEdit) {
        PermissionsProvider.PermissionDefinition selectPermission = permissionToEdit == null ? null : this.permissionsFactory.getPermission(permissionToEdit);
        this.permissionsCombo = new JComboBox<PermissionsProvider.PermissionDescriptor>(this.permissionsFactory.getAvailablePermissions());
        this.permissionsCombo.setPreferredSize(new Dimension(Math.max(400, this.permissionsCombo.getPreferredSize().width), this.permissionsCombo.getPreferredSize().height));
        this.nameField = new JTextField();
        this.useNullName = new JCheckBox(AddPermissionPanel.getUIString("LBL_AddPermission_UseNull"));
        this.actionsField = new JTextField();
        this.useNullActions = new JCheckBox(AddPermissionPanel.getUIString("LBL_AddPermission_UseNull"));
        this.nameDefinition = new ParameterDefinition("LBL_AddPermission_ResourceName", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPermissionPanel.this.updateNameAndActions();
            }
        });
        this.actionsDefinition = new ParameterDefinition("LBL_AddPermission_Action", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermissionsProvider.PermissionDescriptor permissionDescr;
                if (!AddPermissionPanel.this.actionsDefinition.useParameter() && !(permissionDescr = (PermissionsProvider.PermissionDescriptor)AddPermissionPanel.this.permissionsCombo.getSelectedItem()).actionsCanBeOptional(true)) {
                    AddPermissionPanel.this.nameDefinition.setUseParameter(false);
                }
                AddPermissionPanel.this.updateNameAndActions();
            }
        });
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)new JLabel(AddPermissionPanel.getUIString("LBL_AddPermission_Permission")), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        mainPanel.add(this.permissionsCombo, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
        mainPanel.add((Component)this.nameDefinition, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        mainPanel.add((Component)this.nameField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        mainPanel.add((Component)this.useNullName, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 5), 0, 0));
        mainPanel.add((Component)this.actionsDefinition, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        mainPanel.add((Component)this.actionsField, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        mainPanel.add((Component)this.useNullActions, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 5), 0, 0));
        this.errorLabel = new JLabel(" ");
        this.errorLabel.setForeground(Color.RED);
        mainPanel.add((Component)this.errorLabel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(mainPanel);
        this.nameField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (ASCII_CHARSET_ENCODER.canEncode(str)) {
                    super.insertString(offs, str, a);
                }
            }
        });
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddPermissionPanel.this.updateOKAction();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddPermissionPanel.this.updateOKAction();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddPermissionPanel.this.updateOKAction();
            }
        });
        this.actionsField.setDocument(new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (ASCII_CHARSET_ENCODER.canEncode(str)) {
                    super.insertString(offs, str, a);
                }
            }
        });
        this.actionsField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddPermissionPanel.this.updateOKAction();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddPermissionPanel.this.updateOKAction();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddPermissionPanel.this.updateOKAction();
            }
        });
        this.permissionsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPermissionPanel.this.updateNameAndActions();
            }
        });
        this.useNullName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPermissionPanel.this.updateNameAndActions();
            }
        });
        this.useNullActions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPermissionPanel.this.updateNameAndActions();
            }
        });
        PermissionsProvider.PermissionDescriptor descriptor = null;
        if (selectPermission != null) {
            descriptor = this.permissionsFactory.getDescriptor(selectPermission);
            this.permissionsCombo.setSelectedItem(descriptor);
            if (selectPermission.getNumberOfParameters() > 0) {
                String nameValue;
                if (descriptor.nameCanBeOptional()) {
                    this.nameDefinition.setUseParameter(true);
                }
                this.useNullName.setSelected((nameValue = selectPermission.getName()) == null);
                if (nameValue != null) {
                    this.nameField.setText(nameValue);
                }
                if (selectPermission.getNumberOfParameters() > 1) {
                    String actionsValue;
                    if (descriptor.actionsCanBeOptional(true)) {
                        this.actionsDefinition.setUseParameter(true);
                    }
                    this.useNullActions.setSelected((actionsValue = selectPermission.getActions()) == null);
                    if (actionsValue != null) {
                        this.actionsField.setText(actionsValue);
                    }
                }
            }
        }
        this.updateNameAndActions();
    }

    private void updateNameAndActions() {
        PermissionsProvider.PermissionDescriptor permissionDescr = (PermissionsProvider.PermissionDescriptor)this.permissionsCombo.getSelectedItem();
        if (permissionDescr != null) {
            this.nameDefinition.setEnabled(permissionDescr.supportsName());
            this.nameDefinition.setOptional(permissionDescr.supportsName() && permissionDescr.nameCanBeOptional());
            this.actionsDefinition.setEnabled(permissionDescr.supportsAction() && this.nameDefinition.useParameter());
            this.actionsDefinition.setOptional(permissionDescr.supportsAction() && this.nameDefinition.useParameter() && permissionDescr.actionsCanBeOptional(this.nameDefinition.useParameter()));
            this.useNullName.setEnabled(permissionDescr.supportsName() && this.nameDefinition.useParameter());
            this.nameField.setEnabled(this.useNullName.isEnabled() && !this.useNullName.isSelected());
            this.useNullActions.setEnabled(permissionDescr.supportsAction() && this.actionsDefinition.useParameter());
            this.actionsField.setEnabled(this.useNullActions.isEnabled() && !this.useNullActions.isSelected());
            this.updateOKAction();
        }
    }

    private String getNameValue() {
        return this.getParameterValue(this.useNullName, this.nameField, false);
    }

    private String getActionsValue() {
        return this.getParameterValue(this.useNullActions, this.actionsField, true);
    }

    private String getParameterValue(JCheckBox useNull, JTextField parameterField, boolean trim) {
        if (useNull.isSelected()) {
            return null;
        }
        String result = parameterField.getText();
        if (trim) {
            result = result.trim();
        }
        return result;
    }

    private int getNumberOfParameters() {
        int result = 0;
        if (this.nameDefinition.useParameter()) {
            ++result;
            if (this.actionsDefinition.useParameter()) {
                ++result;
            }
        }
        return result;
    }

    private void updateOKAction() {
        boolean enable;
        PermissionsProvider.PermissionDescriptor permissionDescr = (PermissionsProvider.PermissionDescriptor)this.permissionsCombo.getSelectedItem();
        if (permissionDescr == null) {
            enable = false;
        } else {
            PermissionsProvider.PermissionError valid = this.permissionsFactory.validatePermission(permissionDescr, this.getNameValue(), this.getActionsValue(), this.getNumberOfParameters());
            boolean bl = enable = valid == PermissionsProvider.PermissionError.OK;
            if (!enable) {
                this.errorLabel.setText(AddPermissionPanel.getUIString("ERR_AddPermission_" + valid.name()));
            }
        }
        if (enable) {
            this.errorLabel.setText(" ");
        }
        if (this.dd != null) {
            this.dd.setValid(enable);
        }
    }

    public PermissionsProvider.PermissionDefinition getPermission() {
        return this.permissionsFactory.getPermission((PermissionsProvider.PermissionDescriptor)this.permissionsCombo.getSelectedItem(), this.getNameValue(), this.getActionsValue(), this.getNumberOfParameters());
    }

    protected void setDialogDescriptor(DialogDescriptor desc) {
        this.dd = desc;
        this.dd.setHelpCtx(new HelpCtx("org.netbeans.modules.j2me.project.ui.customizer.AddPermissionPanel"));
        this.updateOKAction();
    }

    private static class ParameterDefinition
    extends JPanel {
        private final JCheckBox useParameter;
        private final JLabel parameterLabel;

        public ParameterDefinition(String uiKey, ActionListener actionListener) {
            super(new CardLayout());
            String labelText = AddPermissionPanel.getUIString(uiKey);
            this.useParameter = new JCheckBox(labelText);
            this.useParameter.setBorder(null);
            if (actionListener != null) {
                this.useParameter.addActionListener(actionListener);
            }
            this.parameterLabel = new JLabel(labelText);
            this.add((Component)this.useParameter, Boolean.TRUE.toString());
            this.add((Component)this.parameterLabel, Boolean.FALSE.toString());
        }

        public boolean useParameter() {
            return this.isEnabled() && (!this.useParameter.isVisible() || this.useParameter.isSelected());
        }

        public void setUseParameter(boolean value) {
            this.useParameter.setSelected(value);
        }

        public void setOptional(boolean optional) {
            ((CardLayout)this.getLayout()).show(this, Boolean.toString(optional));
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.parameterLabel.setEnabled(enabled);
            this.useParameter.setEnabled(enabled);
        }
    }
}

