/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.utils;

import java.util.Collection;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;

public abstract class CndNotifier {
    private static final CndNotifier DEFAULT = new CndErrorNotifierDefault();

    public static CndNotifier getDefault() {
        if (CndUtils.isStandalone()) {
            return DEFAULT;
        }
        Collection notifiers = Lookup.getDefault().lookupAll(CndNotifier.class);
        if (notifiers.isEmpty()) {
            return DEFAULT;
        }
        return (CndNotifier)notifiers.iterator().next();
    }

    public abstract void notifyError(String var1);

    public abstract void notifyInfo(String var1);

    public abstract void notifyErrorLater(String var1);

    public abstract boolean notifyAndIgnore(String var1, String var2);

    public abstract void notifyStatus(String var1);

    private static class CndErrorNotifierDefault
    extends CndNotifier {
        private CndErrorNotifierDefault() {
        }

        @Override
        public void notifyErrorLater(String msg) {
            this.notifyError(msg);
        }

        @Override
        public void notifyError(String msg) {
            System.err.println(msg);
        }

        @Override
        public void notifyInfo(String msg) {
            System.out.println(msg);
        }

        @Override
        public boolean notifyAndIgnore(String title, String msg) {
            this.notifyError(msg);
            return true;
        }

        @Override
        public void notifyStatus(String text) {
            System.out.println(text);
        }
    }

    public static enum Category {
        INFO,
        WARNING,
        ERROR;

    }

    public static enum Priority {
        HIGH,
        NORMAL,
        LOW,
        SILENT;

    }
}

