/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic.debug;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.highlight.semantic.SemanticHighlighter;
import org.netbeans.modules.cnd.highlight.semantic.debug.InterrupterImpl;
import org.netbeans.modules.cnd.modelutil.CsmFontColorManager;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.PositionsBag;
import org.openide.text.NbDocument;

public class TestSemanticHighlighting {
    private static final String MIME_TYPE = "text/x-c++";

    public static List<Highlight> gethighlightsBagForTests(Document doc, InterrupterImpl interrupter) {
        ArrayList<Highlight> ret = new ArrayList<Highlight>();
        PositionsBag fastBag = SemanticHighlighter.getSemanticBagForTests(doc, interrupter, true);
        PositionsBag slowBag = SemanticHighlighter.getSemanticBagForTests(doc, interrupter, false);
        PositionsBag bag = new PositionsBag(doc);
        bag.addAllHighlights(fastBag);
        bag.addAllHighlights(slowBag);
        HighlightsSequence hs = bag.getHighlights(0, doc.getLength());
        while (hs.moveNext() && !interrupter.cancelled()) {
            int start = hs.getStartOffset();
            int end = hs.getEndOffset();
            FontColorProvider.Entity type = CsmFontColorManager.instance().getSemanticEntityByAttributeSet(MIME_TYPE, hs.getAttributes());
            ret.add(new Highlight(doc, start, end, type));
        }
        return ret;
    }

    public static class Highlight {
        private final Document doc;
        private final int startOffset;
        private final int endOffset;
        private final FontColorProvider.Entity type;

        public Highlight(Document doc, int startOffset, int endOffset, FontColorProvider.Entity type) {
            this.doc = doc;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.type = type;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String getStartPosition() {
            return this.getPositionByOffset(this.doc, this.startOffset);
        }

        public String getEndPosition() {
            return this.getPositionByOffset(this.doc, this.endOffset);
        }

        public FontColorProvider.Entity getType() {
            return this.type;
        }

        private String getPositionByOffset(Document doc, int offset) {
            int lineNumber = -1;
            int lineColumn = -1;
            try {
                lineNumber = 1 + NbDocument.findLineNumber((StyledDocument)((StyledDocument)doc), (int)offset);
                lineColumn = 1 + NbDocument.findLineColumn((StyledDocument)((StyledDocument)doc), (int)offset);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return lineNumber + ":" + lineColumn;
        }
    }
}

