/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.ui.BrokenViewItemRefreshSupport;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesItemAction;
import org.netbeans.modules.cnd.makeproject.ui.RefreshableItemsContainer;
import org.netbeans.modules.cnd.makeproject.ui.RemoveItemAction;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

final class BrokenViewItemNode
extends AbstractNode {
    private final RefreshableItemsContainer childrenKeys;
    private final Folder folder;
    private final Item item;
    private final Project project;
    private final BrokenViewItemRefreshSupport.BrokenViewItemListener brokenViewItemListener;

    public BrokenViewItemNode(RefreshableItemsContainer childrenKeys, Folder folder, Item item, Project project) {
        super(Children.LEAF);
        this.childrenKeys = childrenKeys;
        this.folder = folder;
        this.item = item;
        this.setName(item.getNormalizedPath());
        this.setDisplayName(item.getName());
        this.setShortDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"BrokenTxt", (Object)item.getPath()));
        this.project = project;
        this.brokenViewItemListener = project1 -> {
            if (this.getParentNode() == null) {
                return;
            }
            if (project1 == this.project) {
                this.refresh();
            }
        };
        BrokenViewItemRefreshSupport.addBrokenViewItemListener((BrokenViewItemRefreshSupport.BrokenViewItemListener)WeakListeners.create(BrokenViewItemRefreshSupport.BrokenViewItemListener.class, (EventListener)this.brokenViewItemListener, BrokenViewItemRefreshSupport.class));
    }

    public Image getIcon(int type) {
        String mimeType = MIMESupport.getKnownSourceFileMIMETypeByExtension((String)this.item.getName());
        Image original = "text/x-c++".equals(mimeType) ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/source/resources/CCSrcIcon.gif") : ("text/x-c".equals(mimeType) ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/source/resources/CSrcIcon.gif") : ("text/x-h".equals(mimeType) ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/source/resources/HDataIcon.gif") : ("text/x-fortran".equals(mimeType) ? ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/source/resources/FortranSrcIcon.gif") : ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/loaders/unknown.gif"))));
        return ImageUtilities.mergeImages((Image)original, (Image)MakeLogicalViewProvider.brokenProjectBadge, (int)11, (int)0);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(RemoveItemAction.class), new RefreshItemAction(this.childrenKeys, null, this.item), null, SystemAction.get(PropertiesItemAction.class)};
    }

    public void refresh() {
        this.childrenKeys.refreshItem(this.item);
    }

    public boolean canRename() {
        return false;
    }

    public Object getValue(String valstring) {
        if (valstring == null) {
            return super.getValue(null);
        }
        if (valstring.equals("Folder")) {
            return this.folder;
        }
        if (valstring.equals("Project")) {
            return this.project;
        }
        if (valstring.equals("Item")) {
            return this.item;
        }
        if (valstring.equals("This")) {
            return this;
        }
        return super.getValue(valstring);
    }

    static final class RefreshItemAction
    extends AbstractAction {
        private final RefreshableItemsContainer childrenKeys;
        private final Folder folder;
        private final Item item;

        public RefreshItemAction(RefreshableItemsContainer childrenKeys, Folder folder, Item item) {
            this.childrenKeys = childrenKeys;
            this.folder = folder;
            this.item = item;
            this.putValue("Name", NbBundle.getBundle(this.getClass()).getString("CTL_Refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.item != null) {
                this.childrenKeys.refreshItem(this.item);
            } else {
                Item[] items = this.folder.getItemsAsArray();
                for (int i = 0; i < items.length; ++i) {
                    this.childrenKeys.refreshItem(items[i]);
                }
            }
        }
    }
}

