/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.launchers.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.cnd.makeproject.ui.launchers.actions.LaunchersConfig;
import org.netbeans.modules.cnd.makeproject.ui.runprofiles.ListTableModel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.lookup.Lookups;

public class LaunchersPanel
extends JPanel
implements ExplorerManager.Provider,
MakeContext.Savable {
    private final ExplorerManager manager = new ExplorerManager();
    private final SelectionChangeListener listener = new SelectionChangeListener();
    private final ArrayList<LaunchersConfig.LauncherConfig> launchers = new ArrayList();
    private final LaunchersNodes nodes;
    private LaunchersConfig.LauncherConfig selectedConfiguration;
    private final LaunchersConfig instance;
    private final ListTableModel envVarModel;
    private final JTable envVarTable;
    private final TreeView tree;
    private boolean modified = false;
    private volatile boolean resetFields = true;
    private final Preferences panelPreferences = NbPreferences.forModule(this.getClass()).node("launchers");
    private static final String COMMPLETION_ACTION = "completion";
    private JPanel LauncersListPanel;
    private JButton addButton;
    private JButton addEnvButton;
    private JLabel buildLabel;
    private JTextField buildTextField;
    private JButton copyButton;
    private JButton downButton;
    private JLabel envLabel;
    private JScrollPane envVarScrollPane;
    private JCheckBox hideCheckBox;
    private JScrollPane jScrollPane1;
    private JLabel launcherNameLabel;
    private JTextField launcherNameTextField;
    private JLabel launchersListLabel;
    private JPanel leftPanel;
    private JCheckBox publicCheckBox;
    private JButton removeButton;
    private JButton removeEnvButton;
    private JPanel rightPanel;
    private JLabel runDirLabel;
    private JTextField runDirTextField;
    private JCheckBox runInOwnTabCheckBox;
    private JLabel runLabel;
    private JTextArea runTextField;
    private JLabel symbolLabel;
    private JTextField symbolsTextField;
    private JButton upButton;

    public LaunchersPanel(Project project, boolean standAloneDialog) {
        if (standAloneDialog) {
            this.setPreferredSize(new Dimension(this.panelPreferences.getInt("dialogSizeW", 640), this.panelPreferences.getInt("dialogSizeH", 450)));
        } else {
            this.setPreferredSize(new Dimension(640, 450));
        }
        this.setMinimumSize(new Dimension(400, 200));
        this.initComponents();
        this.addHierarchyListener(e -> {
            if (e.getChangeFlags() == 4L && !e.getChanged().isVisible()) {
                if (standAloneDialog) {
                    this.panelPreferences.putInt("dialogSizeW", this.getSize().width);
                    this.panelPreferences.putInt("dialogSizeH", this.getSize().height);
                }
                if (this.selectedConfiguration != null) {
                    int index = this.launchers.indexOf(this.selectedConfiguration);
                    this.panelPreferences.putInt("lastSelecion", index);
                }
            }
        });
        this.envVarModel = new ListTableModel(NbBundle.getMessage(LaunchersPanel.class, (String)"EnvName"), NbBundle.getMessage(LaunchersPanel.class, (String)"EnvValue"));
        this.envVarTable = new JTable(this.envVarModel);
        this.envVarModel.setTable(this.envVarTable);
        this.envVarScrollPane.setViewportView(this.envVarTable);
        this.envVarTable.getSelectionModel().addListSelectionListener(this::validateEnvButtons);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.instance = new LaunchersConfig(project);
        this.instance.load();
        this.launchers.addAll(this.instance.getLaunchers());
        this.nodes = new LaunchersNodes(this.launchers);
        this.tree = new BeanTreeViewImpl();
        this.tree.setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.LauncersListPanel.add((Component)this.tree, "Center");
        this.update();
        ActionListener actionListener = e -> {
            if (!this.resetFields) {
                this.updateListViewItem();
            }
        };
        this.publicCheckBox.addActionListener(actionListener);
        this.hideCheckBox.addActionListener(actionListener);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!LaunchersPanel.this.resetFields) {
                    LaunchersPanel.this.updateListViewItem();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!LaunchersPanel.this.resetFields) {
                    LaunchersPanel.this.updateListViewItem();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!LaunchersPanel.this.resetFields) {
                    LaunchersPanel.this.updateListViewItem();
                }
            }
        };
        this.launcherNameTextField.getDocument().addDocumentListener(documentListener);
        this.runTextField.getDocument().addDocumentListener(documentListener);
        InputMap im = this.runTextField.getInputMap();
        ActionMap am = this.runTextField.getActionMap();
        im.put(KeyStroke.getKeyStroke("ctrl SPACE"), COMMPLETION_ACTION);
        am.put(COMMPLETION_ACTION, new CompletionAction(this.runTextField));
        im = this.runDirTextField.getInputMap();
        am = this.runDirTextField.getActionMap();
        im.put(KeyStroke.getKeyStroke("ctrl SPACE"), COMMPLETION_ACTION);
        am.put(COMMPLETION_ACTION, new CompletionAction(this.runDirTextField));
        im = this.buildTextField.getInputMap();
        am = this.buildTextField.getActionMap();
        im.put(KeyStroke.getKeyStroke("ctrl SPACE"), COMMPLETION_ACTION);
        am.put(COMMPLETION_ACTION, new CompletionAction(this.buildTextField));
        im = this.symbolsTextField.getInputMap();
        am = this.symbolsTextField.getActionMap();
        im.put(KeyStroke.getKeyStroke("ctrl SPACE"), COMMPLETION_ACTION);
        am.put(COMMPLETION_ACTION, new CompletionAction(this.symbolsTextField));
    }

    @Override
    public void save() {
        this.updateSelectedConfiguration();
        if (this.modified) {
            this.instance.save(this.launchers);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    final void update() {
        LaunchersConfig.LauncherConfig sc = this.selectedConfiguration;
        this.manager.setRootContext((Node)new RootNode((Children)this.nodes));
        this.modified = false;
        if (sc == null) {
            if (this.nodes.getNodesCount() > 0) {
                int index = this.panelPreferences.getInt("lastSelecion", -1);
                if (index < 0) {
                    index = 0;
                } else if (index >= this.nodes.getNodesCount()) {
                    index = 0;
                }
                try {
                    this.manager.setSelectedNodes(new Node[]{this.nodes.getNodeAt(index)});
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.listener.propertyChange(new PropertyChangeEvent(this, "selectedNodes", null, null));
            }
        } else {
            this.selectNode(sc);
        }
    }

    private void selectNode(LaunchersConfig.LauncherConfig cfg) {
        Children children = this.manager.getRootContext().getChildren();
        for (Node node : children.getNodes()) {
            if (!(node instanceof LauncherNode) || ((LauncherNode)node).getConfiguration() != cfg) continue;
            try {
                this.manager.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            break;
        }
    }

    private LaunchersConfig.LauncherConfig getSelectedConfiguration() {
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes.length == 1 && selectedNodes[0] instanceof LauncherNode) {
            return ((LauncherNode)selectedNodes[0]).getConfiguration();
        }
        return null;
    }

    private String getString(String s) {
        return s.trim().replace('\n', ' ').replace('\t', ' ');
    }

    private void updateSelectedConfiguration() {
        if (this.selectedConfiguration != null) {
            TableCellEditor cellEditor;
            this.selectedConfiguration.setName(this.launcherNameTextField.getText().trim());
            this.selectedConfiguration.setCommand(this.getString(this.runTextField.getText()));
            this.selectedConfiguration.setBuildCommand(this.buildTextField.getText().trim());
            this.selectedConfiguration.setRunDir(this.runDirTextField.getText().trim());
            this.selectedConfiguration.setSymbolFiles(this.symbolsTextField.getText().trim());
            this.selectedConfiguration.setPublic(this.publicCheckBox.isSelected());
            this.selectedConfiguration.setHide(this.hideCheckBox.isSelected());
            this.selectedConfiguration.setrunInOwnTab(this.runInOwnTabCheckBox.isSelected());
            if (this.envVarTable.isEditing() && (cellEditor = this.envVarTable.getCellEditor()) != null) {
                cellEditor.stopCellEditing();
            }
            HashMap<String, String> newContent = new HashMap<String, String>();
            for (int i = 0; i < this.envVarModel.getRowCount(); ++i) {
                String key = (String)this.envVarModel.getValueAt(i, 0);
                String value = (String)this.envVarModel.getValueAt(i, 1);
                if (key == null || value == null || (key = key.trim()).isEmpty()) continue;
                newContent.put(key, value.trim());
            }
            this.modified = this.selectedConfiguration.getEnv().size() != newContent.size() ? true : (this.modified |= !this.selectedConfiguration.getEnv().equals(newContent));
            this.selectedConfiguration.getEnv().clear();
            this.selectedConfiguration.getEnv().putAll(newContent);
            this.modified |= this.selectedConfiguration.isModified();
            this.updateListViewItem();
        }
    }

    private void updateListViewItem() {
        LauncherNode node;
        Node[] selectedNodes;
        if (this.selectedConfiguration != null && (selectedNodes = this.manager.getSelectedNodes()).length == 1 && selectedNodes[0] instanceof LauncherNode && this.selectedConfiguration == (node = (LauncherNode)selectedNodes[0]).getConfiguration()) {
            node.updateNode(this.launcherNameTextField.getText().trim(), this.getString(this.runTextField.getText()), this.publicCheckBox.isSelected(), this.hideCheckBox.isSelected());
        }
    }

    private void enableControls() {
        boolean b = this.selectedConfiguration != null;
        boolean c = true;
        boolean top = true;
        boolean bottom = true;
        if (b) {
            c = this.selectedConfiguration.getID() >= 0;
            int index = this.launchers.indexOf(this.selectedConfiguration);
            if (index > 1) {
                bottom = index == this.launchers.size() - 1;
                top = index == 2;
            }
        }
        this.upButton.setEnabled(b && !top);
        this.downButton.setEnabled(b && !bottom);
        this.removeButton.setEnabled(b && c);
        this.copyButton.setEnabled(b && c);
        this.launcherNameTextField.setEnabled(b && c);
        this.runTextField.setEnabled(b && c);
        this.buildTextField.setEnabled(b && c);
        this.publicCheckBox.setEnabled(b && c);
        this.hideCheckBox.setEnabled(b && c);
        this.runInOwnTabCheckBox.setEnabled(b && c);
        this.runDirTextField.setEnabled(b);
        this.symbolsTextField.setEnabled(b);
        this.addEnvButton.setEnabled(b);
        this.removeEnvButton.setEnabled(b);
    }

    private void initComponents() {
        this.leftPanel = new JPanel();
        this.launchersListLabel = new JLabel();
        this.addButton = new JButton();
        this.LauncersListPanel = new JPanel();
        this.removeButton = new JButton();
        this.copyButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.rightPanel = new JPanel();
        this.launcherNameLabel = new JLabel();
        this.launcherNameTextField = new JTextField();
        this.runLabel = new JLabel();
        this.buildLabel = new JLabel();
        this.buildTextField = new JTextField();
        this.runDirLabel = new JLabel();
        this.runDirTextField = new JTextField();
        this.symbolLabel = new JLabel();
        this.symbolsTextField = new JTextField();
        this.envLabel = new JLabel();
        this.envVarScrollPane = new JScrollPane();
        this.addEnvButton = new JButton();
        this.removeEnvButton = new JButton();
        this.publicCheckBox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.runTextField = new JTextArea();
        this.hideCheckBox = new JCheckBox();
        this.runInOwnTabCheckBox = new JCheckBox();
        this.launchersListLabel.setLabelFor(this.LauncersListPanel);
        Mnemonics.setLocalizedText((JLabel)this.launchersListLabel, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.launchersListLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LaunchersPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.LauncersListPanel.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        this.LauncersListPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LaunchersPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.copyButton, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.copyButton.text"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LaunchersPanel.this.copyButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.upButton.text"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LaunchersPanel.this.upButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.downButton.text"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LaunchersPanel.this.downButtonActionPerformed(evt);
            }
        });
        GroupLayout leftPanelLayout = new GroupLayout(this.leftPanel);
        this.leftPanel.setLayout(leftPanelLayout);
        leftPanelLayout.setHorizontalGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPanelLayout.createSequentialGroup().addContainerGap().addGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPanelLayout.createSequentialGroup().addComponent(this.launchersListLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(leftPanelLayout.createSequentialGroup().addGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPanelLayout.createSequentialGroup().addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton)).addGroup(leftPanelLayout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyButton).addGap(0, 39, Short.MAX_VALUE)).addComponent(this.LauncersListPanel, -1, -1, Short.MAX_VALUE))));
        leftPanelLayout.setVerticalGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.launchersListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LauncersListPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.removeButton).addComponent(this.copyButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.upButton).addComponent(this.downButton))));
        this.launcherNameLabel.setLabelFor(this.launcherNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.launcherNameLabel, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.launcherNameLabel.text"));
        this.launcherNameLabel.setToolTipText(NbBundle.getMessage(LaunchersPanel.class, (String)"LauncherDisplayNameToolTip"));
        this.launcherNameTextField.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        this.runLabel.setLabelFor(this.runTextField);
        Mnemonics.setLocalizedText((JLabel)this.runLabel, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.runLabel.text"));
        this.runLabel.setToolTipText(NbBundle.getMessage(LaunchersPanel.class, (String)"RunCommandToolTipText"));
        this.buildLabel.setLabelFor(this.buildTextField);
        Mnemonics.setLocalizedText((JLabel)this.buildLabel, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.buildLabel.text"));
        this.buildLabel.setToolTipText(NbBundle.getMessage(LaunchersPanel.class, (String)"BuildCommandToolTip"));
        this.buildTextField.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        this.runDirLabel.setLabelFor(this.runDirTextField);
        Mnemonics.setLocalizedText((JLabel)this.runDirLabel, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.runDirLabel.text"));
        this.runDirLabel.setToolTipText(NbBundle.getMessage(LaunchersPanel.class, (String)"RunDirectoryToolTip"));
        this.runDirTextField.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        this.symbolLabel.setLabelFor(this.symbolsTextField);
        Mnemonics.setLocalizedText((JLabel)this.symbolLabel, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.symbolLabel.text"));
        this.symbolLabel.setToolTipText(NbBundle.getMessage(LaunchersPanel.class, (String)"SymbolFilesToolTip"));
        this.symbolsTextField.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        this.envLabel.setLabelFor(this.envVarScrollPane);
        Mnemonics.setLocalizedText((JLabel)this.envLabel, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.envLabel.text"));
        this.envLabel.setToolTipText(NbBundle.getMessage(LaunchersPanel.class, (String)"EnvToolTip"));
        Mnemonics.setLocalizedText((AbstractButton)this.addEnvButton, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.addEnvButton.text"));
        this.addEnvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LaunchersPanel.this.addEnvButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeEnvButton, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.removeEnvButton.text"));
        this.removeEnvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LaunchersPanel.this.removeEnvButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.publicCheckBox, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.publicCheckBox.text"));
        this.publicCheckBox.setToolTipText(NbBundle.getMessage(LaunchersPanel.class, (String)"PublicToolTip"));
        this.runTextField.setColumns(20);
        this.runTextField.setLineWrap(true);
        this.runTextField.setRows(5);
        this.runTextField.setWrapStyleWord(true);
        this.runTextField.setMinimumSize(new Dimension(360, 17));
        this.jScrollPane1.setViewportView(this.runTextField);
        Mnemonics.setLocalizedText((AbstractButton)this.hideCheckBox, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.hideCheckBox.text"));
        this.hideCheckBox.setToolTipText(NbBundle.getMessage(LaunchersPanel.class, (String)"HideTooltip"));
        Mnemonics.setLocalizedText((AbstractButton)this.runInOwnTabCheckBox, (String)NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.runInOwnTabCheckBox.text"));
        this.runInOwnTabCheckBox.setActionCommand(NbBundle.getMessage(LaunchersPanel.class, (String)"LaunchersPanel.runInOwnTabCheckBox.actionCommand"));
        GroupLayout rightPanelLayout = new GroupLayout(this.rightPanel);
        this.rightPanel.setLayout(rightPanelLayout);
        rightPanelLayout.setHorizontalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPanelLayout.createSequentialGroup().addContainerGap().addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 603, Short.MAX_VALUE).addComponent(this.envVarScrollPane, GroupLayout.Alignment.TRAILING).addGroup(rightPanelLayout.createSequentialGroup().addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.runLabel).addComponent(this.buildLabel).addComponent(this.runDirLabel).addComponent(this.symbolLabel).addComponent(this.launcherNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.launcherNameTextField, -1, -1, Short.MAX_VALUE).addComponent(this.symbolsTextField, -1, -1, Short.MAX_VALUE).addComponent(this.runDirTextField, -1, -1, Short.MAX_VALUE).addComponent(this.buildTextField, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(rightPanelLayout.createSequentialGroup().addComponent(this.envLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(rightPanelLayout.createSequentialGroup().addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.runInOwnTabCheckBox, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, rightPanelLayout.createSequentialGroup().addComponent(this.publicCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.hideCheckBox))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.addEnvButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeEnvButton))).addContainerGap()));
        rightPanelLayout.setVerticalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.launcherNameLabel).addComponent(this.launcherNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runLabel).addGap(3, 3, 3).addComponent(this.jScrollPane1, -1, 93, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buildLabel).addComponent(this.buildTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runDirLabel).addComponent(this.runDirTextField, -2, -1, -2)).addGap(10, 10, 10).addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.symbolLabel).addComponent(this.symbolsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.envLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.envVarScrollPane, -1, 122, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addEnvButton).addComponent(this.removeEnvButton).addComponent(this.publicCheckBox).addComponent(this.hideCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runInOwnTabCheckBox).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.leftPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rightPanel, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rightPanel, -1, -1, Short.MAX_VALUE).addComponent(this.leftPanel, -1, -1, Short.MAX_VALUE));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.updateSelectedConfiguration();
        int max = 1000;
        for (LaunchersConfig.LauncherConfig cfg : this.launchers) {
            if (cfg.getID() < max) continue;
            max = (cfg.getID() + 1000) / 1000;
            max *= 1000;
        }
        LaunchersConfig.LauncherConfig newConfiguration = new LaunchersConfig.LauncherConfig(max, true);
        newConfiguration.setName("launcher" + max);
        newConfiguration.setCommand("\"${PROJECT_DIR}/${OUTPUT_PATH}\"");
        this.launchers.add(newConfiguration);
        this.nodes.restKeys();
        this.selectNode(newConfiguration);
        this.modified = true;
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Node[] selectedNodes = this.manager.getSelectedNodes();
        Node nodeToSelect = null;
        if (selectedNodes.length > 0) {
            int i;
            Node n = selectedNodes[0];
            Node[] nodes = this.manager.getRootContext().getChildren().getNodes();
            for (i = 0; i < nodes.length && nodes[i] != n; ++i) {
            }
            int idx = i + 1;
            if (idx >= nodes.length) {
                idx = i - 1;
            }
            nodeToSelect = idx < 0 ? null : nodes[idx];
        }
        this.launchers.remove(this.getSelectedConfiguration());
        this.nodes.restKeys();
        if (nodeToSelect != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{nodeToSelect});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.modified = true;
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        LaunchersConfig.LauncherConfig newConfiguration;
        this.updateSelectedConfiguration();
        LaunchersConfig.LauncherConfig selectedConfiguration = this.getSelectedConfiguration();
        int index = this.launchers.indexOf(selectedConfiguration);
        if (index == this.launchers.size() - 1) {
            int max = (selectedConfiguration.getID() + 1000) / 1000;
            newConfiguration = selectedConfiguration.copy(max *= 1000);
            this.launchers.add(newConfiguration);
        } else {
            LaunchersConfig.LauncherConfig next = this.launchers.get(index + 1);
            int max = (selectedConfiguration.getID() + next.getID()) / 2;
            newConfiguration = selectedConfiguration.copy(max);
            this.launchers.add(index + 1, newConfiguration);
        }
        this.nodes.restKeys();
        this.selectNode(newConfiguration);
        this.modified = true;
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes.length > 0) {
            this.updateSelectedConfiguration();
            LaunchersConfig.LauncherConfig current = this.getSelectedConfiguration();
            int curIndex = this.launchers.indexOf(current);
            LaunchersConfig.LauncherConfig prev = this.launchers.get(curIndex - 1);
            if (curIndex - 2 > 0) {
                int candidate;
                LaunchersConfig.LauncherConfig prevPrev = this.launchers.get(curIndex - 2);
                int prevIndex = prev.getID();
                int prevPrevIndex = prevPrev.getID();
                if (prevPrevIndex < prevIndex && prevPrevIndex < (candidate = (prevPrevIndex + prevIndex) / 2) && candidate < prevIndex) {
                    current.setID(candidate);
                }
            }
            this.launchers.set(curIndex, prev);
            this.launchers.set(curIndex - 1, current);
            this.nodes.restKeys();
            this.modified = true;
            try {
                this.manager.setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            SwingUtilities.invokeLater(() -> {
                Node[] nodes1 = this.manager.getRootContext().getChildren().getNodes();
                Node nodeToSelect = null;
                for (int i = 0; i < nodes1.length; ++i) {
                    if (nodes1[i].getLookup().lookup(LaunchersConfig.LauncherConfig.class) != current) continue;
                    nodeToSelect = nodes1[i];
                    break;
                }
                if (nodeToSelect != null) {
                    try {
                        this.manager.setSelectedNodes(new Node[]{nodeToSelect});
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes.length > 0) {
            this.updateSelectedConfiguration();
            LaunchersConfig.LauncherConfig current = this.getSelectedConfiguration();
            int curIndex = this.launchers.indexOf(current);
            LaunchersConfig.LauncherConfig next = this.launchers.get(curIndex + 1);
            if (curIndex + 2 < this.launchers.size()) {
                int catndidate;
                int nextNextIndex;
                LaunchersConfig.LauncherConfig nextNext = this.launchers.get(curIndex + 2);
                int nextIndex = next.getID();
                if (nextIndex < (nextNextIndex = nextNext.getID()) && nextIndex < (catndidate = (nextIndex + nextNextIndex) / 2) && catndidate < nextNextIndex) {
                    current.setID(catndidate);
                }
            } else {
                int candidate = (next.getID() + 1000) / 1000;
                current.setID(candidate * 1000);
            }
            this.launchers.set(curIndex, next);
            this.launchers.set(curIndex + 1, current);
            this.nodes.restKeys();
            this.modified = true;
            try {
                this.manager.setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            SwingUtilities.invokeLater(() -> {
                Node[] nodes1 = this.manager.getRootContext().getChildren().getNodes();
                Node nodeToSelect = null;
                for (int i = 0; i < nodes1.length; ++i) {
                    if (nodes1[i].getLookup().lookup(LaunchersConfig.LauncherConfig.class) != current) continue;
                    nodeToSelect = nodes1[i];
                    break;
                }
                if (nodeToSelect != null) {
                    try {
                        this.manager.setSelectedNodes(new Node[]{nodeToSelect});
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    private void reorder(int[] perm) {
        if (perm[0] == 0 && perm[1] == 1) {
            int i;
            this.updateSelectedConfiguration();
            Node[] selectedNodes = this.manager.getSelectedNodes();
            ArrayList<LaunchersConfig.LauncherConfig> copy = new ArrayList<LaunchersConfig.LauncherConfig>(this.launchers);
            for (i = 0; i < perm.length; ++i) {
                this.launchers.set(perm[i], copy.get(i));
            }
            for (i = 2; i < this.launchers.size() - 1; ++i) {
                LaunchersConfig.LauncherConfig prev = this.launchers.get(i - 1);
                LaunchersConfig.LauncherConfig cur = this.launchers.get(i);
                LaunchersConfig.LauncherConfig next = this.launchers.get(i + 1);
                if (prev.getID() < cur.getID() && cur.getID() < next.getID() || prev.getID() >= next.getID()) continue;
                cur.setID((prev.getID() + next.getID()) / 2);
            }
            this.modified = true;
            this.nodes.restKeys();
            try {
                this.manager.setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void addEnvButtonActionPerformed(ActionEvent evt) {
        this.envVarModel.addRow();
    }

    private void removeEnvButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.envVarTable.getSelectedRow();
        if (selectedRow >= 0) {
            this.envVarModel.removeRows(new int[]{selectedRow});
        }
    }

    private void validateEnvButtons(ListSelectionEvent e) {
        int[] selRows = this.envVarTable.getSelectedRows();
        this.removeButton.setEnabled(this.envVarModel.getRowCount() > 0 && selRows != null && selRows.length > 0);
    }

    private static class CompletionPanel {
        private final JList list;
        private final JPopupMenu popupMenu;
        private final int insertionPosition;
        private final JTextComponent texComponent;

        public CompletionPanel(JTextComponent textarea, int position, Point location) {
            this.insertionPosition = position;
            this.texComponent = textarea;
            this.list = this.createSuggestionList();
            this.popupMenu = new JPopupMenu(){

                @Override
                public void requestFocus() {
                    list.requestFocus();
                }

                @Override
                public boolean requestFocusInWindow() {
                    return list.requestFocusInWindow();
                }
            };
            this.popupMenu.removeAll();
            this.popupMenu.setOpaque(false);
            this.popupMenu.setBorder(null);
            this.popupMenu.add((Component)this.list, "Center");
            int baseLine = this.texComponent.getBaseline(0, 0);
            if (baseLine < 0) {
                baseLine = this.texComponent.getHeight();
            }
            this.popupMenu.show(this.texComponent, location.x, baseLine + location.y);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popupMenu.requestFocus();
                    popupMenu.requestFocusInWindow();
                }
            });
        }

        private JList createSuggestionList() {
            String text = NbBundle.getMessage(LaunchersPanel.class, (String)"CompletionListText");
            String[] data = text.split("\n");
            JList<String> list = new JList<String>(data);
            list.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1));
            list.setSelectionMode(0);
            list.setSelectedIndex(0);
            list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        this.insertSelection();
                        e.consume();
                    }
                }
            });
            list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        this.insertSelection();
                        e.consume();
                    } else if (e.getKeyCode() == 27) {
                        this.hide();
                        e.consume();
                    }
                }
            });
            return list;
        }

        private void hide() {
            this.popupMenu.setVisible(false);
        }

        private void insertSelection() {
            this.hide();
            if (this.list.getSelectedValue() != null) {
                try {
                    String selection = (String)this.list.getSelectedValue();
                    String selectedSuggestion = selection.substring(0, selection.indexOf(32));
                    this.texComponent.getDocument().insertString(this.insertionPosition, selectedSuggestion, null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace(System.err);
                }
            }
        }
    }

    private class CompletionAction
    extends AbstractAction {
        private final JTextComponent textComponent;

        private CompletionAction(JTextComponent runTextField) {
            this.textComponent = runTextField;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Point location;
            int position = this.textComponent.getCaretPosition();
            try {
                location = this.textComponent.modelToView(position).getLocation();
            }
            catch (BadLocationException e2) {
                e2.printStackTrace(System.err);
                return;
            }
            String text = this.textComponent.getText();
            CompletionPanel suggestion = new CompletionPanel(this.textComponent, position, location);
        }
    }

    private final class RootNode
    extends AbstractNode
    implements Index {
        private RootNode(Children nodes) {
            super(nodes);
            this.getCookieSet().add((Node.Cookie)this);
        }

        public int getNodesCount() {
            return this.getChildren().getNodesCount();
        }

        public Node[] getNodes() {
            return this.getChildren().getNodes();
        }

        public int indexOf(Node node) {
            int i = 0;
            for (Node n : this.getChildren().getNodes()) {
                if (n == node) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void reorder() {
        }

        public void reorder(int[] perm) {
            LaunchersPanel.this.reorder(perm);
        }

        public void move(int x, int y) {
        }

        public void exchange(int x, int y) {
        }

        public void moveUp(int x) {
        }

        public void moveDown(int x) {
        }

        public void addChangeListener(ChangeListener chl) {
        }

        public void removeChangeListener(ChangeListener chl) {
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private static final class LaunchersNodes
    extends Children.Keys<LaunchersConfig.LauncherConfig> {
        private final ArrayList<LaunchersConfig.LauncherConfig> launcers;

        private LaunchersNodes(ArrayList<LaunchersConfig.LauncherConfig> launcers) {
            this.launcers = launcers;
            this.setKeys(launcers);
        }

        public void restKeys() {
            this.setKeys(this.launcers);
        }

        protected Node[] createNodes(LaunchersConfig.LauncherConfig key) {
            return new LauncherNode[]{new LauncherNode(key)};
        }
    }

    private static final class LauncherNode
    extends AbstractNode {
        private Image icon;
        private static JTextField test = new JTextField();
        private String name;
        private String command;
        private boolean pub;
        private boolean hide;
        private int id;

        private LauncherNode(LaunchersConfig.LauncherConfig cfg) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{cfg}));
            this.name = cfg.getDisplayedName();
            this.hide = cfg.isHide();
            this.command = cfg.getCommand();
            this.pub = cfg.getPublic();
            this.id = cfg.getID();
            this.updateIcon();
        }

        private void updateIcon() {
            String resources = "org/netbeans/modules/cnd/makeproject/ui/launchers/actions/resources/";
            String iconFile = this.id >= 0 ? (this.pub ? "launcher_public.png" : "launcher_private.png") : (this.pub ? "common_public.png" : "common_private.png");
            this.icon = ImageUtilities.icon2Image((Icon)ImageUtilities.loadImageIcon((String)("org/netbeans/modules/cnd/makeproject/ui/launchers/actions/resources/" + iconFile), (boolean)false));
        }

        public LaunchersConfig.LauncherConfig getConfiguration() {
            return (LaunchersConfig.LauncherConfig)this.getLookup().lookup(LaunchersConfig.LauncherConfig.class);
        }

        public Image getOpenedIcon(int type) {
            return this.icon;
        }

        public void updateNode(String name, String command, boolean pub, boolean hide) {
            this.name = name;
            this.command = command;
            this.pub = pub;
            this.hide = hide;
            this.fireDisplayNameChange(null, this.getDisplayName());
            this.updateIcon();
            this.fireIconChange();
        }

        public Image getIcon(int type) {
            return this.icon;
        }

        public String getHtmlDisplayName() {
            if (this.hide || this.id < 0) {
                return "<font color='!textInactiveText'>" + this.getDisplayName() + "</font>";
            }
            return super.getHtmlDisplayName();
        }

        public String getDisplayName() {
            if (this.id < 0) {
                return NbBundle.getMessage(LaunchersPanel.class, (String)"COMMON_PROPERTIES");
            }
            String res = this.name;
            if (res == null || res.isEmpty()) {
                res = this.command;
            }
            return res;
        }

        public boolean canCut() {
            return this.id >= 0;
        }

        public boolean canCopy() {
            return this.id >= 0;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private final class SelectionChangeListener
    implements PropertyChangeListener {
        private SelectionChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                LaunchersPanel.this.updateSelectedConfiguration();
                LaunchersPanel.this.selectedConfiguration = LaunchersPanel.this.getSelectedConfiguration();
                LaunchersPanel.this.resetFields = true;
                this.setContent(LaunchersPanel.this.selectedConfiguration);
                LaunchersPanel.this.resetFields = false;
                LaunchersPanel.this.enableControls();
            }
        }

        private void setContent(LaunchersConfig.LauncherConfig cfg) {
            int n;
            LaunchersPanel.this.launcherNameTextField.setText(cfg == null ? null : cfg.getName());
            LaunchersPanel.this.runTextField.setText(cfg == null ? null : cfg.getCommand());
            LaunchersPanel.this.runTextField.setCaretPosition(0);
            LaunchersPanel.this.runDirTextField.setText(cfg == null ? null : cfg.getRunDir());
            LaunchersPanel.this.buildTextField.setText(cfg == null ? null : cfg.getBuildCommand());
            LaunchersPanel.this.symbolsTextField.setText(cfg == null ? null : cfg.getSymbolFiles());
            LaunchersPanel.this.publicCheckBox.setSelected(cfg == null ? false : cfg.getPublic());
            LaunchersPanel.this.hideCheckBox.setSelected(cfg == null ? false : cfg.isHide() || cfg.getID() < 0);
            LaunchersPanel.this.runInOwnTabCheckBox.setSelected(cfg == null ? false : cfg.runInOwnTab() || cfg.getID() < 0);
            ArrayList<String> col0 = new ArrayList<String>();
            ArrayList<String> col1 = new ArrayList<String>();
            if (cfg != null) {
                for (Map.Entry<String, String> e : cfg.getEnv().entrySet()) {
                    col0.add(e.getKey());
                    col1.add(e.getValue());
                }
                n = cfg.getEnv().size();
            } else {
                n = 0;
            }
            LaunchersPanel.this.envVarModel.setData(n, col0, col1);
            LaunchersPanel.this.envVarTable.tableChanged(null);
        }
    }

    private static class BeanTreeViewImpl
    extends BeanTreeView {
        public void setPreferredSize(Dimension preferredSize) {
        }

        public void setRootVisible(boolean visible) {
            super.setRootVisible(visible);
            this.tree.setShowsRootHandles(visible);
        }
    }
}

