/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.j2ee.weblogic9.ProgressObjectSupport;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasource;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasourceSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.CommandBasedDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class WLDatasourceManager
implements DatasourceManager {
    private static final Version JAVA_EE7_SERVER_VERSION = Version.fromJsr277NotationWithFallback((String)"12.2.1");
    private static final String JAVA_EE_7_DEFAULT_DATASOURCE = "java:comp/DefaultDataSource";
    private static final Logger LOGGER = Logger.getLogger(WLDatasourceManager.class.getName());
    private final WLDeploymentManager manager;

    public WLDatasourceManager(WLDeploymentManager manager) {
        this.manager = manager;
    }

    public void deployDatasources(Set<Datasource> datasources) throws ConfigurationException, DatasourceAlreadyExistsException {
        Set<Datasource> deployedDatasources = this.getDatasources();
        Map<String, Datasource> deployed = this.createMap(deployedDatasources);
        HashMap<String, WLDatasource> toDeploy = new HashMap<String, WLDatasource>();
        LinkedList<Datasource> conflictDS = new LinkedList<Datasource>();
        for (Datasource datasource : datasources) {
            if (!(datasource instanceof WLDatasource)) {
                LOGGER.log(Level.INFO, "Unable to deploy {0}", datasource);
                continue;
            }
            WLDatasource wlDatasource = (WLDatasource)datasource;
            String jndiName = wlDatasource.getJndiName();
            if (deployed.keySet().contains(jndiName)) {
                Datasource deployedDatasource = deployed.get(jndiName);
                if (deployed.get(jndiName).equals(wlDatasource)) continue;
                if (!((WLDatasource)deployedDatasource).isSystem() && !wlDatasource.isSystem()) {
                    toDeploy.put(jndiName, wlDatasource);
                    continue;
                }
                conflictDS.add(deployed.get(jndiName));
                continue;
            }
            if (jndiName != null) {
                toDeploy.put(jndiName, wlDatasource);
                continue;
            }
            LOGGER.log(Level.INFO, "JNDI name was null for {0}", datasource);
        }
        if (!conflictDS.isEmpty()) {
            throw new DatasourceAlreadyExistsException(conflictDS);
        }
        CommandBasedDeployer deployer = new CommandBasedDeployer(this.manager);
        ProgressObject po = deployer.deployDatasource(toDeploy.values(), this.manager.getDeployTargets());
        if (!ProgressObjectSupport.waitFor(po) || po.getDeploymentStatus().isFailed()) {
            String msg = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_FailedToDeployDatasource", (Object)po.getDeploymentStatus().getMessage());
            throw new ConfigurationException(msg);
        }
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        HashSet<Datasource> ret;
        if (this.manager.isRemote()) {
            try {
                ret = new HashSet<Datasource>((Collection)this.manager.getConnectionSupport().executeAction(new WLConnectionSupport.JMXRuntimeAction<Set<WLDatasource>>(){

                    @Override
                    public Set<WLDatasource> call(MBeanServerConnection connection, ObjectName service) throws Exception {
                        return WLDatasourceSupport.getSystemDatasources(connection, service);
                    }
                }));
            }
            catch (Exception ex) {
                if (ex instanceof ConfigurationException) {
                    throw (ConfigurationException)((Object)ex);
                }
                throw new ConfigurationException("Datasource fetch failed", (Throwable)ex);
            }
        } else {
            String domainDir = this.manager.getInstanceProperties().getProperty("domainRoot");
            File domainPath = FileUtil.normalizeFile((File)new File(domainDir));
            FileObject domain = FileUtil.toFileObject((File)domainPath);
            FileObject domainConfig = null;
            if (domain != null) {
                domainConfig = domain.getFileObject("config/config.xml");
            }
            ret = new HashSet<WLDatasource>(WLDatasourceSupport.getDatasources(domainPath, domainConfig, true));
            this.addDefaultDataSource(ret);
        }
        return ret;
    }

    private Map<String, Datasource> createMap(Set<Datasource> datasources) {
        if (datasources.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Datasource> map = new HashMap<String, Datasource>();
        for (Datasource datasource : datasources) {
            map.put(datasource.getJndiName(), datasource);
        }
        return map;
    }

    private void addDefaultDataSource(Set<Datasource> datasources) {
        File file;
        File derby;
        for (Datasource ds : datasources) {
            if (!JAVA_EE_7_DEFAULT_DATASOURCE.equals(ds.getJndiName())) continue;
            return;
        }
        Version version = this.manager.getServerVersion();
        if (version != null && version.isAboveOrEqual(JAVA_EE7_SERVER_VERSION) && (derby = new File(file = WLPluginProperties.getServerRoot(this.manager, false), "common" + File.separatorChar + "derby")).isDirectory()) {
            datasources.add(new WLDatasource(JAVA_EE_7_DEFAULT_DATASOURCE, "jdbc:derby://localhost:1527/DefaultDataSource", JAVA_EE_7_DEFAULT_DATASOURCE, "app", "app", "org.apache.derby.jdbc.ClientDriver", null, true));
        }
    }
}

