/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend;

import org.clang.frontend.impl.LangStandardsStatics;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public class LangStandard {
    public char.ptr ShortName;
    public char.ptr Description;
    public int Flags;

    public char.ptr getName() {
        return this.ShortName;
    }

    public char.ptr getDescription() {
        return this.Description;
    }

    public boolean hasLineComments() {
        return (this.Flags & 1) != 0;
    }

    public boolean isC89() {
        return (this.Flags & 2) != 0;
    }

    public boolean isC99() {
        return (this.Flags & 4) != 0;
    }

    public boolean isC11() {
        return (this.Flags & 8) != 0;
    }

    public boolean isCPlusPlus() {
        return (this.Flags & 0x10) != 0;
    }

    public boolean isCPlusPlus11() {
        return (this.Flags & 0x20) != 0;
    }

    public boolean isCPlusPlus14() {
        return (this.Flags & 0x40) != 0;
    }

    public boolean isCPlusPlus1z() {
        return (this.Flags & 0x80) != 0;
    }

    public boolean hasDigraphs() {
        return (this.Flags & 0x100) != 0;
    }

    public boolean isGNUMode() {
        return (this.Flags & 0x200) != 0;
    }

    public boolean hasHexFloats() {
        return (this.Flags & 0x400) != 0;
    }

    public boolean hasImplicitInt() {
        return (this.Flags & 0x800) != 0;
    }

    public static LangStandard getLangStandardForKind(Kind K) {
        switch (K) {
            case lang_unspecified: {
                llvm.report_fatal_error((char.ptr)NativePointer.$((String)"getLangStandardForKind() on unspecified kind"));
            }
            case lang_c89: {
                return LangStandardsStatics.Lang_c89;
            }
            case lang_c90: {
                return LangStandardsStatics.Lang_c90;
            }
            case lang_iso9899_1990: {
                return LangStandardsStatics.Lang_iso9899_1990;
            }
            case lang_c94: {
                return LangStandardsStatics.Lang_c94;
            }
            case lang_gnu89: {
                return LangStandardsStatics.Lang_gnu89;
            }
            case lang_gnu90: {
                return LangStandardsStatics.Lang_gnu90;
            }
            case lang_c99: {
                return LangStandardsStatics.Lang_c99;
            }
            case lang_c9x: {
                return LangStandardsStatics.Lang_c9x;
            }
            case lang_iso9899_1999: {
                return LangStandardsStatics.Lang_iso9899_1999;
            }
            case lang_iso9899_199x: {
                return LangStandardsStatics.Lang_iso9899_199x;
            }
            case lang_gnu99: {
                return LangStandardsStatics.Lang_gnu99;
            }
            case lang_gnu9x: {
                return LangStandardsStatics.Lang_gnu9x;
            }
            case lang_c11: {
                return LangStandardsStatics.Lang_c11;
            }
            case lang_c1x: {
                return LangStandardsStatics.Lang_c1x;
            }
            case lang_iso9899_2011: {
                return LangStandardsStatics.Lang_iso9899_2011;
            }
            case lang_iso9899_201x: {
                return LangStandardsStatics.Lang_iso9899_201x;
            }
            case lang_gnu11: {
                return LangStandardsStatics.Lang_gnu11;
            }
            case lang_gnu1x: {
                return LangStandardsStatics.Lang_gnu1x;
            }
            case lang_cxx98: {
                return LangStandardsStatics.Lang_cxx98;
            }
            case lang_cxx03: {
                return LangStandardsStatics.Lang_cxx03;
            }
            case lang_gnucxx98: {
                return LangStandardsStatics.Lang_gnucxx98;
            }
            case lang_cxx0x: {
                return LangStandardsStatics.Lang_cxx0x;
            }
            case lang_cxx11: {
                return LangStandardsStatics.Lang_cxx11;
            }
            case lang_gnucxx0x: {
                return LangStandardsStatics.Lang_gnucxx0x;
            }
            case lang_gnucxx11: {
                return LangStandardsStatics.Lang_gnucxx11;
            }
            case lang_cxx1y: {
                return LangStandardsStatics.Lang_cxx1y;
            }
            case lang_cxx14: {
                return LangStandardsStatics.Lang_cxx14;
            }
            case lang_gnucxx1y: {
                return LangStandardsStatics.Lang_gnucxx1y;
            }
            case lang_gnucxx14: {
                return LangStandardsStatics.Lang_gnucxx14;
            }
            case lang_cxx1z: {
                return LangStandardsStatics.Lang_cxx1z;
            }
            case lang_gnucxx1z: {
                return LangStandardsStatics.Lang_gnucxx1z;
            }
            case lang_opencl: {
                return LangStandardsStatics.Lang_opencl;
            }
            case lang_opencl11: {
                return LangStandardsStatics.Lang_opencl11;
            }
            case lang_opencl12: {
                return LangStandardsStatics.Lang_opencl12;
            }
            case lang_opencl20: {
                return LangStandardsStatics.Lang_opencl20;
            }
            case lang_cuda: {
                return LangStandardsStatics.Lang_cuda;
            }
        }
        throw new llvm_unreachable("Invalid language kind!");
    }

    public static LangStandard getLangStandardForName(StringRef Name) {
        Kind K = (Kind)((Object)new StringSwitch(Name).Case("c89", (Object)Kind.lang_c89).Case("c90", (Object)Kind.lang_c90).Case("iso9899:1990", (Object)Kind.lang_iso9899_1990).Case("iso9899:199409", (Object)Kind.lang_c94).Case("gnu89", (Object)Kind.lang_gnu89).Case("gnu90", (Object)Kind.lang_gnu90).Case("c99", (Object)Kind.lang_c99).Case("c9x", (Object)Kind.lang_c9x).Case("iso9899:1999", (Object)Kind.lang_iso9899_1999).Case("iso9899:199x", (Object)Kind.lang_iso9899_199x).Case("gnu99", (Object)Kind.lang_gnu99).Case("gnu9x", (Object)Kind.lang_gnu9x).Case("c11", (Object)Kind.lang_c11).Case("c1x", (Object)Kind.lang_c1x).Case("iso9899:2011", (Object)Kind.lang_iso9899_2011).Case("iso9899:2011", (Object)Kind.lang_iso9899_201x).Case("gnu11", (Object)Kind.lang_gnu11).Case("gnu1x", (Object)Kind.lang_gnu1x).Case("c++98", (Object)Kind.lang_cxx98).Case("c++03", (Object)Kind.lang_cxx03).Case("gnu++98", (Object)Kind.lang_gnucxx98).Case("c++0x", (Object)Kind.lang_cxx0x).Case("c++11", (Object)Kind.lang_cxx11).Case("gnu++0x", (Object)Kind.lang_gnucxx0x).Case("gnu++11", (Object)Kind.lang_gnucxx11).Case("c++1y", (Object)Kind.lang_cxx1y).Case("c++14", (Object)Kind.lang_cxx14).Case("gnu++1y", (Object)Kind.lang_gnucxx1y).Case("gnu++14", (Object)Kind.lang_gnucxx14).Case("c++1z", (Object)Kind.lang_cxx1z).Case("gnu++1z", (Object)Kind.lang_gnucxx1z).Case("cl", (Object)Kind.lang_opencl).Case("CL1.1", (Object)Kind.lang_opencl11).Case("CL1.2", (Object)Kind.lang_opencl12).Case("CL2.0", (Object)Kind.lang_opencl20).Case("cuda", (Object)Kind.lang_cuda).Default((Object)Kind.lang_unspecified));
        if (K == Kind.lang_unspecified) {
            return null;
        }
        return LangStandard.getLangStandardForKind(K);
    }

    public LangStandard(String ShortName, String Description, int Flags2) {
        this(NativePointer.create_char$ptr((CharSequence)ShortName), NativePointer.create_char$ptr((CharSequence)Description), Flags2);
    }

    public LangStandard(char.ptr ShortName, char.ptr Description, int Flags2) {
        this.ShortName = Native.$tryConstClone((char.ptr)ShortName);
        this.Description = Native.$tryConstClone((char.ptr)Description);
        this.Flags = Flags2;
    }

    public String toString() {
        return "ShortName=" + this.ShortName + ", Description=" + this.Description + ", Flags=" + this.Flags;
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind lang_c89 = new Kind(0);
        public static final /* enum */ Kind lang_c90 = new Kind(lang_c89.getValue() + 1);
        public static final /* enum */ Kind lang_iso9899_1990 = new Kind(lang_c90.getValue() + 1);
        public static final /* enum */ Kind lang_c94 = new Kind(lang_iso9899_1990.getValue() + 1);
        public static final /* enum */ Kind lang_gnu89 = new Kind(lang_c94.getValue() + 1);
        public static final /* enum */ Kind lang_gnu90 = new Kind(lang_gnu89.getValue() + 1);
        public static final /* enum */ Kind lang_c99 = new Kind(lang_gnu90.getValue() + 1);
        public static final /* enum */ Kind lang_c9x = new Kind(lang_c99.getValue() + 1);
        public static final /* enum */ Kind lang_iso9899_1999 = new Kind(lang_c9x.getValue() + 1);
        public static final /* enum */ Kind lang_iso9899_199x = new Kind(lang_iso9899_1999.getValue() + 1);
        public static final /* enum */ Kind lang_gnu99 = new Kind(lang_iso9899_199x.getValue() + 1);
        public static final /* enum */ Kind lang_gnu9x = new Kind(lang_gnu99.getValue() + 1);
        public static final /* enum */ Kind lang_c11 = new Kind(lang_gnu9x.getValue() + 1);
        public static final /* enum */ Kind lang_c1x = new Kind(lang_c11.getValue() + 1);
        public static final /* enum */ Kind lang_iso9899_2011 = new Kind(lang_c1x.getValue() + 1);
        public static final /* enum */ Kind lang_iso9899_201x = new Kind(lang_iso9899_2011.getValue() + 1);
        public static final /* enum */ Kind lang_gnu11 = new Kind(lang_iso9899_201x.getValue() + 1);
        public static final /* enum */ Kind lang_gnu1x = new Kind(lang_gnu11.getValue() + 1);
        public static final /* enum */ Kind lang_cxx98 = new Kind(lang_gnu1x.getValue() + 1);
        public static final /* enum */ Kind lang_cxx03 = new Kind(lang_cxx98.getValue() + 1);
        public static final /* enum */ Kind lang_gnucxx98 = new Kind(lang_cxx03.getValue() + 1);
        public static final /* enum */ Kind lang_cxx0x = new Kind(lang_gnucxx98.getValue() + 1);
        public static final /* enum */ Kind lang_cxx11 = new Kind(lang_cxx0x.getValue() + 1);
        public static final /* enum */ Kind lang_gnucxx0x = new Kind(lang_cxx11.getValue() + 1);
        public static final /* enum */ Kind lang_gnucxx11 = new Kind(lang_gnucxx0x.getValue() + 1);
        public static final /* enum */ Kind lang_cxx1y = new Kind(lang_gnucxx11.getValue() + 1);
        public static final /* enum */ Kind lang_cxx14 = new Kind(lang_cxx1y.getValue() + 1);
        public static final /* enum */ Kind lang_gnucxx1y = new Kind(lang_cxx14.getValue() + 1);
        public static final /* enum */ Kind lang_gnucxx14 = new Kind(lang_gnucxx1y.getValue() + 1);
        public static final /* enum */ Kind lang_cxx1z = new Kind(lang_gnucxx14.getValue() + 1);
        public static final /* enum */ Kind lang_gnucxx1z = new Kind(lang_cxx1z.getValue() + 1);
        public static final /* enum */ Kind lang_opencl = new Kind(lang_gnucxx1z.getValue() + 1);
        public static final /* enum */ Kind lang_opencl11 = new Kind(lang_opencl.getValue() + 1);
        public static final /* enum */ Kind lang_opencl12 = new Kind(lang_opencl11.getValue() + 1);
        public static final /* enum */ Kind lang_opencl20 = new Kind(lang_opencl12.getValue() + 1);
        public static final /* enum */ Kind lang_cuda = new Kind(lang_opencl20.getValue() + 1);
        public static final /* enum */ Kind lang_unspecified = new Kind(lang_cuda.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        public static Kind valueOf(int val) {
            Kind out;
            Kind kind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Kind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Kind[]{lang_c89, lang_c90, lang_iso9899_1990, lang_c94, lang_gnu89, lang_gnu90, lang_c99, lang_c9x, lang_iso9899_1999, lang_iso9899_199x, lang_gnu99, lang_gnu9x, lang_c11, lang_c1x, lang_iso9899_2011, lang_iso9899_201x, lang_gnu11, lang_gnu1x, lang_cxx98, lang_cxx03, lang_gnucxx98, lang_cxx0x, lang_cxx11, lang_gnucxx0x, lang_gnucxx11, lang_cxx1y, lang_cxx14, lang_gnucxx1y, lang_gnucxx14, lang_cxx1z, lang_gnucxx1z, lang_opencl, lang_opencl11, lang_opencl12, lang_opencl20, lang_cuda, lang_unspecified};
        }

        private static final class Values {
            private static final Kind[] VALUES;
            private static final Kind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Kind kind : Kind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Kind[min < 0 ? 1 - min : 0];
                VALUES = new Kind[max >= 0 ? 1 + max : 0];
                for (Kind kind : Kind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Kind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Kind)kind).value] = kind;
                }
            }
        }
    }
}

