/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Image;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.netbeans.modules.web.monitor.client.DeleteAction;
import org.netbeans.modules.web.monitor.client.EditReplayAction;
import org.netbeans.modules.web.monitor.client.ReplayAction;
import org.netbeans.modules.web.monitor.client.SaveAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

public class TransactionNode
extends AbstractNode {
    String id;
    String method;
    String uri;
    String name = null;
    String timestamp = null;
    boolean current;
    private int statusCode;
    static boolean showTimeStamp = true;

    public TransactionNode(String id, String method, String uri, boolean current, int statusCode) {
        super(Children.LEAF);
        this.id = id;
        this.method = method;
        this.uri = uri;
        this.current = current;
        this.statusCode = statusCode;
        this.setProperties();
    }

    public TransactionNode(String id, String method, String uri, Children ch, boolean current, int statusCode) {
        super(ch);
        this.id = id;
        this.method = method;
        this.uri = uri;
        this.current = current;
        this.statusCode = statusCode;
        this.setProperties();
    }

    public String getLongName() {
        StringBuffer buf = new StringBuffer(this.method);
        buf.append(" ");
        buf.append(this.uri);
        if (this.timestamp == null) {
            this.setTimeStamp();
        }
        buf.append(" ");
        buf.append(this.timestamp);
        return buf.toString();
    }

    public Image getIcon(int type) {
        Image badge;
        Image base = this.method.equals("GET") ? ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/get.gif") : (this.method.equals("POST") ? ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/post.gif") : ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/other.gif"));
        if (this.statusCode >= 400 || this.statusCode < 0) {
            badge = ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/infoBadge.gif");
        } else if (this.statusCode >= 300) {
            badge = ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/warningBadge.gif");
        } else {
            if (this.statusCode >= 200) {
                return base;
            }
            badge = ImageUtilities.loadImage((String)"org/netbeans/modules/web/monitor/client/icons/errorBadge.gif");
        }
        return ImageUtilities.mergeImages((Image)base, (Image)badge, (int)0, (int)0);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getID() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean b) {
        this.current = b;
    }

    protected SystemAction[] createActions() {
        if (this.current) {
            return new SystemAction[]{SystemAction.get((Class)SaveAction.class), null, SystemAction.get((Class)ReplayAction.class), SystemAction.get((Class)EditReplayAction.class), null, SystemAction.get((Class)DeleteAction.class)};
        }
        return new SystemAction[]{SystemAction.get((Class)ReplayAction.class), SystemAction.get((Class)EditReplayAction.class), null, SystemAction.get((Class)DeleteAction.class)};
    }

    public SystemAction[] getActions() {
        if (this.current) {
            return new SystemAction[]{SystemAction.get((Class)SaveAction.class), null, SystemAction.get((Class)ReplayAction.class), SystemAction.get((Class)EditReplayAction.class), null, SystemAction.get((Class)DeleteAction.class)};
        }
        return new SystemAction[]{SystemAction.get((Class)ReplayAction.class), SystemAction.get((Class)EditReplayAction.class), null, SystemAction.get((Class)DeleteAction.class)};
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return false;
    }

    public static void toggleTimeStamp() {
        showTimeStamp = !showTimeStamp;
    }

    public static boolean showTimeStamp() {
        return showTimeStamp;
    }

    private void setProperties() {
        this.setNameString();
        this.setShortDescription(this.uri);
    }

    public void setNameString() {
        String name = null;
        if (this.uri.equals("/")) {
            name = this.uri;
        } else {
            StringTokenizer st = new StringTokenizer(this.uri, "/");
            while (st.hasMoreTokens()) {
                name = st.nextToken();
            }
        }
        StringBuilder buf = new StringBuilder(this.method);
        buf.append(' ');
        buf.append(name);
        if (showTimeStamp) {
            if (this.timestamp == null) {
                this.setTimeStamp();
            }
            buf.append(' ');
            buf.append(this.timestamp);
        }
        this.setName(buf.toString());
    }

    private void setTimeStamp() {
        try {
            long ldate = Long.valueOf(this.id);
            Date date = new Date(ldate);
            StringBuilder buf = new StringBuilder(91);
            DateFormat df = DateFormat.getTimeInstance(3);
            buf.append(df.format(date));
            buf.append(" ");
            df = DateFormat.getDateInstance(3);
            buf.append(df.format(date));
            buf.append(']');
            this.timestamp = buf.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("TransactionNode: ");
        buf.append(this.getName());
        buf.append('\n');
        buf.append("id=");
        buf.append(this.id);
        buf.append('\n');
        buf.append("method=");
        buf.append(this.method);
        buf.append('\n');
        buf.append("uri=");
        buf.append(this.uri);
        buf.append('\n');
        buf.append("current=");
        buf.append(String.valueOf(this.current));
        buf.append('\n');
        return buf.toString();
    }
}

