/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs.server;

import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.HangupEnvList;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.server.Buffer;
import org.netbeans.modules.remote.impl.fs.server.Disposer;
import org.netbeans.modules.remote.impl.fs.server.FSSDispatcher;
import org.netbeans.modules.remote.impl.fs.server.FSSRequest;
import org.netbeans.modules.remote.impl.fs.server.FSSRequestKind;
import org.netbeans.modules.remote.impl.fs.server.FSSResponseKind;
import org.netbeans.modules.remote.impl.fs.server.FSSTransport;
import org.openide.util.NotImplementedException;

final class FSSResponse {
    private final int requestId;
    private final FSSRequestKind requestKind;
    private final String requestPath;
    private final Disposer<FSSResponse> disposer;
    private final Listener listener;
    private final ExecutionEnvironment env;
    private final Object lock = new Object();
    private final LinkedList<Package> packages = new LinkedList();
    private ExecutionException exception = null;

    public FSSResponse(FSSRequest request, Disposer<FSSResponse> disposer, Listener listener, ExecutionEnvironment env) {
        this.requestId = request.getId();
        this.requestKind = request.getKind();
        this.requestPath = request.getPath();
        this.disposer = disposer;
        this.listener = listener;
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPackages() {
        Object object = this.lock;
        synchronized (object) {
            return !this.packages.isEmpty();
        }
    }

    public int getId() {
        return this.requestId;
    }

    public Package getNextPackage() throws TimeoutException, InterruptedException, ExecutionException {
        if (RemoteFileSystemUtils.isUnitTestMode()) {
            long timeout = Integer.getInteger("remote.fs_server.timeout", 30000).intValue();
            if (HangupEnvList.isHung(this.env)) {
                throw new IllegalStateException("Rejected: timeout on previous attempt get package from " + this.env);
            }
            try {
                return this.getNextPackage(timeout);
            }
            catch (TimeoutException ex) {
                HangupEnvList.setHung(this.env);
                String errText = "Timeout: can't get package at " + this.env + " for request #" + this.requestId + ' ' + this.requestKind.getChar() + ' ' + this.requestPath + " in " + timeout + " ms";
                FSSDispatcher.getInstance(this.env).testDump(System.err);
                throw new IllegalStateException(errText);
            }
        }
        return this.getNextPackage(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Package getNextPackage(long timeToWait) throws TimeoutException, InterruptedException, ExecutionException {
        if (timeToWait == 0L) {
            timeToWait = FSSTransport.DEFAULT_TIMEOUT;
        }
        long timeElapsed = 0L;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exception != null) {
                    throw this.exception;
                }
                if (this.packages.isEmpty()) {
                    if (timeToWait == 0L) {
                        this.lock.wait();
                    } else {
                        long timeout = timeToWait - timeElapsed;
                        if (timeout <= 0L) {
                            throw this.createTimeoutException(timeToWait);
                        }
                        long curr = System.currentTimeMillis();
                        this.lock.wait(timeout);
                        timeElapsed += System.currentTimeMillis() - curr;
                    }
                } else {
                    return this.packages.pollFirst();
                }
            }
        }
    }

    private TimeoutException createTimeoutException(long timeoutMillis) {
        String message = String.format("Timeout %d ms getting responce for %s on %s:%s", new Object[]{timeoutMillis, this.requestKind, this.env, this.requestPath});
        return new TimeoutException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Package tryGetNextPackage() throws ExecutionException {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exception != null) {
                    throw this.exception;
                }
                if (!this.packages.isEmpty()) {
                    return this.packages.pollFirst();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(FSSResponseKind kind, String data) {
        Package pkg = new Package(kind, data);
        Object object = this.lock;
        synchronized (object) {
            this.packages.addLast(pkg);
            this.lock.notifyAll();
        }
        if (this.listener != null) {
            this.listener.packageAdded(pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(ExecutionException exception) {
        Object object = this.lock;
        synchronized (object) {
            this.exception = exception;
            this.lock.notifyAll();
        }
    }

    public void cancel() {
        new NotImplementedException().printStackTrace(System.err);
    }

    void dispose() {
        this.disposer.dispose(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + (Object)((Object)this.requestKind) + " #" + this.requestId + ' ' + this.requestPath + " pkg.count=" + this.packages.size();
    }

    public static interface Listener {
        public void packageAdded(Package var1);
    }

    public static class Package {
        private final FSSResponseKind kind;
        private final String data;

        public Package(FSSResponseKind kind, String data) {
            this.kind = kind;
            this.data = data;
        }

        public FSSResponseKind getKind() {
            return this.kind;
        }

        public String getData() {
            return this.data;
        }

        public Buffer getBuffer() {
            return new Buffer(this.data);
        }

        public String toString() {
            return this.getClass().getSimpleName() + '[' + (Object)((Object)this.kind) + ' ' + this.data + ']';
        }
    }
}

