/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfAbbriviationTable;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfAbbriviationTableEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoTable;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfNameLookupTable;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfStatementList;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATTR;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.FORM;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfAbbriviationTableSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfAttribute;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfLineInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfMacroInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfNameLookupTableSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfRelaDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.StringTableSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnit
implements CompilationUnitInterface {
    private final DwarfReader reader;
    private final long debugInfoSectionOffset;
    public final long unit_offset;
    private long unit_length;
    private long unit_total_length;
    private int version;
    private long debug_abbrev_offset;
    private byte address_size;
    private DwarfEntry root = null;
    private DwarfAbbriviationTable abbr_table = null;
    private DwarfStatementList statement_list = null;
    private DwarfLineInfoSection lineInfoSection = null;
    private DwarfMacinfoTable macrosTable = null;
    private DwarfNameLookupTable pubnamesTable = null;
    private DwarfRelaDebugInfoSection rela = null;
    private long debugInfoOffset;
    private final Map<Long, Long> specifications = new HashMap<Long, Long>();
    private final Map<Long, DwarfEntry> entries = new HashMap<Long, DwarfEntry>();

    public CompilationUnit(DwarfReader reader, long sectionOffset, long unitOffset) throws IOException {
        this.reader = reader;
        this.debugInfoSectionOffset = sectionOffset;
        this.unit_offset = unitOffset;
        this.readCompilationUnitHeader();
        this.root = this.getDebugInfo(false);
    }

    public int getDataEncoding() {
        return this.reader.getDataEncoding();
    }

    public String getProducer() throws IOException {
        return (String)this.root.getAttributeValue(ATTR.DW_AT_producer);
    }

    @Override
    public String getCompilationDir() throws IOException {
        return (String)this.root.getAttributeValue(ATTR.DW_AT_comp_dir);
    }

    @Override
    public String getSourceFileName() throws IOException {
        if (this.root != null) {
            return (String)this.root.getAttributeValue(ATTR.DW_AT_name);
        }
        return null;
    }

    @Override
    public String getCommandLine() throws IOException {
        Object cl = this.root.getAttributeValue(ATTR.DW_AT_SUN_command_line);
        return cl == null ? null : (String)cl;
    }

    public String getCompileOptions() throws IOException {
        Object cl = this.root.getAttributeValue(ATTR.DW_AT_SUN_compile_options);
        return cl == null ? null : (String)cl;
    }

    @Override
    public String getSourceFileAbsolutePath() throws IOException {
        String dir = this.getCompilationDir();
        String name = this.getSourceFileName();
        String result = dir != null ? (this.isAbsolute(name) ? name : (dir.endsWith("/") || dir.endsWith("\\") ? dir + name : dir + File.separator + name)) : name;
        return result;
    }

    private boolean isAbsolute(String path) {
        return path.startsWith("/") || path.length() > 2 && path.charAt(1) == ':';
    }

    @Override
    public String getSourceLanguage() throws IOException {
        Object lang;
        if (this.root != null && (lang = this.root.getAttributeValue(ATTR.DW_AT_language)) != null) {
            return lang.toString();
        }
        return null;
    }

    public DwarfEntry getReferencedType(DwarfEntry entry) throws IOException {
        Object typeRef = entry.getAttributeValue(ATTR.DW_AT_type);
        if (typeRef instanceof Integer) {
            return this.getEntry(((Integer)typeRef).intValue());
        }
        if (typeRef instanceof Long) {
            return this.getEntry((Long)typeRef);
        }
        return null;
    }

    public DwarfEntry getReferencedFriend(DwarfEntry entry) throws IOException {
        Object typeRef = entry.getAttributeValue(ATTR.DW_AT_friend);
        if (typeRef instanceof Integer) {
            return this.getEntry(((Integer)typeRef).intValue());
        }
        if (typeRef instanceof Long) {
            return this.getEntry((Long)typeRef);
        }
        return null;
    }

    public String getType(DwarfEntry entry) throws IOException {
        long ref;
        TAG entryKind = entry.getKind();
        if (entryKind.equals((Object)TAG.DW_TAG_unspecified_parameters)) {
            return "null";
        }
        Object typeRef = entry.getAttributeValue(ATTR.DW_AT_type);
        if (typeRef instanceof Integer) {
            ref = ((Integer)typeRef).intValue();
        } else if (typeRef instanceof Long) {
            ref = (Long)typeRef;
        } else {
            return "void";
        }
        DwarfEntry typeEntry = this.getEntry(ref);
        TAG kind = typeEntry.getKind();
        if (kind.equals((Object)TAG.DW_TAG_base_type)) {
            String name = typeEntry.getName();
            if (name.equals("long unsigned int")) {
                name = "unsigned long";
            } else if (name.equals("long int")) {
                name = "long";
            }
            return name;
        }
        if (kind.equals((Object)TAG.DW_TAG_structure_type) || kind.equals((Object)TAG.DW_TAG_enumeration_type) || kind.equals((Object)TAG.DW_TAG_union_type) || kind.equals((Object)TAG.DW_TAG_typedef) || kind.equals((Object)TAG.DW_TAG_class_type)) {
            return typeEntry.getName();
        }
        if (kind.equals((Object)TAG.DW_TAG_const_type)) {
            Object atType = typeEntry.getAttributeValue(ATTR.DW_AT_type);
            if (atType == null) {
                return "const void";
            }
            DwarfEntry refTypeEntry = null;
            if (atType instanceof Integer) {
                refTypeEntry = this.getEntry(((Integer)atType).intValue());
            } else if (atType instanceof Long) {
                refTypeEntry = this.getEntry((Long)atType);
            }
            if (refTypeEntry != null) {
                if (refTypeEntry.getKind().equals((Object)TAG.DW_TAG_reference_type) || refTypeEntry.getKind().equals((Object)TAG.DW_TAG_array_type)) {
                    return this.getType(typeEntry);
                }
                if (refTypeEntry.getKind() == TAG.DW_TAG_pointer_type) {
                    return this.getType(typeEntry) + " const";
                }
                return "const " + this.getType(typeEntry);
            }
        }
        if (kind.equals((Object)TAG.DW_TAG_reference_type)) {
            return this.getType(typeEntry) + "&";
        }
        if (kind.equals((Object)TAG.DW_TAG_array_type)) {
            return this.getType(typeEntry) + "[]";
        }
        if (kind.equals((Object)TAG.DW_TAG_pointer_type) || kind.equals((Object)TAG.DW_TAG_ptr_to_member_type)) {
            return this.getType(typeEntry) + "*";
        }
        if (kind.equals((Object)TAG.DW_TAG_subroutine_type)) {
            return typeEntry.getParametersString(false);
        }
        if (kind.equals((Object)TAG.DW_TAG_volatile_type)) {
            return this.getType(typeEntry);
        }
        if (kind.equals((Object)TAG.DW_TAG_union_type)) {
            return this.getType(typeEntry);
        }
        return "<" + (Object)((Object)kind) + ">";
    }

    public DwarfEntry getEntry(long sectionOffset) throws IOException {
        DwarfEntry entry = this.entries.get(sectionOffset);
        if (entry == null) {
            entry = this.entryLookup(this.getDebugInfo(true), sectionOffset);
            this.entries.put(sectionOffset, entry);
        }
        return entry;
    }

    public DwarfEntry getDefinition(DwarfEntry entry) throws IOException {
        Long ref = this.specifications.get(entry.getRefference());
        if (ref != null) {
            return this.getEntry(ref);
        }
        return null;
    }

    private DwarfEntry entryLookup(DwarfEntry entry, long refference) {
        if (entry == null) {
            return null;
        }
        if (entry.getRefference() == refference) {
            return entry;
        }
        for (DwarfEntry child : entry.getChildren()) {
            DwarfEntry res = this.entryLookup(child, refference);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public DwarfEntry getRoot() {
        return this.root;
    }

    public DwarfEntry getTypedefFor(long typeRef) throws IOException {
        for (DwarfEntry entry : this.getDebugInfo(true).getChildren()) {
            Object entryTypeRef;
            if (!entry.getKind().equals((Object)TAG.DW_TAG_typedef) || !((entryTypeRef = entry.getAttributeValue(ATTR.DW_AT_type)) instanceof Integer ? ((Integer)entryTypeRef).equals((int)typeRef) : entryTypeRef instanceof Long && ((Long)entryTypeRef).equals(typeRef))) continue;
            return entry;
        }
        return null;
    }

    public long getUnitTotalLength() {
        return this.unit_total_length;
    }

    private void readCompilationUnitHeader() throws IOException {
        Long abbrAddend;
        this.reader.seek(this.debugInfoSectionOffset + this.unit_offset);
        int aLegth = this.reader.readInt();
        if (aLegth == -1) {
            this.unit_length = this.reader.readLong();
            this.reader.setFileClass(2);
        } else {
            this.unit_length = aLegth;
            this.reader.setFileClass(1);
        }
        long pos = this.reader.getFilePointer();
        this.unit_total_length = this.unit_length + pos - (this.debugInfoSectionOffset + this.unit_offset);
        this.version = this.reader.readShort();
        this.debug_abbrev_offset = this.reader.read3264();
        this.address_size = (byte)(0xFF & this.reader.readByte());
        this.debugInfoOffset = this.reader.getFilePointer();
        this.reader.setAddressSize(this.address_size);
        this.rela = (DwarfRelaDebugInfoSection)this.reader.getSection(".rela.debug_info");
        if (this.rela != null && (abbrAddend = this.rela.getAbbrAddend(this.unit_offset + 6L)) != null) {
            this.debug_abbrev_offset += abbrAddend.longValue();
        }
        DwarfAbbriviationTableSection abbrSection = (DwarfAbbriviationTableSection)this.reader.getSection(".debug_abbrev");
        this.abbr_table = abbrSection.getAbbriviationTable(this.debug_abbrev_offset);
    }

    public DwarfStatementList getStatementList() throws IOException {
        if (this.statement_list == null) {
            this.initStatementList();
        }
        return this.statement_list;
    }

    public Set<DwarfLineInfoSection.LineNumber> getLineNumbers() throws IOException {
        Number statementListOffset;
        if (this.statement_list == null) {
            this.initStatementList();
        }
        if ((statementListOffset = (Number)this.root.getAttributeValue(ATTR.DW_AT_stmt_list)) != null) {
            return this.lineInfoSection.getLineNumbers(statementListOffset.longValue());
        }
        return null;
    }

    public DwarfLineInfoSection.LineNumber getLineNumber(long target) throws IOException {
        Number statementListOffset;
        if (this.statement_list == null) {
            this.initStatementList();
        }
        if ((statementListOffset = (Number)this.root.getAttributeValue(ATTR.DW_AT_stmt_list)) != null) {
            return this.lineInfoSection.getLineNumber(statementListOffset.longValue(), target);
        }
        return null;
    }

    public DwarfMacinfoTable getMacrosTable() throws IOException {
        if (this.macrosTable == null) {
            this.initMacrosTable();
        }
        return this.macrosTable;
    }

    private DwarfNameLookupTable getPubnamesTable() throws IOException {
        if (this.pubnamesTable == null) {
            this.initPubnamesTable();
        }
        return this.pubnamesTable;
    }

    private DwarfEntry getDebugInfo(boolean readChildren) throws IOException {
        if (this.root == null || readChildren && this.root.getChildren().isEmpty()) {
            this.reader.seek(this.debugInfoOffset);
            this.root = this.readEntry(0, readChildren);
            if (readChildren) {
                this.setSpecializations(this.root);
            }
        }
        return this.root;
    }

    private void setSpecializations(DwarfEntry entry) throws IOException {
        Object o = entry.getAttributeValue(ATTR.DW_AT_specification);
        if (o instanceof Integer) {
            this.specifications.put((long)((Integer)o), entry.getRefference());
        }
        for (DwarfEntry child : entry.getChildren()) {
            this.setSpecializations(child);
        }
    }

    private DwarfEntry readEntry(int level) throws IOException {
        long refference = this.reader.getFilePointer() - this.debugInfoSectionOffset - this.unit_offset;
        long idx = this.reader.readUnsignedLEB128();
        if (idx == 0L) {
            return null;
        }
        DwarfAbbriviationTableEntry abbreviationEntry = this.abbr_table.getEntry(idx);
        if (abbreviationEntry == null) {
            return null;
        }
        DwarfEntry entry = new DwarfEntry(this, abbreviationEntry, refference, level);
        for (int i = 0; i < abbreviationEntry.getAttributesCount(); ++i) {
            DwarfAttribute attr = abbreviationEntry.getAttribute(i);
            long dif = this.reader.getFilePointer() - this.debugInfoSectionOffset;
            Long replace = null;
            if (this.rela != null) {
                replace = this.rela.getAddend(dif);
            }
            if (replace != null && attr.valueForm == FORM.DW_FORM_strp) {
                this.reader.readAttrValue(attr);
                String s = ((StringTableSection)this.reader.getSection(".debug_str")).getString(replace);
                entry.addValue(s);
                continue;
            }
            if (replace != null && attr.valueForm == FORM.DW_FORM_sec_offset) {
                this.reader.readAttrValue(attr);
                entry.addValue(replace);
                continue;
            }
            Object readAttrValue = this.reader.readAttrValue(attr);
            entry.addValue(readAttrValue);
        }
        return entry;
    }

    private DwarfEntry readEntry(int level, boolean readChildren) throws IOException {
        DwarfEntry entry = this.readEntry(level);
        if (entry == null) {
            return null;
        }
        this.entries.put(entry.getRefference(), entry);
        if (readChildren && entry.hasChildren()) {
            DwarfEntry child;
            while ((child = this.readEntry(level + 1, true)) != null) {
                entry.addChild(child);
            }
        }
        return entry;
    }

    private void initStatementList() throws IOException {
        this.lineInfoSection = (DwarfLineInfoSection)this.reader.getSection(".debug_line");
        if (this.root == null) {
            return;
        }
        Number statementListOffset = (Number)this.root.getAttributeValue(ATTR.DW_AT_stmt_list);
        if (statementListOffset != null) {
            this.statement_list = this.lineInfoSection.getStatementList(statementListOffset.longValue());
        }
    }

    private void initMacrosTable() throws IOException {
        Object macroInfoOffset;
        DwarfMacroInfoSection macroInfoSection = (DwarfMacroInfoSection)this.reader.getSection(".debug_macinfo");
        boolean isMacro = false;
        if (macroInfoSection == null) {
            macroInfoSection = (DwarfMacroInfoSection)this.reader.getSection(".debug_macro");
            if (macroInfoSection == null) {
                return;
            }
            macroInfoOffset = this.root.getAttributeValue(ATTR.DW_AT_GNU_macros);
            isMacro = true;
        } else {
            macroInfoOffset = this.root.getAttributeValue(ATTR.DW_AT_macro_info);
        }
        if (macroInfoOffset instanceof Integer) {
            this.macrosTable = macroInfoSection.getMacinfoTable(((Integer)macroInfoOffset).intValue());
        } else if (macroInfoOffset instanceof Long) {
            this.macrosTable = macroInfoSection.getMacinfoTable((Long)macroInfoOffset);
        }
    }

    private void initPubnamesTable() throws IOException {
        DwarfNameLookupTableSection dwarfNameLookupTableSection = (DwarfNameLookupTableSection)this.reader.getSection(".debug_pubnames");
        if (dwarfNameLookupTableSection != null) {
            this.pubnamesTable = dwarfNameLookupTableSection.getNameLookupTableFor(this.unit_offset);
        }
    }

    public List<DwarfEntry> getDeclarations() throws IOException {
        return this.getDeclarations(true);
    }

    public List<DwarfEntry> getEntries() throws IOException {
        this.getPubnamesTable();
        return this.getDebugInfo(true).getChildren();
    }

    public List<DwarfEntry> getTopLevelEntries() throws IOException {
        this.getPubnamesTable();
        this.reader.seek(this.debugInfoOffset);
        DwarfEntry aRoot = this.readEntry(0);
        if (aRoot == null) {
            return null;
        }
        if (aRoot.hasChildren()) {
            DwarfEntry child;
            while ((child = this.readEntry(1)) != null) {
                aRoot.addChild(child);
                if (!child.hasChildren()) continue;
                long sibling = child.getSibling();
                if (sibling <= 0L) break;
                if (sibling <= child.getRefference()) {
                    System.err.println("Infinite loop in sibling chain");
                    System.err.println("" + child);
                    break;
                }
                long refference = this.debugInfoSectionOffset + this.unit_offset + sibling;
                this.reader.seek(refference);
            }
        }
        return aRoot.getChildren();
    }

    public List<DwarfEntry> getDeclarations(boolean limitedToFile) throws IOException {
        boolean reportExcluded = false;
        int fileEntryIdx = 0;
        this.getPubnamesTable();
        ArrayList<DwarfEntry> result = new ArrayList<DwarfEntry>();
        if (limitedToFile) {
            fileEntryIdx = this.getStatementList().getFileEntryIdx(this.getSourceFileName());
        }
        for (DwarfEntry child : this.getEntries()) {
            if (limitedToFile && !child.isEntryDefinedInFile(fileEntryIdx) || child.hasAbastractOrigin()) continue;
            String qname = child.getQualifiedName();
            if (qname != null && !qname.startsWith("_GLOBAL__")) {
                result.add(child);
                continue;
            }
            if (!reportExcluded) continue;
            System.out.println("Exclude declaration: " + child.getDeclaration());
        }
        return result;
    }

    public void dump(PrintStream out) throws IOException {
        Set<DwarfLineInfoSection.LineNumber> numbers;
        DwarfMacinfoTable macinfoTable;
        if (this.root == null) {
            out.println("*** No compilation units for " + this.reader.getFileName());
            return;
        }
        out.println("*** " + this.getSourceFileAbsolutePath() + " ***");
        out.println("  Compilation Unit @ offset " + Long.toHexString(this.unit_offset) + ":");
        out.println("    Length: " + this.unit_length);
        out.println("    Version: " + this.version);
        out.println("    Abbrev Offset: " + this.debug_abbrev_offset);
        out.println("    Pointer Size: " + this.address_size);
        this.getPubnamesTable();
        this.getDebugInfo(true).dump(out);
        DwarfStatementList stList = this.getStatementList();
        if (stList != null) {
            stList.dump(out);
        }
        if (this.pubnamesTable != null) {
            this.pubnamesTable.dump(out);
        }
        if ((macinfoTable = this.getMacrosTable()) != null) {
            macinfoTable.dump(out);
        }
        if ((numbers = this.getLineNumbers()) != null && numbers.size() > 0) {
            numbers = new TreeSet<DwarfLineInfoSection.LineNumber>(numbers);
            for (DwarfLineInfoSection.LineNumber line : numbers) {
                out.println(line);
            }
        }
        out.println();
    }

    public String toString() {
        try {
            StringWriter sw = new StringWriter();
            ByteArrayOutputStream st = new ByteArrayOutputStream();
            PrintStream out = new PrintStream((OutputStream)st, false, "UTF-8");
            this.dump(out);
            return st.toString("UTF-8");
        }
        catch (IOException ex) {
            Dwarf.LOG.log(Level.INFO, "File " + this.reader.getFileName(), ex);
            return "";
        }
    }

    @Override
    public boolean hasMain() throws IOException {
        List<DwarfEntry> topLevelEntries = this.getTopLevelEntries();
        for (DwarfEntry entry : topLevelEntries) {
            if (entry.getKind() != TAG.DW_TAG_subprogram || !"main".equals(entry.getName()) || !entry.isExternal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMainLine() throws IOException {
        List<DwarfEntry> topLevelEntries = this.getTopLevelEntries();
        for (DwarfEntry entry : topLevelEntries) {
            if (entry.getKind() != TAG.DW_TAG_subprogram || !"main".equals(entry.getName()) || !entry.isExternal()) continue;
            return entry.getLine();
        }
        return 0;
    }
}

