/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.cpu.LiveCPUView;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.MultiButtonGroup;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureUI;
import org.openide.util.Lookup;

abstract class MethodsFeatureUI
extends FeatureUI {
    private ProfilerToolbar toolbar;
    private LiveCPUView cpuView;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private JLabel pdLabel;
    private JButton pdSnapshotButton;
    private JButton pdResetResultsButton;
    private boolean popupPause;
    private JToggleButton[] toggles;

    MethodsFeatureUI() {
    }

    abstract Set<ClientUtils.SourceCodeSelection> getClassesSelection();

    abstract Set<ClientUtils.SourceCodeSelection> getMethodsSelection();

    abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    abstract Lookup.Provider getProject();

    abstract ProfilerClient getProfilerClient();

    abstract void refreshResults();

    @Override
    ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    @Override
    JPanel getResultsUI() {
        if (this.cpuView == null) {
            this.initUI();
        }
        return this.cpuView;
    }

    boolean hasResultsUI() {
        return this.cpuView != null;
    }

    @Override
    void sessionStateChanged(int sessionState) {
        this.refreshToolbar(sessionState);
    }

    void resetPause() {
        if (this.lrPauseButton != null) {
            this.lrPauseButton.setSelected(false);
        }
    }

    void setForceRefresh() {
        if (this.cpuView != null) {
            this.cpuView.setForceRefresh(true);
        }
    }

    void refreshData() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.cpuView != null) {
            this.cpuView.refreshData();
        }
    }

    void resetData() {
        if (this.lrDeltasButton != null) {
            this.lrDeltasButton.setSelected(false);
            this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        }
        if (this.cpuView != null) {
            this.cpuView.resetData();
            this.cpuView.setDiffView(false);
        }
    }

    void cleanup() {
        if (this.cpuView != null) {
            this.cpuView.cleanup();
        }
    }

    private void initUI() {
        assert (SwingUtilities.isEventDispatchThread());
        this.cpuView = new LiveCPUView(this.getMethodsSelection()){

            protected ProfilerClient getProfilerClient() {
                return MethodsFeatureUI.this.getProfilerClient();
            }

            protected boolean showSourceSupported() {
                return GoToSource.isAvailable();
            }

            protected void showSource(ClientUtils.SourceCodeSelection value) {
                Lookup.Provider project = MethodsFeatureUI.this.getProject();
                String className = value.getClassName();
                String methodName = value.getMethodName();
                String methodSig = value.getMethodSignature();
                GoToSource.openSource((Lookup.Provider)project, (String)className, (String)methodName, (String)methodSig);
            }

            protected void selectForProfiling(ClientUtils.SourceCodeSelection value) {
                MethodsFeatureUI.this.selectForProfiling(value);
            }

            protected void popupShowing() {
                if (MethodsFeatureUI.this.lrPauseButton.isEnabled() && !MethodsFeatureUI.this.lrRefreshButton.isEnabled()) {
                    MethodsFeatureUI.this.popupPause = true;
                    MethodsFeatureUI.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (MethodsFeatureUI.this.lrPauseButton.isEnabled() && MethodsFeatureUI.this.popupPause) {
                    MethodsFeatureUI.this.popupPause = false;
                    MethodsFeatureUI.this.lrPauseButton.setSelected(false);
                }
            }

            protected void foundInForwardCalls() {
                super.foundInForwardCalls();
                MethodsFeatureUI.this.toggles[0].setSelected(true);
            }

            protected void foundInHotSpots() {
                super.foundInHotSpots();
                MethodsFeatureUI.this.toggles[1].setSelected(true);
            }

            protected void foundInReverseCalls() {
                super.foundInReverseCalls();
                MethodsFeatureUI.this.toggles[2].setSelected(true);
            }
        };
        this.cpuView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileMethods.HelpCtx");
        this.lrLabel = new GrayLabel(Bundle.MethodsFeatureUI_liveResults());
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = this.isSelected();
                MethodsFeatureUI.this.cpuView.setPaused(paused);
                if (!paused) {
                    MethodsFeatureUI.this.refreshResults();
                }
                MethodsFeatureUI.this.refreshToolbar(MethodsFeatureUI.this.getSessionState());
            }
        };
        this.lrPauseButton.setToolTipText(Bundle.MethodsFeatureUI_pauseResults());
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                MethodsFeatureUI.this.refreshResults();
            }
        };
        this.lrRefreshButton.setToolTipText(Bundle.MethodsFeatureUI_updateResults());
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                if (!MethodsFeatureUI.this.cpuView.setDiffView(this.isSelected())) {
                    this.setSelected(false);
                }
                this.setToolTipText(this.isSelected() ? Bundle.MethodsFeatureUI_showAbsolute() : Bundle.MethodsFeatureUI_showDeltas());
            }
        };
        this.lrDeltasButton.setToolTipText(Bundle.MethodsFeatureUI_showDeltas());
        MultiButtonGroup group = new MultiButtonGroup();
        this.toggles = new JToggleButton[3];
        JToggleButton forwardCalls = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeForward")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                MethodsFeatureUI.this.cpuView.setView(this.isSelected(), MethodsFeatureUI.this.toggles[1].isSelected(), MethodsFeatureUI.this.toggles[2].isSelected());
                MethodsFeatureUI.this.refreshResults();
            }
        };
        forwardCalls.putClientProperty("JButton.buttonType", "segmented");
        forwardCalls.putClientProperty("JButton.segmentPosition", "first");
        forwardCalls.setToolTipText(Bundle.MethodsFeatureUI_viewForward());
        group.add((AbstractButton)forwardCalls);
        this.toggles[0] = forwardCalls;
        forwardCalls.setSelected(true);
        JToggleButton hotSpots = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.TabHotSpots")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                MethodsFeatureUI.this.cpuView.setView(MethodsFeatureUI.this.toggles[0].isSelected(), this.isSelected(), MethodsFeatureUI.this.toggles[2].isSelected());
                MethodsFeatureUI.this.refreshResults();
            }
        };
        hotSpots.putClientProperty("JButton.buttonType", "segmented");
        hotSpots.putClientProperty("JButton.segmentPosition", "middle");
        hotSpots.setToolTipText(Bundle.MethodsFeatureUI_viewHotSpots());
        group.add((AbstractButton)hotSpots);
        this.toggles[1] = hotSpots;
        hotSpots.setSelected(false);
        JToggleButton reverseCalls = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.NodeReverse")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                MethodsFeatureUI.this.cpuView.setView(MethodsFeatureUI.this.toggles[0].isSelected(), MethodsFeatureUI.this.toggles[1].isSelected(), this.isSelected());
                MethodsFeatureUI.this.refreshResults();
            }
        };
        reverseCalls.putClientProperty("JButton.buttonType", "segmented");
        reverseCalls.putClientProperty("JButton.segmentPosition", "last");
        reverseCalls.setToolTipText(Bundle.MethodsFeatureUI_viewReverse());
        group.add((AbstractButton)reverseCalls);
        this.toggles[2] = reverseCalls;
        reverseCalls.setSelected(false);
        this.pdLabel = new GrayLabel(Bundle.MethodsFeatureUI_profilingData());
        this.pdSnapshotButton = new JButton((Action)((Object)TakeSnapshotAction.getInstance()));
        this.pdSnapshotButton.setHideActionText(true);
        this.pdResetResultsButton = new JButton((Action)((Object)ResetResultsAction.getInstance()));
        this.pdResetResultsButton.setHideActionText(true);
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrDeltasButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.MethodsFeatureUI_view()));
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)forwardCalls);
        this.toolbar.add((Component)hotSpots);
        this.toolbar.add((Component)reverseCalls);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.cpuView.createThreadSelector());
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.pdLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.pdSnapshotButton);
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)this.pdResetResultsButton);
        this.cpuView.setView(true, false, false);
        this.sessionStateChanged(this.getSessionState());
    }

    private void refreshToolbar(final int state) {
        if (this.toolbar != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean running = state == 4;
                    MethodsFeatureUI.this.lrPauseButton.setEnabled(running);
                    MethodsFeatureUI.this.lrRefreshButton.setEnabled(!MethodsFeatureUI.this.popupPause && running && MethodsFeatureUI.this.lrPauseButton.isSelected());
                    MethodsFeatureUI.this.lrDeltasButton.setEnabled(running);
                }
            });
        }
    }
}

