/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.clank;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ErrorDirectiveImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.parser.clank.MacroDeclarationReference;
import org.netbeans.modules.cnd.modelimpl.parser.clank.MacroReference;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.NbBundle;

final class ClankToCsmSupport {
    private ClankToCsmSupport() {
    }

    static void addPreprocessorDirectives(FileImpl curFile, FileContent parsingFileContent, ClankDriver.ClankPreprocessorOutput ppOutput) {
        assert (parsingFileContent != null);
        assert (curFile != null);
        assert (ppOutput != null);
        for (ClankDriver.ClankPreprocessorDirective cur : ppOutput.getPreprocessorDirectives()) {
            if (cur instanceof ClankDriver.ClankInclusionDirective) {
                ClankToCsmSupport.addInclude(curFile, parsingFileContent, (ClankDriver.ClankInclusionDirective)cur);
                continue;
            }
            if (cur instanceof ClankDriver.ClankErrorDirective) {
                ClankToCsmSupport.addError(curFile, parsingFileContent, (ClankDriver.ClankErrorDirective)cur);
                continue;
            }
            if (cur instanceof ClankDriver.ClankMacroDirective) {
                ClankToCsmSupport.addMacro(curFile, parsingFileContent, (ClankDriver.ClankMacroDirective)cur);
                continue;
            }
            CndUtils.assertTrueInConsole((boolean)false, (String)("unknown directive " + cur.getClass().getSimpleName() + " " + cur));
        }
    }

    static void setFileGuard(FileImpl curFile, FileContent parsingFileContent, ClankDriver.ClankPreprocessorOutput ppOutput) {
        assert (ppOutput != null);
        ClankDriver.FileGuard fileGuard = ppOutput.getFileGuard();
        if (fileGuard != null) {
            curFile.setFileGuard(fileGuard.getStartOfset(), fileGuard.getEndOfset());
        } else {
            curFile.setFileGuard(-1, -1);
        }
    }

    static void addMacroExpansions(FileImpl curFile, FileContent parsingFileContent, FileImpl startFile, ClankDriver.ClankPreprocessorOutput ppOutput) {
        MacroReference macroRef;
        ClankDriver.ClankMacroDirective directive;
        assert (ppOutput != null);
        for (ClankDriver.MacroExpansion cur : ppOutput.getMacroExpansions()) {
            directive = cur.getReferencedMacro();
            if (directive != null) {
                macroRef = MacroReference.createMacroReference(curFile, cur.getStartOfset(), cur.getStartOfset() + cur.getMacroNameLength(), startFile, directive);
                if (macroRef == null) {
                    if (curFile.isValid()) continue;
                    break;
                }
                ClankToCsmSupport.addMacroUsage(curFile, parsingFileContent, macroRef);
                continue;
            }
            assert (false) : "Not found referenced ClankMacroDirective " + cur;
        }
        for (ClankDriver.MacroExpansion cur : ppOutput.getMacroUsages()) {
            directive = cur.getReferencedMacro();
            if (directive != null) {
                macroRef = MacroReference.createMacroReference(curFile, cur.getStartOfset(), cur.getEndOfset(), startFile, directive);
                if (macroRef == null) {
                    if (curFile.isValid()) continue;
                    break;
                }
                ClankToCsmSupport.addMacroUsage(curFile, parsingFileContent, macroRef);
                continue;
            }
            assert (false) : "Not found referenced ClankMacroDirective " + cur;
        }
    }

    private static void addMacroUsage(FileImpl curFile, FileContent parsingFileContent, MacroReference macroReference) {
        parsingFileContent.addReference(macroReference, macroReference.getReferencedObject());
    }

    private static void addMacro(FileImpl curFile, FileContent parsingFileContent, ClankDriver.ClankMacroDirective ppDirective) {
        if (!ppDirective.isDefined()) {
            return;
        }
        CsmMacro.Kind kind = CsmMacro.Kind.DEFINED;
        List params = ppDirective.getParameters();
        CharSequence name = ppDirective.getMacroName();
        String body = "";
        int startOffset = ppDirective.getDirectiveStartOffset();
        int endOffset = ppDirective.getDirectiveEndOffset();
        int macroNameOffset = ppDirective.getMacroNameOffset();
        CsmMacro impl = MacroImpl.create(name, params, body, curFile, startOffset, endOffset, kind);
        parsingFileContent.addMacro(impl);
        parsingFileContent.addReference(new MacroDeclarationReference(curFile, impl, macroNameOffset), (CsmObject)impl);
    }

    static List<CsmReference> getMacroUsages(FileImpl fileImpl, FileImpl startFile, ClankDriver.ClankPreprocessorOutput ppOutput) {
        if (ppOutput == null) {
            return Collections.emptyList();
        }
        ArrayList<CsmReference> res = new ArrayList<CsmReference>();
        ClankToCsmSupport.addPreprocessorDirectives(fileImpl, res, ppOutput);
        ClankToCsmSupport.addMacroExpansions(fileImpl, res, startFile, ppOutput);
        Collections.sort(res, new Comparator<CsmReference>(){

            @Override
            public int compare(CsmReference o1, CsmReference o2) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        return res;
    }

    private static void addPreprocessorDirectives(FileImpl curFile, List<CsmReference> res, ClankDriver.ClankPreprocessorOutput ppOutput) {
        assert (res != null);
        assert (curFile != null);
        assert (ppOutput != null);
        for (ClankDriver.ClankPreprocessorDirective cur : ppOutput.getPreprocessorDirectives()) {
            if (!(cur instanceof ClankDriver.ClankMacroDirective)) continue;
            ClankToCsmSupport.addMacro(curFile, res, (ClankDriver.ClankMacroDirective)cur);
        }
    }

    private static void addMacroExpansions(FileImpl curFile, List<CsmReference> res, FileImpl startFile, ClankDriver.ClankPreprocessorOutput ppOutput) {
        MacroReference macroRef;
        ClankDriver.ClankMacroDirective directive;
        for (ClankDriver.MacroExpansion cur : ppOutput.getMacroExpansions()) {
            directive = cur.getReferencedMacro();
            if (directive != null) {
                macroRef = MacroReference.createMacroReference(curFile, cur.getStartOfset(), cur.getStartOfset() + cur.getMacroNameLength(), startFile, directive);
                if (macroRef == null) {
                    if (curFile.isValid()) continue;
                    break;
                }
                res.add(macroRef);
                continue;
            }
            assert (false) : "Not found referenced ClankMacroDirective " + cur;
        }
        for (ClankDriver.MacroExpansion cur : ppOutput.getMacroUsages()) {
            directive = cur.getReferencedMacro();
            if (directive != null) {
                macroRef = MacroReference.createMacroReference(curFile, cur.getStartOfset(), cur.getEndOfset(), startFile, directive);
                if (macroRef == null) {
                    if (curFile.isValid()) continue;
                    break;
                }
                res.add(macroRef);
                continue;
            }
            assert (false) : "Not found referenced ClankMacroDirective " + cur;
        }
    }

    private static void addMacro(FileImpl curFile, List<CsmReference> res, ClankDriver.ClankMacroDirective ppDirective) {
        if (!ppDirective.isDefined()) {
            return;
        }
        CsmMacro.Kind kind = CsmMacro.Kind.DEFINED;
        List params = ppDirective.getParameters();
        CharSequence name = ppDirective.getMacroName();
        String body = "";
        int startOffset = ppDirective.getDirectiveStartOffset();
        int endOffset = ppDirective.getDirectiveEndOffset();
        int macroNameOffset = ppDirective.getMacroNameOffset();
        CsmMacro impl = MacroImpl.create(name, params, body, curFile, startOffset, endOffset, kind);
        MacroDeclarationReference macroDeclarationReference = new MacroDeclarationReference(curFile, impl, macroNameOffset);
        res.add(macroDeclarationReference);
    }

    private static void addError(FileImpl curFile, FileContent parsingFileContent, ClankDriver.ClankErrorDirective ppDirective) {
        CharSequence msg = ppDirective.getMessage();
        PreprocHandler.State state = ppDirective.getStateWhenMetErrorDirective();
        int start = ppDirective.getDirectiveStartOffset();
        int end = ppDirective.getDirectiveEndOffset();
        ErrorDirectiveImpl impl = ErrorDirectiveImpl.create(curFile, msg, new CsmOffsetableImpl(curFile, start, end), state);
        parsingFileContent.addError(impl);
    }

    private static void addInclude(FileImpl curFile, FileContent parsingFileContent, ClankDriver.ClankInclusionDirective ppDirective) {
        ResolvedPath resolvedPath = ppDirective.getResolvedPath();
        CharSequence fileName = ppDirective.getSpellingName();
        boolean system = ppDirective.isAngled();
        boolean broken = resolvedPath == null;
        Object includeAnnotation = ppDirective.getAnnotation();
        boolean unresolvedInclude = includeAnnotation == UnresolvedIncludeDirectiveReason.NULL_PATH;
        FileImpl includedFile = null;
        if (unresolvedInclude != broken && CsmModelAccessor.isModelAlive()) assert (false) : "broken " + broken + " vs. " + includeAnnotation + " in " + ppDirective;
        if (includeAnnotation instanceof FileImpl) {
            includedFile = (FileImpl)includeAnnotation;
        }
        int startOffset = ppDirective.getDirectiveStartOffset();
        int endOffset = ppDirective.getDirectiveEndOffset();
        int includeDirectiveIndex = ppDirective.getIncludeDirectiveIndex();
        IncludeImpl incl = IncludeImpl.create(fileName.toString(), system, ppDirective.isRecursive(), includedFile, curFile, startOffset, endOffset, includeDirectiveIndex);
        parsingFileContent.addInclude(incl, broken || ppDirective.isRecursive());
    }

    static final class UnresolvedIncludeDirectiveAnnotation {
        private final UnresolvedIncludeDirectiveReason reason;
        private final Object[] args;
        private final Exception stack;

        UnresolvedIncludeDirectiveAnnotation(UnresolvedIncludeDirectiveReason reason, Object ... args) {
            this.reason = reason;
            this.args = args;
            this.stack = CndUtils.isDebugMode() ? new Exception() : null;
        }

        public String toString() {
            StackTraceElement[] stackTrace;
            StringBuilder buf = new StringBuilder();
            buf.append(NbBundle.getMessage(ClankToCsmSupport.class, (String)this.reason.name(), (Object[])this.args));
            if (this.stack != null && (stackTrace = this.stack.getStackTrace()) != null) {
                for (StackTraceElement line : stackTrace) {
                    buf.append("\n\tat ").append(line.toString());
                }
            }
            return buf.toString();
        }
    }

    static enum UnresolvedIncludeDirectiveReason {
        NULL_PATH,
        UNRESOLVED_FILE_OWNER,
        START_PROJECT_CLOSED,
        INVALID_START_PROJECT,
        START_PROJECT_CANNOT_CREATE_FILE,
        NULL_START_PROJECT;

    }

    private static final class CsmOffsetableImpl
    implements CsmOffsetable {
        private final CsmFile file;
        private final int selectionStart;
        private final int selectionEnd;

        public CsmOffsetableImpl(CsmFile file, int selectionStart, int selectionEnd) {
            this.file = file;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
        }

        public CsmFile getContainingFile() {
            return this.file;
        }

        public int getStartOffset() {
            return this.selectionStart;
        }

        public int getEndOffset() {
            return this.selectionEnd;
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException();
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException();
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException();
        }
    }
}

