/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.treeview;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.netbeans.modules.mobility.end2end.ui.treeview.MethodCheckedNodeRenderer;
import org.netbeans.modules.mobility.end2end.ui.treeview.MethodCheckedTreeBeanView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

public class MethodCheckedNodeEditor
extends AbstractCellEditor
implements TreeCellEditor,
ItemListener {
    static final long serialVersionUID = -5087358518052291490L;
    private final MethodCheckedNodeRenderer customRenderer;
    private final JTree jtree;
    private final int checkWidth;
    private MethodCheckedTreeBeanView storage;
    private Node node = null;

    public MethodCheckedNodeEditor(JTree jtree) {
        this.jtree = jtree;
        this.customRenderer = new MethodCheckedNodeRenderer();
        this.checkWidth = this.customRenderer.getCheckBoxWidth();
        this.customRenderer.addItemListener(this);
    }

    public void setContentStorage(MethodCheckedTreeBeanView storage) {
        this.storage = storage;
    }

    @Override
    public Object getCellEditorValue() {
        return this.customRenderer;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        boolean returnValue = false;
        if (e instanceof MouseEvent) {
            Object o;
            Node node;
            if (!this.canEditImmediately(e)) {
                return false;
            }
            MouseEvent mouseEvent = (MouseEvent)e;
            TreePath path = this.jtree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (path != null && (node = Visualizer.findNode((Object)(o = path.getLastPathComponent()))) != null) {
                return true;
            }
        }
        return false;
    }

    protected boolean canEditImmediately(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return this.inHitRegion(me.getX(), me.getY());
        }
        return false;
    }

    protected boolean inHitRegion(int x, int y) {
        Rectangle bounds;
        int lastRow = this.jtree.getRowForLocation(x, y);
        return lastRow != -1 && this.jtree != null && (bounds = this.jtree.getRowBounds(lastRow)) != null && x - bounds.x < 12 && x - bounds.x >= 0;
    }

    @Override
    public synchronized Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.node = Visualizer.findNode((Object)value);
        return this.customRenderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        if (this.stopCellEditing() && this.node != null) {
            this.node.setValue("isSelected", (Object)this.customRenderer.getState());
            this.storage.updateTreeNodeStates(this.node);
        }
    }
}

