/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.StopProcessing;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class ComparatorParameterNotUsed
extends TreePathScanner {
    private final CompilationInfo ci;
    private final Set<VariableElement> unusedVars;

    public ComparatorParameterNotUsed(CompilationInfo ci, Set<VariableElement> unusedVars) {
        this.ci = ci;
        this.unusedVars = unusedVars;
    }

    public static List<ErrorDescription> run(HintContext ctx) {
        CompilationInfo ci = ctx.getInfo();
        Element me = ci.getTrees().getElement(ctx.getPath());
        if (me == null) {
            return null;
        }
        Element clazz = me.getEnclosingElement();
        if (!(clazz != null && (clazz.getKind().isClass() || clazz.getKind().isInterface() && me.getModifiers().contains((Object)Modifier.DEFAULT)))) {
            return null;
        }
        TypeMirror tm = clazz.asType();
        TypeElement comparableIface = ci.getElements().getTypeElement("java.lang.Comparable");
        if (comparableIface == null || !ci.getTypes().isSubtype(tm, comparableIface.asType())) {
            return null;
        }
        HashSet<VariableElement> vars = new HashSet<VariableElement>(2);
        ExecutableElement ee = (ExecutableElement)me;
        vars.addAll(ee.getParameters());
        ComparatorParameterNotUsed v = new ComparatorParameterNotUsed(ci, vars);
        MethodTree mt = (MethodTree)ctx.getPath().getLeaf();
        if (mt.getBody() == null) {
            return null;
        }
        try {
            v.scan(new TreePath(ctx.getPath(), mt.getBody()), v);
        }
        catch (StopProcessing stopProcessing) {
            // empty catch block
        }
        if (v.unusedVars.isEmpty()) {
            return null;
        }
        VariableTree par1 = mt.getParameters().get(0);
        VariableTree par2 = mt.getParameters().get(1);
        ArrayList<VariableElement> ll = new ArrayList<VariableElement>(v.unusedVars);
        ArrayList<ErrorDescription> res = new ArrayList<ErrorDescription>(ll.size());
        Collections.sort(ll, Collator.getInstance());
        for (VariableElement ve : ll) {
            VariableTree vt = ve.getSimpleName() == par1.getName() ? par1 : par2;
            res.add(ErrorDescriptionFactory.forName((HintContext)ctx, (Tree)vt, (String)Bundle.TEXT_ComparatorParameterNotUsed(ve.getSimpleName().toString()), (Fix[])new Fix[0]));
        }
        return res;
    }

    @Override
    public Object visitIdentifier(IdentifierTree node, Object p) {
        Element el = this.ci.getTrees().getElement(this.getCurrentPath());
        if (el != null && el.getKind() == ElementKind.PARAMETER) {
            this.unusedVars.remove(el);
            if (this.unusedVars.isEmpty()) {
                throw new StopProcessing();
            }
        }
        return super.visitIdentifier(node, p);
    }
}

