/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.options;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.netbeans.modules.groovy.support.spi.GroovyOptionsSubpanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class SupportPanel
extends JPanel {
    private final Collection<GroovyOptionsSubpanel> subpanels;
    private JButton chooseDocButton;
    private JLabel docLabel;
    private JTextField groovyDocTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel subpanelWrapper;

    SupportPanel(@NonNull Collection<? extends GroovyOptionsSubpanel> subpanels) {
        this.subpanels = new ArrayList<GroovyOptionsSubpanel>(subpanels);
        this.initComponents();
        int y = 1;
        for (GroovyOptionsSubpanel subpanel : this.subpanels) {
            GridBagConstraints constr = new GridBagConstraints();
            constr.gridx = 1;
            constr.gridy = y++;
            constr.weightx = 1.0;
            constr.fill = 2;
            constr.insets = new Insets(0, 0, 8, 0);
            this.subpanelWrapper.add(subpanel.getComponent(), constr);
        }
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 1;
        constr.gridy = y;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.fill = 1;
        this.subpanelWrapper.add((Component)new JLabel(), constr);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.docLabel = new JLabel();
        this.groovyDocTextField = new JTextField();
        this.chooseDocButton = new JButton();
        this.subpanelWrapper = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.jLabel2.text"));
        this.jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SupportPanel.this.jLabel2MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SupportPanel.this.jLabel2MouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SupportPanel.this.jLabel2MousePressed(evt);
            }
        });
        this.docLabel.setLabelFor(this.groovyDocTextField);
        Mnemonics.setLocalizedText((JLabel)this.docLabel, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.docLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chooseDocButton, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseDocButton.text"));
        this.chooseDocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SupportPanel.this.chooseDocButtonActionPerformed(evt);
            }
        });
        this.subpanelWrapper.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.jLabel3.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subpanelWrapper, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addContainerGap(174, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.docLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addGroup(layout.createSequentialGroup().addComponent(this.groovyDocTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseDocButton, -2, 78, -2)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.docLabel).addComponent(this.groovyDocTextField, -2, -1, -2).addComponent(this.chooseDocButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subpanelWrapper, -1, 98, Short.MAX_VALUE)));
        this.groovyDocTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.groovyDocTextField.accessibleName"));
        this.groovyDocTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.groovyDocTextField.accessibleDescription"));
        this.chooseDocButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseDocButton.accessibleName"));
        this.chooseDocButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SupportPanel.class, (String)"SupportPanel.chooseDocButton.accessibleDescription"));
    }

    private void chooseDocButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(SupportPanel.class).setDirectoriesOnly(true).setDefaultWorkingDirectory(null).setTitle(NbBundle.getMessage(SupportPanel.class, (String)"LBL_Select_Directory")).setApproveText(NbBundle.getMessage(SupportPanel.class, (String)"LBL_Select_Directory")).showOpenDialog();
        if (file != null) {
            if (!new File(new File(file, "groovy-jdk"), "index.html").isFile()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SupportPanel.class, (String)"LBL_Not_groovy_doc"), 2));
                return;
            }
            this.groovyDocTextField.setText(file.getAbsolutePath());
        }
    }

    private void jLabel2MouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void jLabel2MouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jLabel2MousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://groovy.codehaus.org"));
        }
        catch (MalformedURLException murle) {
            Exceptions.printStackTrace((Throwable)murle);
        }
    }

    void load() {
        GroovySettings groovyOption = GroovySettings.getInstance();
        String text = groovyOption.getGroovyDoc();
        if (text == null) {
            text = "";
        }
        this.groovyDocTextField.setText(text);
        for (GroovyOptionsSubpanel subpanel : this.subpanels) {
            subpanel.load();
        }
    }

    void store() {
        GroovySettings groovyOption = GroovySettings.getInstance();
        groovyOption.setGroovyDoc(this.groovyDocTextField.getText().trim());
        for (GroovyOptionsSubpanel subpanel : this.subpanels) {
            subpanel.store();
        }
    }

    boolean valid() {
        String groovyDoc = this.groovyDocTextField.getText().trim();
        if ("".equals(groovyDoc)) {
            return false;
        }
        for (GroovyOptionsSubpanel subpanel : this.subpanels) {
            if (subpanel.valid()) continue;
            return false;
        }
        return true;
    }

    boolean changed() {
        String text = GroovySettings.getInstance().getGroovyDoc();
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.groovyDocTextField.getText().trim())) {
            return true;
        }
        boolean isChanged = false;
        for (GroovyOptionsSubpanel subpanel : this.subpanels) {
            isChanged |= subpanel.changed();
        }
        return isChanged;
    }
}

