/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.IOException;
import java.net.ConnectException;
import java.text.ParseException;
import org.netbeans.modules.cnd.spi.remote.setup.MirrorPathProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.remote.spi.FileSystemCacheProvider;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.util.Exceptions;

public class RemoteMirrorPathProvider
implements MirrorPathProvider {
    private static final String POSTFIX = System.getProperty("cnd.remote.sync.root.postfix");

    @Override
    public String getLocalMirror(ExecutionEnvironment executionEnvironment) {
        return FileSystemCacheProvider.getCacheRoot((ExecutionEnvironment)executionEnvironment);
    }

    @Override
    public String getRemoteMirror(ExecutionEnvironment executionEnvironment) throws ConnectException, IOException, ConnectionManager.CancellationException {
        String canonical;
        String root = System.getProperty("cnd.remote.sync.root." + executionEnvironment.getHost());
        if (root != null) {
            return root;
        }
        root = System.getProperty("cnd.remote.sync.root");
        if (root != null) {
            return root;
        }
        if (!HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)executionEnvironment)) {
            return null;
        }
        String home = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment).getUserDir();
        ExecutionEnvironment local = ExecutionEnvironmentFactory.getLocal();
        MacroExpanderFactory.MacroExpander expander = MacroExpanderFactory.getExpander((ExecutionEnvironment)local);
        String localHostID = local.getHost();
        try {
            localHostID = expander.expandPredefinedMacros("${hostname}-${osname}-${platform}${_isa}");
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        String result = home + "/.netbeans/remote/" + executionEnvironment.getHost() + "/" + localHostID;
        if (POSTFIX != null) {
            result = result + '-' + POSTFIX;
        }
        return (canonical = FileSystemProvider.getCanonicalPath((ExecutionEnvironment)executionEnvironment, (String)result)) == null ? result : canonical;
    }
}

