/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class AnnotatedElementUtils {
    public static Set<String> getMetaAnnotationTypes(AnnotatedElement element, String annotationType) {
        final LinkedHashSet<String> types = new LinkedHashSet<String>();
        AnnotatedElementUtils.process(element, annotationType, new Processor<Object>(){

            @Override
            public Object process(Annotation annotation, int depth) {
                if (depth > 0) {
                    types.add(annotation.annotationType().getName());
                }
                return null;
            }

            @Override
            public void postProcess(Annotation annotation, Object result) {
            }
        });
        return types.isEmpty() ? null : types;
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement element, String annotationType) {
        return Boolean.TRUE.equals(AnnotatedElementUtils.process(element, annotationType, new Processor<Boolean>(){

            @Override
            public Boolean process(Annotation annotation, int depth) {
                if (depth > 0) {
                    return true;
                }
                return null;
            }

            @Override
            public void postProcess(Annotation annotation, Boolean result) {
            }
        }));
    }

    public static boolean isAnnotated(AnnotatedElement element, String annotationType) {
        return Boolean.TRUE.equals(AnnotatedElementUtils.process(element, annotationType, new Processor<Boolean>(){

            @Override
            public Boolean process(Annotation annotation, int depth) {
                return true;
            }

            @Override
            public void postProcess(Annotation annotation, Boolean result) {
            }
        }));
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, String annotationType) {
        return AnnotatedElementUtils.getAnnotationAttributes(element, annotationType, false, false);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, String annotationType, final boolean classValuesAsString, final boolean nestedAnnotationsAsMap) {
        return AnnotatedElementUtils.process(element, annotationType, new Processor<AnnotationAttributes>(){

            @Override
            public AnnotationAttributes process(Annotation annotation, int depth) {
                return AnnotationUtils.getAnnotationAttributes(annotation, classValuesAsString, nestedAnnotationsAsMap);
            }

            @Override
            public void postProcess(Annotation annotation, AnnotationAttributes result) {
                for (String key : result.keySet()) {
                    Object value;
                    if ("value".equals(key) || (value = AnnotationUtils.getValue(annotation, key)) == null) continue;
                    result.put(key, value);
                }
            }
        });
    }

    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement element, final String annotationType, final boolean classValuesAsString, final boolean nestedAnnotationsAsMap) {
        final LinkedMultiValueMap<String, Object> attributes = new LinkedMultiValueMap<String, Object>();
        AnnotatedElementUtils.process(element, annotationType, new Processor<Void>(){

            @Override
            public Void process(Annotation annotation, int depth) {
                if (annotation.annotationType().getName().equals(annotationType)) {
                    for (Map.Entry entry : AnnotationUtils.getAnnotationAttributes(annotation, classValuesAsString, nestedAnnotationsAsMap).entrySet()) {
                        attributes.add(entry.getKey(), entry.getValue());
                    }
                }
                return null;
            }

            @Override
            public void postProcess(Annotation annotation, Void result) {
                for (String key : attributes.keySet()) {
                    Object value;
                    if ("value".equals(key) || (value = AnnotationUtils.getValue(annotation, key)) == null) continue;
                    attributes.add(key, value);
                }
            }
        });
        return attributes.isEmpty() ? null : attributes;
    }

    private static <T> T process(AnnotatedElement element, String annotationType, Processor<T> processor) {
        return AnnotatedElementUtils.doProcess(element, annotationType, processor, new HashSet<AnnotatedElement>(), 0);
    }

    private static <T> T doProcess(AnnotatedElement element, String annotationType, Processor<T> processor, Set<AnnotatedElement> visited, int depth) {
        if (visited.add(element)) {
            T result;
            for (Annotation annotation : element.getAnnotations()) {
                if (!annotation.annotationType().getName().equals(annotationType) && depth <= 0) continue;
                result = processor.process(annotation, depth);
                if (result != null) {
                    return result;
                }
                result = AnnotatedElementUtils.doProcess(annotation.annotationType(), annotationType, processor, visited, depth + 1);
                if (result == null) continue;
                processor.postProcess(annotation, result);
                return result;
            }
            for (Annotation annotation : element.getAnnotations()) {
                result = AnnotatedElementUtils.doProcess(annotation.annotationType(), annotationType, processor, visited, depth);
                if (result == null) continue;
                processor.postProcess(annotation, result);
                return result;
            }
        }
        return null;
    }

    private static interface Processor<T> {
        public T process(Annotation var1, int var2);

        public void postProcess(Annotation var1, T var2);
    }
}

