/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.core.AbstractMessagingTemplate;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.core.DestinationResolvingMessageReceivingOperations;
import org.springframework.messaging.core.DestinationResolvingMessageRequestReplyOperations;
import org.springframework.messaging.core.DestinationResolvingMessageSendingOperations;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.util.Assert;

public abstract class AbstractDestinationResolvingMessagingTemplate<D>
extends AbstractMessagingTemplate<D>
implements DestinationResolvingMessageSendingOperations<D>,
DestinationResolvingMessageReceivingOperations<D>,
DestinationResolvingMessageRequestReplyOperations<D> {
    private volatile DestinationResolver<D> destinationResolver;

    public void setDestinationResolver(DestinationResolver<D> destinationResolver) {
        Assert.notNull(destinationResolver, (String)"'destinationResolver' is required");
        this.destinationResolver = destinationResolver;
    }

    public DestinationResolver<D> getDestinationResolver() {
        return this.destinationResolver;
    }

    @Override
    public void send(String destinationName, Message<?> message) {
        D destination = this.resolveDestination(destinationName);
        this.doSend(destination, message);
    }

    protected final D resolveDestination(String destinationName) {
        Assert.state((this.destinationResolver != null ? 1 : 0) != 0, (String)"destinationResolver is required to resolve destination names");
        return this.destinationResolver.resolveDestination(destinationName);
    }

    @Override
    public <T> void convertAndSend(String destinationName, T payload) {
        Map<String, Object> headers = null;
        this.convertAndSend(destinationName, payload, headers);
    }

    @Override
    public <T> void convertAndSend(String destinationName, T payload, Map<String, Object> headers) {
        MessagePostProcessor postProcessor = null;
        this.convertAndSend(destinationName, payload, headers, postProcessor);
    }

    @Override
    public <T> void convertAndSend(String destinationName, T payload, MessagePostProcessor postProcessor) {
        Map<String, Object> headers = null;
        this.convertAndSend(destinationName, payload, headers, postProcessor);
    }

    @Override
    public <T> void convertAndSend(String destinationName, T payload, Map<String, Object> headers, MessagePostProcessor postProcessor) {
        D destination = this.resolveDestination(destinationName);
        super.convertAndSend(destination, payload, headers, postProcessor);
    }

    @Override
    public Message<?> receive(String destinationName) {
        D destination = this.resolveDestination(destinationName);
        return super.receive(destination);
    }

    @Override
    public <T> T receiveAndConvert(String destinationName, Class<T> targetClass) {
        D destination = this.resolveDestination(destinationName);
        return super.receiveAndConvert(destination, targetClass);
    }

    @Override
    public Message<?> sendAndReceive(String destinationName, Message<?> requestMessage) {
        D destination = this.resolveDestination(destinationName);
        return super.sendAndReceive(destination, requestMessage);
    }

    @Override
    public <T> T convertSendAndReceive(String destinationName, Object request, Class<T> targetClass) {
        D destination = this.resolveDestination(destinationName);
        return super.convertSendAndReceive(destination, request, targetClass);
    }

    @Override
    public <T> T convertSendAndReceive(String destinationName, Object request, Map<String, Object> headers, Class<T> targetClass) {
        D destination = this.resolveDestination(destinationName);
        return super.convertSendAndReceive(destination, request, headers, targetClass);
    }

    @Override
    public <T> T convertSendAndReceive(String destinationName, Object request, Class<T> targetClass, MessagePostProcessor postProcessor) {
        D destination = this.resolveDestination(destinationName);
        return super.convertSendAndReceive(destination, request, targetClass, postProcessor);
    }

    @Override
    public <T> T convertSendAndReceive(String destinationName, Object request, Map<String, Object> headers, Class<T> targetClass, MessagePostProcessor postProcessor) {
        D destination = this.resolveDestination(destinationName);
        return super.convertSendAndReceive(destination, request, headers, targetClass, postProcessor);
    }
}

