/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.branch;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.branch.Bundle;
import org.netbeans.modules.git.remote.ui.branch.CreateBranch;
import org.netbeans.modules.git.remote.ui.checkout.SwitchBranchAction;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class CreateBranchAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CreateBranchAction.class.getName());

    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.createBranch(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void createBranch(VCSFileProxy repository, String preselectedRevision) {
        final CreateBranch createBranch = new CreateBranch(repository, preselectedRevision, this.getBranches(repository));
        if (createBranch.show()) {
            if (createBranch.isCheckoutSelected()) {
                ((SwitchBranchAction)SystemAction.get(SwitchBranchAction.class)).checkoutRevision(repository, createBranch.getRevision(), createBranch.getBranchName(), Bundle.LBL_CreateBranchAction_progressName());
            } else {
                GitProgressSupport supp = new GitProgressSupport(){

                    @Override
                    protected void perform() {
                        try {
                            GitClient client = this.getClient();
                            String revision = createBranch.getRevision();
                            LOG.log(Level.FINE, "Creating a branch: {0}", revision);
                            GitBranch branch = client.createBranch(createBranch.getBranchName(), createBranch.getRevision(), this.getProgressMonitor());
                            this.log(revision, branch);
                        }
                        catch (GitException ex) {
                            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                        }
                    }

                    private void log(String revision, GitBranch branch) {
                        OutputLogger logger = this.getLogger();
                        logger.outputLine(NbBundle.getMessage(CreateBranchAction.class, (String)"MSG_CreateBranchAction.branchCreated", (Object[])new Object[]{branch.getName(), revision, branch.getId()}));
                    }
                };
                supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_CreateBranchAction_progressName());
            }
        }
    }

    private Map<String, GitBranch> getBranches(VCSFileProxy repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refresh();
        return info.getBranches();
    }
}

