/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.history;

import java.awt.BorderLayout;
import org.netbeans.modules.git.remote.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.git.remote.ui.history.SearchExecutor;
import org.netbeans.modules.git.remote.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.windows.TopComponent;

@TopComponent.Description(persistenceType=2, preferredID="GitRemote.SearchOutgoingTopComponent")
public class SearchOutgoingTopComponent
extends TopComponent {
    private SearchHistoryPanel shp;
    private SearchCriteriaPanel scp;
    private final VCSFileProxy[] files;
    private final VCSFileProxy repository;
    private final RepositoryInfo info;

    public SearchOutgoingTopComponent(VCSFileProxy repository, RepositoryInfo info, VCSFileProxy[] files) {
        this.repository = repository;
        this.info = info;
        this.files = files;
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchOutgoingTopComponent.class, (String)"ACSN_SearchOutgoingT_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchOutgoingTopComponent.class, (String)"ACSD_SearchOutgoingT_Top_Component"));
        this.initComponents();
        this.scp.setupRemoteSearch(SearchExecutor.Mode.REMOTE_OUT);
    }

    public void search(boolean showCriteria) {
        this.shp.executeSearch();
        this.shp.setSearchCriteria(showCriteria);
    }

    void setBranch(String branch) {
        Parameters.notNull((CharSequence)"branch", (Object)branch);
        this.shp.setBranch(branch);
        this.scp.setBranch(branch);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.scp = new SearchCriteriaPanel();
        this.shp = new SearchHistoryPanel(this.repository, this.info, this.files, this.scp);
        this.add(this.shp);
    }

    protected void componentClosed() {
        this.shp.release();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }
}

