/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Exceptions;
import org.netbeans.modules.cnd.debugger.common2.utils.ListUI;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;

class ExceptionsPanel
extends JPanel
implements PropertyChangeListener,
HelpCtx.Provider {
    private JCheckBox allCheckbox;
    private JCheckBox interceptUnexpectedCheckbox;
    private JCheckBox interceptUnhandledCheckbox;
    private ListUI interceptList;
    private ListUI exceptList;
    private Exceptions exceptions;
    private PropertyEditorSupport propertyEditor;

    public ExceptionsPanel(PropertyEditorSupport propertyEditor, PropertyEnv env, Exceptions exceptions) {
        this.propertyEditor = propertyEditor;
        this.initComponents();
        this.adjustButtons();
        this.setPreferredSize(new Dimension(500, 500));
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
        this.exceptions = exceptions;
        this.initValues(exceptions);
    }

    private void initValues(Exceptions exceptions) {
        String[] nointercepts;
        int i;
        ArrayList<String> col0;
        String[] intercepts = exceptions.getInterceptList();
        if (intercepts != null && intercepts.length > 0) {
            int n = intercepts.length;
            col0 = new ArrayList<String>(intercepts.length + 3);
            for (i = 0; i < intercepts.length; ++i) {
                col0.add(intercepts[i]);
            }
            this.interceptList.model.setData(intercepts.length, col0, null);
        }
        if ((nointercepts = exceptions.getInterceptExceptList()) != null && nointercepts.length > 0) {
            col0 = new ArrayList(nointercepts.length + 3);
            for (i = 0; i < nointercepts.length; ++i) {
                col0.add(nointercepts[i]);
            }
            this.exceptList.model.setData(nointercepts.length, col0, null);
        }
        this.allCheckbox.setSelected(exceptions.isAll());
        this.interceptUnhandledCheckbox.setSelected(exceptions.isInterceptUnhandled());
        this.interceptUnexpectedCheckbox.setSelected(exceptions.isInterceptUnexpected());
        this.adjustButtons();
    }

    private Object getPropertyValue() throws IllegalStateException {
        this.interceptList.model.finishEditing();
        this.exceptList.model.finishEditing();
        String[] intercepts = null;
        int numRows = this.interceptList.model.getRowCount();
        if (numRows > 0) {
            String name;
            int j;
            int num = 0;
            for (j = 0; j < numRows; ++j) {
                name = (String)this.interceptList.model.getValueAt(j, 0);
                if (name.length() == 0) continue;
                ++num;
            }
            intercepts = new String[num];
            num = 0;
            for (j = 0; j < numRows; ++j) {
                name = (String)this.interceptList.model.getValueAt(j, 0);
                if (name.length() == 0) continue;
                intercepts[num++] = name;
            }
        }
        String[] nointercepts = null;
        numRows = this.exceptList.model.getRowCount();
        if (numRows > 0) {
            String name;
            int j;
            int num = 0;
            for (j = 0; j < numRows; ++j) {
                name = (String)this.exceptList.model.getValueAt(j, 0);
                if (name.length() == 0) continue;
                ++num;
            }
            nointercepts = new String[num];
            num = 0;
            for (j = 0; j < numRows; ++j) {
                name = (String)this.exceptList.model.getValueAt(j, 0);
                if (name.length() == 0) continue;
                nointercepts[num++] = name;
            }
        }
        this.exceptions.setInterceptList(intercepts, nointercepts, this.allCheckbox.isSelected(), this.interceptUnhandledCheckbox.isSelected(), this.interceptUnexpectedCheckbox.isSelected());
        return this.exceptions;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.propertyEditor.setValue(this.getPropertyValue());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("DebuggerOptions");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(12, 12, 12, 12);
        EmptyBorder margin = new EmptyBorder(insets);
        CompoundBorder border = new CompoundBorder(new EtchedBorder(), margin);
        this.setBorder(border);
        this.interceptList = new ListUI();
        this.exceptList = new ListUI();
        this.allCheckbox = new JCheckBox();
        this.allCheckbox.setText(Catalog.get("InterceptAll"));
        Catalog.setAccessibleDescription(this.allCheckbox, "ACSD_InterceptAll");
        this.allCheckbox.setMnemonic(Catalog.getMnemonic("MNEM_InterceptAll"));
        this.allCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExceptionsPanel.this.adjustButtons();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.allCheckbox, gridBagConstraints);
        this.interceptList.labelText = Catalog.get("ExceptIntercept");
        this.interceptList.labelMnemonic = Catalog.getMnemonic("MNEM_ExceptIntercept");
        this.interceptList.accessibleDescription = Catalog.get("ACSD_ExceptIntercept");
        this.interceptList.column0Text = Catalog.get("ExceptInterceptTab");
        this.interceptList.addText = Catalog.get("AddIExc");
        this.interceptList.addMnemonic = Catalog.getMnemonic("MNEM_AddN");
        this.interceptList.addActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanel.this.addInterceptExceptionRow(evt);
            }
        };
        this.interceptList.remText = Catalog.get("RemoveIExc");
        this.interceptList.remMnemonic = Catalog.getMnemonic("MNEM_RemN");
        this.interceptList.remActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanel.this.deleteInterceptExceptionRow(evt);
            }
        };
        JPanel interceptPanel = this.interceptList.make(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(11, 0, 0, 0);
        this.add((Component)interceptPanel, gbc);
        this.exceptList.labelText = Catalog.get("ExceptIgnore");
        this.exceptList.labelMnemonic = Catalog.getMnemonic("MNEM_ExceptIgnore");
        this.exceptList.accessibleDescription = Catalog.get("ACSD_ExceptIgnore");
        this.exceptList.column0Text = Catalog.get("ExceptIgnoreTab");
        this.exceptList.addText = Catalog.get("AddXExc");
        this.exceptList.addMnemonic = Catalog.getMnemonic("MNEM_AddG");
        this.exceptList.addActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanel.this.addIgnoreExceptionRow(evt);
            }
        };
        this.exceptList.remText = Catalog.get("RemoveXExc");
        this.exceptList.remMnemonic = Catalog.getMnemonic("MNEM_RemG");
        this.exceptList.remActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanel.this.deleteIgnoreExceptionRow(evt);
            }
        };
        JPanel exceptPanel = this.exceptList.make(true);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(11, 0, 0, 0);
        this.add((Component)exceptPanel, gbc);
        this.interceptUnexpectedCheckbox = new JCheckBox();
        this.interceptUnexpectedCheckbox.setText(Catalog.get("InterceptUnexpected"));
        Catalog.setAccessibleDescription(this.interceptUnexpectedCheckbox, "ACSD_Unexpected");
        this.interceptUnexpectedCheckbox.setMnemonic(Catalog.getMnemonic("MNEM_Unexpected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.interceptUnexpectedCheckbox, gridBagConstraints);
        this.interceptUnhandledCheckbox = new JCheckBox();
        this.interceptUnhandledCheckbox.setText(Catalog.get("InterceptUnhandled"));
        Catalog.setAccessibleDescription(this.interceptUnhandledCheckbox, "ACSD_Unhandled");
        this.interceptUnhandledCheckbox.setMnemonic(Catalog.getMnemonic("MNEM_Unhandled"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.interceptUnhandledCheckbox, gridBagConstraints);
    }

    private void adjustButtons() {
        boolean all = this.allCheckbox.isSelected();
        this.interceptList.adjustButtons(all);
        this.exceptList.adjustButtons(false);
    }

    private JTable makeJTable(TableModel model) {
        JTable table = new JTable(model);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExceptionsPanel.this.adjustButtons();
            }
        });
        table.setTableHeader(null);
        return table;
    }

    private void deleteInterceptExceptionRow(ActionEvent evt) {
        int[] selRows = this.interceptList.table.getSelectedRows();
        if (selRows != null && selRows.length > 0) {
            this.interceptList.model.removeRows(selRows);
            this.adjustButtons();
        }
    }

    private void addInterceptExceptionRow(ActionEvent evt) {
        this.interceptList.model.addRow();
        this.adjustButtons();
    }

    private void deleteIgnoreExceptionRow(ActionEvent evt) {
        int[] selRows = this.exceptList.table.getSelectedRows();
        if (selRows != null && selRows.length > 0) {
            this.exceptList.model.removeRows(selRows);
            this.adjustButtons();
        }
    }

    private void addIgnoreExceptionRow(ActionEvent evt) {
        this.exceptList.model.addRow();
        this.adjustButtons();
    }
}

